/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.env;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.EndpointExposure;
import org.springframework.boot.actuate.autoconfigure.env.EnvironmentEndpointProperties;
import org.springframework.boot.actuate.endpoint.SanitizingFunction;
import org.springframework.boot.actuate.env.EnvironmentEndpoint;
import org.springframework.boot.actuate.env.EnvironmentEndpointWebExtension;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

@AutoConfiguration
@ConditionalOnAvailableEndpoint(value=EnvironmentEndpoint.class)
@EnableConfigurationProperties(value={EnvironmentEndpointProperties.class})
public class EnvironmentEndpointAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public EnvironmentEndpoint environmentEndpoint(Environment environment, EnvironmentEndpointProperties properties, ObjectProvider<SanitizingFunction> sanitizingFunctions) {
        return new EnvironmentEndpoint(environment, sanitizingFunctions.orderedStream().toList(), properties.getShowValues());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={EnvironmentEndpoint.class})
    @ConditionalOnAvailableEndpoint(exposure={EndpointExposure.WEB})
    public EnvironmentEndpointWebExtension environmentEndpointWebExtension(EnvironmentEndpoint environmentEndpoint, EnvironmentEndpointProperties properties) {
        return new EnvironmentEndpointWebExtension(environmentEndpoint, properties.getShowValues(), properties.getRoles());
    }
}

