/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.wavefront;

import com.wavefront.sdk.entities.histograms.WavefrontHistogramImpl;
import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.cumulative.CumulativeTimer;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

class WavefrontTimer
extends CumulativeTimer {
    @Nullable
    private final WavefrontHistogramImpl delegate;

    WavefrontTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector, TimeUnit baseTimeUnit) {
        super(id, clock, distributionStatisticConfig, pauseDetector, baseTimeUnit, false);
        this.delegate = distributionStatisticConfig.isPublishingHistogram() ? new WavefrontHistogramImpl(() -> ((Clock)clock).wallTime()) : null;
    }

    protected void recordNonNegative(long amount, TimeUnit unit) {
        super.recordNonNegative(amount, unit);
        if (this.delegate != null) {
            this.delegate.update(TimeUtils.convert((double)amount, (TimeUnit)unit, (TimeUnit)this.baseTimeUnit()));
        }
    }

    List<WavefrontHistogramImpl.Distribution> flushDistributions() {
        if (this.delegate == null) {
            return Collections.emptyList();
        }
        return this.delegate.flushDistributions();
    }

    boolean isPublishingHistogram() {
        return this.delegate != null;
    }
}

