/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.persondir.groovy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.attribute.SimpleUsernameAttributeProvider;
import org.apereo.cas.authentication.principal.attribute.PersonAttributes;
import org.apereo.cas.authentication.principal.attribute.UsernameAttributeProvider;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.GroovyPrincipalAttributesProperties;
import org.apereo.cas.persondir.groovy.PersonAttributeScriptDao;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.scripting.ExecutableCompiledScript;
import org.apereo.cas.util.scripting.ExecutableCompiledScriptFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class InternalGroovyScriptDao
implements PersonAttributeScriptDao {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalGroovyScriptDao.class);
    private final UsernameAttributeProvider usernameAttributeProvider = new SimpleUsernameAttributeProvider("username");
    private final ApplicationContext applicationContext;
    private final CasConfigurationProperties casProperties;
    private final GroovyPrincipalAttributesProperties groovyPrincipalAttributesProperties;

    @Override
    public Map<String, List<Object>> getPersonAttributesFromMultivaluedAttributes(Map<String, List<Object>> attributes, Set<PersonAttributes> resultPeople) {
        String username = this.usernameAttributeProvider.getUsernameFromQuery(attributes);
        HashMap<String, List<Object>> results = new HashMap<String, List<Object>>();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            FunctionUtils.doAndHandle(__ -> {
                HashMap allAttributes = new HashMap(attributes);
                if (resultPeople != null && !resultPeople.isEmpty()) {
                    allAttributes.put("people", new ArrayList(resultPeople));
                }
                Object[] args = new Object[]{username, allAttributes, LOGGER, this.casProperties, this.applicationContext};
                ExecutableCompiledScriptFactory scriptFactory = ExecutableCompiledScriptFactory.getExecutableCompiledScriptFactory();
                ExecutableCompiledScript script = scriptFactory.fromResource(this.groovyPrincipalAttributesProperties.getLocation());
                Map finalAttributes = (Map)script.execute(args, Map.class, true);
                LOGGER.debug("Groovy-based attributes found are [{}]", (Object)finalAttributes);
                finalAttributes.forEach((key, v) -> {
                    ArrayList values = new ArrayList(CollectionUtils.toCollection((Object)v));
                    LOGGER.trace("Adding Groovy-based attribute [{}] with value(s) [{}]", key, values);
                    results.put((String)key, values);
                });
            });
        }
        return results;
    }

    @Generated
    public InternalGroovyScriptDao(ApplicationContext applicationContext, CasConfigurationProperties casProperties, GroovyPrincipalAttributesProperties groovyPrincipalAttributesProperties) {
        this.applicationContext = applicationContext;
        this.casProperties = casProperties;
        this.groovyPrincipalAttributesProperties = groovyPrincipalAttributesProperties;
    }
}

