/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.authentication.principal.ShibbolethCompatiblePersistentIdGenerator;
import org.apereo.cas.configuration.support.ExpressionLanguageCapable;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.support.saml.services.BaseSamlRegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceMetadataAdaptor;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EduPersonTargetedIdAttributeReleasePolicy
extends BaseSamlRegisteredServiceAttributeReleasePolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(EduPersonTargetedIdAttributeReleasePolicy.class);
    public static final String ATTRIBUTE_NAME_EDU_PERSON_TARGETED_ID = "eduPersonTargetedID";
    public static final String ATTRIBUTE_URN_EDU_PERSON_TARGETED_ID = "urn:oid:1.3.6.1.4.1.5923.1.1.1.10";
    private static final long serialVersionUID = -1283755507124862357L;
    @JsonProperty
    @ExpressionLanguageCapable
    private String salt;
    @JsonProperty
    @ExpressionLanguageCapable
    private String attribute;
    @JsonProperty
    private boolean useUniformResourceName;

    @Override
    protected Map<String, List<Object>> getAttributesForSamlRegisteredService(Map<String, List<Object>> attributes, SamlRegisteredServiceCachingMetadataResolver resolver, SamlRegisteredServiceMetadataAdaptor facade, EntityDescriptor entityDescriptor, RegisteredServiceAttributeReleasePolicyContext context) {
        HashMap<String, List<Object>> releaseAttributes = new HashMap<String, List<Object>>();
        String resolvedSalt = SpringExpressionLanguageValueResolver.getInstance().resolve(this.salt);
        ShibbolethCompatiblePersistentIdGenerator persistentIdGenerator = new ShibbolethCompatiblePersistentIdGenerator(resolvedSalt);
        String resolvedAttrs = SpringExpressionLanguageValueResolver.getInstance().resolve(this.attribute);
        persistentIdGenerator.setAttribute(resolvedAttrs);
        String principalId = persistentIdGenerator.determinePrincipalIdFromAttributes(context.getPrincipal().getId(), attributes);
        LOGGER.debug("Selected principal id [{}] to generate [{}] for service [{}]", new Object[]{principalId, ATTRIBUTE_NAME_EDU_PERSON_TARGETED_ID, context.getService()});
        String result = persistentIdGenerator.generate(principalId, context.getService());
        String attrName = this.useUniformResourceName ? ATTRIBUTE_URN_EDU_PERSON_TARGETED_ID : ATTRIBUTE_NAME_EDU_PERSON_TARGETED_ID;
        releaseAttributes.put(attrName, CollectionUtils.wrapList((Object[])new Object[]{result}));
        LOGGER.debug("Calculated [{}] attribute as [{}]", (Object)attrName, (Object)result);
        return releaseAttributes;
    }

    protected List<String> determineRequestedAttributeDefinitions(RegisteredServiceAttributeReleasePolicyContext context) {
        return this.useUniformResourceName ? CollectionUtils.wrapList((Object[])new String[]{ATTRIBUTE_URN_EDU_PERSON_TARGETED_ID}) : CollectionUtils.wrapList((Object[])new String[]{ATTRIBUTE_NAME_EDU_PERSON_TARGETED_ID});
    }

    @Generated
    public String toString() {
        return "EduPersonTargetedIdAttributeReleasePolicy(super=" + super.toString() + ", salt=" + this.salt + ", attribute=" + this.attribute + ", useUniformResourceName=" + this.useUniformResourceName + ")";
    }

    @JsonProperty
    @Generated
    public void setSalt(String salt) {
        this.salt = salt;
    }

    @JsonProperty
    @Generated
    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    @JsonProperty
    @Generated
    public void setUseUniformResourceName(boolean useUniformResourceName) {
        this.useUniformResourceName = useUniformResourceName;
    }

    @Generated
    public String getSalt() {
        return this.salt;
    }

    @Generated
    public String getAttribute() {
        return this.attribute;
    }

    @Generated
    public boolean isUseUniformResourceName() {
        return this.useUniformResourceName;
    }

    @Generated
    public EduPersonTargetedIdAttributeReleasePolicy(String salt, String attribute, boolean useUniformResourceName) {
        this.salt = salt;
        this.attribute = attribute;
        this.useUniformResourceName = useUniformResourceName;
    }

    @Generated
    public EduPersonTargetedIdAttributeReleasePolicy() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EduPersonTargetedIdAttributeReleasePolicy)) {
            return false;
        }
        EduPersonTargetedIdAttributeReleasePolicy other = (EduPersonTargetedIdAttributeReleasePolicy)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.useUniformResourceName != other.useUniformResourceName) {
            return false;
        }
        String this$salt = this.salt;
        String other$salt = other.salt;
        if (this$salt == null ? other$salt != null : !this$salt.equals(other$salt)) {
            return false;
        }
        String this$attribute = this.attribute;
        String other$attribute = other.attribute;
        return !(this$attribute == null ? other$attribute != null : !this$attribute.equals(other$attribute));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EduPersonTargetedIdAttributeReleasePolicy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.useUniformResourceName ? 79 : 97);
        String $salt = this.salt;
        result = result * 59 + ($salt == null ? 43 : $salt.hashCode());
        String $attribute = this.attribute;
        result = result * 59 + ($attribute == null ? 43 : $attribute.hashCode());
        return result;
    }
}

