/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.syncope;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.net.ssl.SSLHandshakeException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.net.URIBuilder;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.model.support.syncope.BaseSyncopeSearchProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpExecutionRequest;
import org.apereo.cas.util.http.HttpUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public final class SyncopeUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncopeUtils.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();

    public static Map<String, List<Object>> convertFromUserEntity(JsonNode user, Map<String, String> attributeMappings) {
        List<Map<String, String>> memberships;
        String name;
        HashMap<String, List<Object>> attributes = new HashMap<String, List<Object>>();
        if (user.has("securityQuestion") && !user.get("securityQuestion").isNull()) {
            name = attributeMappings.getOrDefault("securityQuestion", "syncopeUserSecurityQuestion");
            attributes.put(name, CollectionUtils.wrapList((Object[])new Object[]{user.get("securityQuestion").asText()}));
        }
        name = attributeMappings.getOrDefault("key", "syncopeUserKey");
        attributes.put(name, CollectionUtils.wrapList((Object[])new Object[]{user.get("key").asText()}));
        name = attributeMappings.getOrDefault("username", "username");
        attributes.put(name, CollectionUtils.wrapList((Object[])new Object[]{user.get("username").asText()}));
        name = attributeMappings.getOrDefault("status", "syncopeUserStatus");
        attributes.put(name, CollectionUtils.wrapList((Object[])new Object[]{user.get("status").asText()}));
        name = attributeMappings.getOrDefault("realm", "syncopeUserRealm");
        attributes.put(name, CollectionUtils.wrapList((Object[])new Object[]{user.get("realm").asText()}));
        name = attributeMappings.getOrDefault("creator", "syncopeUserCreator");
        attributes.put(name, CollectionUtils.wrapList((Object[])new Object[]{user.get("creator").asText()}));
        name = attributeMappings.getOrDefault("creationDate", "syncopeUserCreationDate");
        attributes.put(name, CollectionUtils.wrapList((Object[])new Object[]{user.get("creationDate").asText()}));
        if (user.has("changePwdDate") && !user.get("changePwdDate").isNull()) {
            name = attributeMappings.getOrDefault("changePwdDate", "syncopeUserChangePwdDate");
            attributes.put(name, CollectionUtils.wrapList((Object[])new Object[]{user.get("changePwdDate").asText()}));
        }
        if (user.has("lastLoginDate") && !user.get("lastLoginDate").isNull()) {
            name = attributeMappings.getOrDefault("lastLoginDate", "syncopeUserLastLoginDate");
            attributes.put(name, CollectionUtils.wrapList((Object[])new Object[]{user.get("lastLoginDate").asText()}));
        }
        SyncopeUtils.collectListableAttribute(attributes, user, "roles", "syncopeUserRoles", attributeMappings);
        SyncopeUtils.collectListableAttribute(attributes, user, "dynRoles", "syncopeUserDynRoles", attributeMappings);
        SyncopeUtils.collectListableAttribute(attributes, user, "dynRealms", "syncopeUserDynRealms", attributeMappings);
        if (user.has("memberships") && !(memberships = SyncopeUtils.mapSyncopeGroupMemberhips(user)).isEmpty()) {
            name = attributeMappings.getOrDefault("memberships", "syncopeUserMemberships");
            attributes.put(name, new ArrayList<Map<String, String>>(memberships));
        }
        if (user.has("dynMemberships")) {
            ArrayList dynMemberships = new ArrayList();
            user.get("dynMemberships").forEach(m -> dynMemberships.add(m.get("groupName").asText()));
            if (!dynMemberships.isEmpty()) {
                name = attributeMappings.getOrDefault("dynMemberships", "syncopeUserDynMemberships");
                attributes.put(name, dynMemberships);
            }
        }
        if (user.has("relationships")) {
            ArrayList relationships = new ArrayList();
            user.get("relationships").forEach(r -> relationships.add(r.get("type").asText() + ";" + r.get("otherEndName").asText()));
            if (!relationships.isEmpty()) {
                name = attributeMappings.getOrDefault("relationships", "syncopeUserRelationships");
                attributes.put(name, relationships);
            }
        }
        SyncopeUtils.mapSyncopeUserAttributes(user, "plainAttrs", attributeMappings, attributes);
        SyncopeUtils.mapSyncopeUserAttributes(user, "derAttrs", attributeMappings, attributes);
        SyncopeUtils.mapSyncopeUserAttributes(user, "virAttrs", attributeMappings, attributes);
        return attributes;
    }

    private static List<Map<String, String>> mapSyncopeGroupMemberhips(JsonNode user) {
        ArrayList<Map<String, String>> memberships = new ArrayList<Map<String, String>>();
        user.get("memberships").forEach(member -> {
            HashMap<String, String> membershipInfo = new HashMap<String, String>();
            membershipInfo.put("groupName", member.get("groupName").asText());
            if (member.has("plainAttrs")) {
                member.get("plainAttrs").forEach(attr -> membershipInfo.put(attr.get("schema").asText(), attr.get("values").toString()));
                memberships.add(membershipInfo);
            }
        });
        return memberships;
    }

    private static void mapSyncopeUserAttributes(JsonNode user, String attributeName, Map<String, String> attributeMappings, Map<String, List<Object>> attributes) {
        if (user.has(attributeName)) {
            String prefix = attributeMappings.getOrDefault(attributeName, "syncopeUserAttr_");
            user.get(attributeName).forEach(attr -> {
                String attrName = prefix + attr.get("schema").asText();
                attributes.put((String)((Object)attributeMappings.getOrDefault(attrName, attrName)), (List)MAPPER.convertValue((Object)attr.get("values"), ArrayList.class));
            });
        }
    }

    private static void collectListableAttribute(Map<String, List<Object>> attributes, JsonNode user, String syncopeAttribute, String casAttribute, Map<String, String> attributeMappings) {
        List values;
        List list = values = user.has(syncopeAttribute) ? (List)MAPPER.convertValue((Object)user.get(syncopeAttribute), ArrayList.class) : CollectionUtils.wrapList((Object[])new Object[0]);
        if (!values.isEmpty()) {
            String name = attributeMappings.getOrDefault(syncopeAttribute, casAttribute);
            attributes.put(name, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, List<Object>>> syncopeUserSearch(BaseSyncopeSearchProperties properties, String user) {
        HttpResponse response;
        block2: {
            List list;
            response = null;
            try {
                String filter = properties.getSearchFilter().replace("{user}", user).replace("{0}", user);
                String fiql = EncodingUtils.urlEncode((String)filter);
                String syncopeRestUrl = StringUtils.appendIfMissing((String)SpringExpressionLanguageValueResolver.getInstance().resolve(properties.getUrl()), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + "rest/users/?page=1&size=1&details=true&fiql=" + fiql;
                LOGGER.debug("Executing Syncope search via [{}]", (Object)syncopeRestUrl);
                LinkedHashMap<String, String> requestHeaders = new LinkedHashMap<String, String>();
                requestHeaders.put("X-Syncope-Domain", properties.getDomain());
                requestHeaders.putAll(properties.getHeaders());
                HttpExecutionRequest exec = HttpExecutionRequest.builder().method(HttpMethod.GET).url(syncopeRestUrl).basicAuthUsername(properties.getBasicAuthUsername()).basicAuthPassword(properties.getBasicAuthPassword()).headers(requestHeaders).build();
                response = Objects.requireNonNull(HttpUtils.execute((HttpExecutionRequest)exec));
                LOGGER.debug("Received http response status as [{}]", (Object)response.getReasonPhrase());
                if (!HttpStatus.resolve((int)response.getCode()).is2xxSuccessful()) break block2;
                HttpEntity entity = ((HttpEntityContainer)response).getEntity();
                list = (List)FunctionUtils.doUnchecked(() -> {
                    String result = EntityUtils.toString((HttpEntity)entity);
                    LOGGER.debug("Received user entity as [{}]", (Object)result);
                    Iterator it = Optional.of(MAPPER.readTree(result)).filter(sr -> sr.has("result")).map(sr -> sr.get("result")).map(JsonNode::iterator).orElse(Collections.emptyIterator());
                    return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false).map(node -> SyncopeUtils.convertFromUserEntity(node, properties.getAttributeMappings())).collect(Collectors.toList());
                });
            }
            catch (Throwable throwable) {
                HttpUtils.close(response);
                throw throwable;
            }
            HttpUtils.close((HttpResponse)response);
            return list;
        }
        HttpUtils.close((HttpResponse)response);
        return new ArrayList<Map<String, List<Object>>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, List<Object>>> syncopeUserGroupsSearch(BaseSyncopeSearchProperties properties, String user) {
        HttpResponse response;
        block2: {
            List list;
            response = null;
            try {
                String fiql = EncodingUtils.urlEncode((String)"$member==%s".formatted(user));
                String syncopeRestUrl = StringUtils.appendIfMissing((String)SpringExpressionLanguageValueResolver.getInstance().resolve(properties.getUrl()), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + "rest/groups/?page=1&size=50&details=true&fiql=" + fiql;
                LOGGER.debug("Executing Syncope user group search via [{}]", (Object)syncopeRestUrl);
                LinkedHashMap<String, String> requestHeaders = new LinkedHashMap<String, String>();
                requestHeaders.put("X-Syncope-Domain", properties.getDomain());
                requestHeaders.putAll(properties.getHeaders());
                HttpExecutionRequest exec = HttpExecutionRequest.builder().method(HttpMethod.GET).url(syncopeRestUrl).basicAuthUsername(properties.getBasicAuthUsername()).basicAuthPassword(properties.getBasicAuthPassword()).headers(requestHeaders).build();
                response = Objects.requireNonNull(HttpUtils.execute((HttpExecutionRequest)exec));
                if (!Objects.requireNonNull(HttpStatus.resolve((int)response.getCode())).is2xxSuccessful()) break block2;
                HttpEntity entity = ((HttpEntityContainer)response).getEntity();
                list = (List)FunctionUtils.doUnchecked(() -> {
                    String result = EntityUtils.toString((HttpEntity)entity);
                    Iterator it = Optional.of(MAPPER.readTree(result)).filter(sr -> sr.has("result")).map(sr -> sr.get("result")).map(JsonNode::iterator).orElse(Collections.emptyIterator());
                    ArrayList groups = new ArrayList();
                    StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false).forEach(node -> SyncopeUtils.convertFromGroupEntity(node, groups));
                    String name = properties.getAttributeMappings().getOrDefault("groups", "syncopeUserGroups");
                    HashMap attributes = new HashMap();
                    attributes.put(name, groups);
                    return List.of(attributes);
                });
            }
            catch (Throwable throwable) {
                HttpUtils.close(response);
                throw throwable;
            }
            HttpUtils.close((HttpResponse)response);
            return list;
        }
        HttpUtils.close((HttpResponse)response);
        return new ArrayList<Map<String, List<Object>>>();
    }

    private static void convertFromGroupEntity(JsonNode group, List<Object> attributes) {
        HashMap<String, String> groupAttrs = new HashMap<String, String>();
        groupAttrs.put("groupName", group.get("name").asText());
        group.get("plainAttrs").forEach(attr -> groupAttrs.put(attr.get("schema").asText(), attr.get("values").toString()));
        attributes.add(groupAttrs);
    }

    public static Map<String, Object> convertToUserCreateEntity(Principal principal, String realm) {
        LinkedHashMap<String, Object> entity = new LinkedHashMap<String, Object>();
        entity.put("_class", "org.apache.syncope.common.lib.request.UserCR");
        entity.put("realm", StringUtils.prependIfMissing((String)realm, (CharSequence)"/", (CharSequence[])new CharSequence[0]));
        entity.put("username", principal.getId());
        ArrayList plainAttrs = new ArrayList();
        principal.getAttributes().entrySet().stream().filter(entry -> !"username".equals(entry.getKey()) && !"password".equals(entry.getKey())).forEach(entry -> plainAttrs.add(Map.of("schema", entry.getKey(), "values", CollectionUtils.toCollection(entry.getValue()))));
        entity.put("plainAttrs", plainAttrs);
        return entity;
    }

    public static Map<String, Object> convertToUserCreateEntity(Map<String, ?> userProperties, UsernamePasswordCredential credential, String realm) {
        LinkedHashMap<String, Object> entity = new LinkedHashMap<String, Object>();
        entity.put("_class", "org.apache.syncope.common.lib.request.UserCR");
        entity.put("realm", StringUtils.prependIfMissing((String)realm, (CharSequence)"/", (CharSequence[])new CharSequence[0]));
        entity.put("username", credential.getUsername());
        entity.put("password", credential.getPassword());
        ArrayList plainAttrs = new ArrayList();
        userProperties.entrySet().stream().filter(entry -> !"username".equals(entry.getKey()) && !"password".equals(entry.getKey())).forEach(entry -> plainAttrs.add(Map.of("schema", entry.getKey(), "values", CollectionUtils.toCollection(entry.getValue()))));
        entity.put("plainAttrs", plainAttrs);
        return entity;
    }

    public static Map<String, Object> convertToUserUpdateEntity(Principal principal, String realm) {
        LinkedHashMap<String, Object> entity = new LinkedHashMap<String, Object>();
        entity.put("_class", "org.apache.syncope.common.lib.request.UserUR");
        entity.put("key", principal.getId());
        entity.put("realm", Map.of("operation", "ADD_REPLACE", "value", realm));
        ArrayList plainAttrs = new ArrayList();
        principal.getAttributes().entrySet().stream().filter(entry -> !"username".equals(entry.getKey()) && !"password".equals(entry.getKey())).forEach(entry -> {
            Map<String, Map<String, Set>> attribute = Map.of("operation", "ADD_REPLACE", "attr", Map.of("schema", entry.getKey(), "values", CollectionUtils.toCollection(entry.getValue())));
            plainAttrs.add(attribute);
        });
        entity.put("plainAttrs", plainAttrs);
        return entity;
    }

    public static HttpResponse execute(HttpExecutionRequest execution) {
        URI uri = HttpUtils.buildHttpUri((String)execution.getUrl().trim(), (Map)execution.getParameters());
        HttpUriRequest request = HttpUtils.getHttpRequestByMethod((String)execution.getMethod().name().toLowerCase(Locale.ENGLISH).trim(), (String)execution.getEntity(), (URI)uri);
        try {
            SpringExpressionLanguageValueResolver expressionResolver = SpringExpressionLanguageValueResolver.getInstance();
            execution.getHeaders().forEach((key, value) -> {
                String headerValue = expressionResolver.resolve(value);
                String headerKey = expressionResolver.resolve(key);
                request.addHeader(headerKey, (Object)headerValue);
            });
            HttpUtils.prepareHttpRequest((HttpUriRequest)request, (HttpExecutionRequest)execution);
            CloseableHttpClient client = HttpUtils.getHttpClient((HttpExecutionRequest)execution);
            return (HttpResponse)FunctionUtils.doAndRetry(retryContext -> {
                Integer maxAttempts;
                LOGGER.trace("Sending HTTP request to [{}]. Attempt: [{}]", (Object)request.getUri(), (Object)retryContext.getRetryCount());
                CloseableHttpResponse res = client.execute((ClassicHttpRequest)request);
                if ((res == null || HttpStatus.valueOf((int)res.getCode()).isError()) && (maxAttempts = (Integer)retryContext.getAttribute("retry.maxAttempts")) != null && retryContext.getRetryCount() != maxAttempts - 1) {
                    return res;
                }
                return res;
            }, (int)execution.getMaximumRetryAttempts());
        }
        catch (SSLHandshakeException e) {
            String sanitizedUrl = (String)FunctionUtils.doUnchecked(() -> new URIBuilder(execution.getUrl()).removeQuery().clearParameters().build().toASCIIString());
            LoggingUtils.error((Logger)LOGGER, (String)("SSL error accessing: [" + sanitizedUrl + "]"), (Throwable)e);
            return new BasicHttpResponse(500, sanitizedUrl);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return null;
        }
    }

    @Generated
    private SyncopeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

