/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logout.slo;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.logout.LogoutManager;
import org.apereo.cas.logout.LogoutRequestStatus;
import org.apereo.cas.logout.slo.SingleLogoutExecutionRequest;
import org.apereo.cas.logout.slo.SingleLogoutRequestContext;
import org.apereo.cas.logout.slo.SingleLogoutRequestExecutor;
import org.apereo.cas.support.events.ticket.CasTicketGrantingTicketDestroyedEvent;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

public class DefaultSingleLogoutRequestExecutor
implements SingleLogoutRequestExecutor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSingleLogoutRequestExecutor.class);
    private final TicketRegistry ticketRegistry;
    private final LogoutManager logoutManager;
    private final ApplicationContext applicationContext;

    public List<SingleLogoutRequestContext> execute(String ticketId, HttpServletRequest request, HttpServletResponse response) {
        try {
            TicketGrantingTicket tgt;
            Ticket ticket = this.ticketRegistry.getTicket(ticketId, Ticket.class);
            LOGGER.debug("Ticket [{}] found. Processing logout requests and then deleting the ticket...", (Object)ticket.getId());
            ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
            ArrayList<SingleLogoutRequestContext> logoutRequests = new ArrayList<SingleLogoutRequestContext>();
            if (ticket instanceof TicketGrantingTicket) {
                tgt = (TicketGrantingTicket)ticket;
                List results = this.logoutManager.performLogout(SingleLogoutExecutionRequest.builder().ticketGrantingTicket(tgt).httpServletRequest(Optional.of(request)).httpServletResponse(Optional.of(response)).build());
                results.stream().filter(r -> r.getStatus() == LogoutRequestStatus.FAILURE).forEach(r -> LOGGER.warn("Logout request for [{}] and [{}] has failed", (Object)r.getTicketId(), (Object)r.getLogoutUrl()));
                logoutRequests.addAll(results);
            }
            LOGGER.trace("Removing ticket [{}] from registry...", (Object)ticketId);
            this.ticketRegistry.deleteTicket(ticketId);
            if (ticket instanceof TicketGrantingTicket) {
                tgt = (TicketGrantingTicket)ticket;
                this.applicationContext.publishEvent((ApplicationEvent)new CasTicketGrantingTicketDestroyedEvent((Object)this, tgt, clientInfo));
            }
            return logoutRequests;
        }
        catch (Exception e) {
            String msg = String.format("Ticket-granting ticket [%s] cannot be found in the ticket registry.", ticketId);
            LOGGER.debug(msg, (Throwable)e);
            return new ArrayList<SingleLogoutRequestContext>();
        }
    }

    @Generated
    public DefaultSingleLogoutRequestExecutor(TicketRegistry ticketRegistry, LogoutManager logoutManager, ApplicationContext applicationContext) {
        this.ticketRegistry = ticketRegistry;
        this.logoutManager = logoutManager;
        this.applicationContext = applicationContext;
    }
}

