/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.config.ConfigDataActivationContext;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationBindHandler;
import org.springframework.boot.context.config.Profiles;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.Name;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.util.ObjectUtils;

class ConfigDataProperties {
    private static final ConfigurationPropertyName NAME = ConfigurationPropertyName.of("spring.config");
    private static final Bindable<ConfigDataProperties> BINDABLE_PROPERTIES = Bindable.of(ConfigDataProperties.class);
    private final List<ConfigDataLocation> imports;
    private final Activate activate;

    ConfigDataProperties(@Name(value="import") List<ConfigDataLocation> imports, Activate activate) {
        this.imports = imports != null ? imports : Collections.emptyList();
        this.activate = activate;
    }

    List<ConfigDataLocation> getImports() {
        return this.imports;
    }

    boolean isActive(ConfigDataActivationContext activationContext) {
        return this.activate == null || this.activate.isActive(activationContext);
    }

    ConfigDataProperties withoutImports() {
        return new ConfigDataProperties(null, this.activate);
    }

    static ConfigDataProperties get(Binder binder) {
        return binder.bind(NAME, BINDABLE_PROPERTIES, (BindHandler)new ConfigDataLocationBindHandler()).orElse(null);
    }

    static class Activate {
        private final CloudPlatform onCloudPlatform;
        private final String[] onProfile;

        Activate(CloudPlatform onCloudPlatform, String[] onProfile) {
            this.onProfile = onProfile;
            this.onCloudPlatform = onCloudPlatform;
        }

        boolean isActive(ConfigDataActivationContext activationContext) {
            if (activationContext == null) {
                return false;
            }
            CloudPlatform cloudPlatform = activationContext.getCloudPlatform();
            boolean activate = this.isActive(cloudPlatform != null ? cloudPlatform : CloudPlatform.NONE);
            activate = activate && this.isActive(activationContext.getProfiles());
            return activate;
        }

        private boolean isActive(CloudPlatform cloudPlatform) {
            return this.onCloudPlatform == null || this.onCloudPlatform == cloudPlatform;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isActive(Profiles profiles) {
            if (ObjectUtils.isEmpty((Object[])this.onProfile)) return true;
            if (profiles == null) return false;
            if (!this.matchesActiveProfiles(profiles::isAccepted)) return false;
            return true;
        }

        private boolean matchesActiveProfiles(Predicate<String> activeProfiles) {
            return org.springframework.core.env.Profiles.of((String[])this.onProfile).matches(activeProfiles);
        }
    }
}

