/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apereo.cas.authentication.attribute.StubPersonAttributeDao;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.AttributeRepositoryStates;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesProperties;
import org.apereo.cas.configuration.model.core.authentication.StubPrincipalAttributesProperties;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlanConfigurer;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.util.StringUtils;

@Configuration(value="CasPersonDirectoryStubConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.PersonDirectory}, module="stub")
class CasPersonDirectoryStubConfiguration {
    CasPersonDirectoryStubConfiguration() {
    }

    @Configuration(value="StubAttributeRepositoryPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class StubAttributeRepositoryPlanConfiguration {
        StubAttributeRepositoryPlanConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"stubPersonDirectoryAttributeRepositoryPlanConfigurer"})
        public PersonDirectoryAttributeRepositoryPlanConfigurer stubPersonDirectoryAttributeRepositoryPlanConfigurer(@Qualifier(value="stubAttributeRepositories") BeanContainer<PersonAttributeDao> stubAttributeRepositories) {
            return plan -> {
                List results = stubAttributeRepositories.toList().stream().filter(PersonAttributeDao::isEnabled).collect(Collectors.toList());
                plan.registerAttributeRepositories(results);
            };
        }
    }

    @Configuration(value="StubAttributeRepositoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class StubAttributeRepositoryConfiguration {
        StubAttributeRepositoryConfiguration() {
        }

        @ConditionalOnMissingBean(name={"stubAttributeRepositories"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BeanContainer<PersonAttributeDao> stubAttributeRepositories(CasConfigurationProperties casProperties) {
            ArrayList<PersonAttributeDao> list = new ArrayList<PersonAttributeDao>();
            StubPrincipalAttributesProperties stub = casProperties.getAuthn().getAttributeRepository().getStub();
            Map attrs = stub.getAttributes();
            if (!attrs.isEmpty()) {
                PersonAttributeDao dao = StubAttributeRepositoryConfiguration.newStubAttributeRepository(casProperties.getAuthn().getAttributeRepository());
                list.add(dao);
            }
            return BeanContainer.of(list);
        }

        private static PersonAttributeDao newStubAttributeRepository(PrincipalAttributesProperties properties) {
            StubPersonAttributeDao dao = new StubPersonAttributeDao();
            LinkedHashMap backingMap = new LinkedHashMap();
            StubPrincipalAttributesProperties stub = properties.getStub();
            stub.getAttributes().forEach((key, value) -> {
                String[] vals = StringUtils.commaDelimitedListToStringArray((String)value);
                backingMap.put(key, Arrays.stream(vals).map(v -> {
                    Boolean result = BooleanUtils.toBooleanObject((String)v);
                    if (result != null) {
                        return result;
                    }
                    return v;
                }).collect(Collectors.toList()));
            });
            dao.setBackingMap(backingMap);
            dao.setOrder(stub.getOrder());
            dao.setEnabled(stub.getState() != AttributeRepositoryStates.DISABLED);
            dao.putTag("state", (Object)(stub.getState() == AttributeRepositoryStates.ACTIVE ? 1 : 0));
            if (StringUtils.hasText((String)stub.getId())) {
                dao.setId(new String[]{stub.getId()});
            }
            return dao;
        }
    }
}

