/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.Comparator;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.utils.Bytes;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BytesTest {
    @Test
    public void testIncrement() {
        byte[] input = new byte[]{-85, -51, -1};
        byte[] expected = new byte[]{-85, -50, 0};
        Bytes output = Bytes.increment((Bytes)Bytes.wrap((byte[])input));
        Assertions.assertArrayEquals((byte[])output.get(), (byte[])expected);
    }

    @Test
    public void testIncrementUpperBoundary() {
        byte[] input = new byte[]{-1, -1, -1};
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> Bytes.increment((Bytes)Bytes.wrap((byte[])input)));
    }

    @Test
    public void testIncrementWithSubmap() {
        TreeMap<Bytes, byte[]> map = new TreeMap<Bytes, byte[]>();
        Bytes key1 = Bytes.wrap((byte[])new byte[]{-86});
        byte[] val = new byte[]{0};
        map.put(key1, val);
        Bytes key2 = Bytes.wrap((byte[])new byte[]{-86, -86});
        map.put(key2, val);
        Bytes key3 = Bytes.wrap((byte[])new byte[]{-86, 0, -1, -1, -1});
        map.put(key3, val);
        Bytes key4 = Bytes.wrap((byte[])new byte[]{-85, 0});
        map.put(key4, val);
        Bytes key5 = Bytes.wrap((byte[])new byte[]{0, 0, 0, 1});
        map.put(key5, val);
        Bytes prefix = key1;
        Bytes prefixEnd = Bytes.increment((Bytes)prefix);
        Comparator comparator = map.comparator();
        int result = comparator == null ? prefix.compareTo(prefixEnd) : comparator.compare(prefix, prefixEnd);
        NavigableMap subMapResults = result > 0 ? map.tailMap(prefix, true) : map.subMap(prefix, true, prefixEnd, false);
        TreeMap<Bytes, byte[]> subMapExpected = new TreeMap<Bytes, byte[]>();
        subMapExpected.put(key1, val);
        subMapExpected.put(key2, val);
        subMapExpected.put(key3, val);
        Assertions.assertEquals(subMapExpected.keySet(), subMapResults.keySet());
    }
}

