/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.pac4j.core.authorization.generator.AuthorizationGenerator;
import org.pac4j.core.client.Client;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.logout.handler.SessionLogoutHandler;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.creator.AuthenticatorProfileCreator;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.profile.factory.ProfileFactory;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseClient
extends InitializableObject
implements Client {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String name;
    private List<AuthorizationGenerator> authorizationGenerators = new ArrayList<AuthorizationGenerator>();
    private CredentialsExtractor credentialsExtractor;
    private Authenticator authenticator;
    private ProfileCreator profileCreator = AuthenticatorProfileCreator.INSTANCE;
    private Map<String, Object> customProperties = new LinkedHashMap<String, Object>();
    private ProfileFactory profileFactoryWhenNotAuthenticated;
    private boolean multiProfile = false;
    protected Boolean saveProfileInSession;
    private static boolean warned;
    private Config config;

    @Override
    public String getName() {
        if (StringUtils.isBlank((CharSequence)this.name)) {
            return this.getClass().getSimpleName();
        }
        return this.name;
    }

    @Override
    public Optional<Credentials> getCredentials(CallContext ctx) {
        this.init();
        try {
            Credentials credentials = this.credentialsExtractor.extract(ctx).orElse(null);
            this.checkCredentials(ctx, credentials);
            return Optional.ofNullable(credentials);
        }
        catch (CredentialsException e) {
            this.logger.info("Failed to retrieve credentials: {}", (Object)e.getMessage());
            this.logger.debug("Failed to retrieve redentials", (Throwable)e);
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Optional<Credentials> validateCredentials(CallContext ctx, Credentials credentials) {
        if (credentials != null) {
            this.init();
            long t0 = System.currentTimeMillis();
            try {
                Optional<Credentials> optional = this.internalValidateCredentials(ctx, credentials);
                return optional;
            }
            finally {
                long t1 = System.currentTimeMillis();
                this.logger.debug("Credentials validation took: {} ms", (Object)(t1 - t0));
            }
        }
        return Optional.empty();
    }

    protected Optional<Credentials> internalValidateCredentials(CallContext ctx, Credentials credentials) {
        try {
            Credentials newCredentials = this.authenticator.validate(ctx, credentials).orElse(null);
            this.checkCredentials(ctx, credentials);
            return Optional.ofNullable(newCredentials);
        }
        catch (CredentialsException e) {
            this.logger.info("Failed to validate credentials: {}", (Object)e.getMessage());
            this.logger.debug("Failed to validate credentials", (Throwable)e);
            return Optional.empty();
        }
    }

    protected void checkCredentials(CallContext ctx, Credentials credentials) {
    }

    @Override
    public final Optional<UserProfile> getUserProfile(CallContext ctx, Credentials credentials) {
        this.init();
        this.logger.debug("credentials : {}", (Object)credentials);
        if (credentials == null) {
            if (this.profileFactoryWhenNotAuthenticated != null) {
                UserProfile customProfile = (UserProfile)this.profileFactoryWhenNotAuthenticated.apply(new Object[]{ctx.webContext()});
                this.logger.debug("force custom profile when not authenticated: {}", (Object)customProfile);
                return Optional.ofNullable(customProfile);
            }
            return Optional.empty();
        }
        Optional<UserProfile> profile = this.profileCreator.create(ctx, credentials);
        this.logger.debug("profile: {}", profile);
        if (profile.isPresent()) {
            profile.get().setClientName(this.getName());
            if (this.authorizationGenerators != null) {
                for (AuthorizationGenerator authorizationGenerator : this.authorizationGenerators) {
                    profile = authorizationGenerator.generate(ctx, profile.get());
                }
            }
        }
        return profile;
    }

    @Override
    public Optional<UserProfile> renewUserProfile(CallContext ctx, UserProfile profile) {
        return Optional.empty();
    }

    public void notifySessionRenewal(CallContext ctx, String oldSessionId) {
    }

    public void setAuthorizationGenerators(List<AuthorizationGenerator> authorizationGenerators) {
        CommonHelper.assertNotNull("authorizationGenerators", authorizationGenerators);
        this.authorizationGenerators = authorizationGenerators;
    }

    public void setAuthorizationGenerators(AuthorizationGenerator ... authorizationGenerators) {
        CommonHelper.assertNotNull("authorizationGenerators", authorizationGenerators);
        this.authorizationGenerators = Arrays.asList(authorizationGenerators);
    }

    public void setAuthorizationGenerator(AuthorizationGenerator authorizationGenerator) {
        this.addAuthorizationGenerator(authorizationGenerator);
    }

    public void addAuthorizationGenerator(AuthorizationGenerator authorizationGenerator) {
        CommonHelper.assertNotNull("authorizationGenerator", authorizationGenerator);
        this.authorizationGenerators.add(authorizationGenerator);
    }

    public void addAuthorizationGenerators(Collection<AuthorizationGenerator> authorizationGenerators) {
        CommonHelper.assertNotNull("authorizationGenerators", authorizationGenerators);
        this.authorizationGenerators.addAll(authorizationGenerators);
    }

    protected void setCredentialsExtractorIfUndefined(CredentialsExtractor credentialsExtractor) {
        if (this.credentialsExtractor == null) {
            this.credentialsExtractor = credentialsExtractor;
        }
    }

    protected void setAuthenticatorIfUndefined(Authenticator authenticator) {
        if (this.authenticator == null) {
            this.authenticator = authenticator;
        }
    }

    protected void setProfileCreatorIfUndefined(ProfileCreator profileCreator) {
        if (this.profileCreator == null || this.profileCreator == AuthenticatorProfileCreator.INSTANCE) {
            this.profileCreator = profileCreator;
        }
    }

    public void setCustomProperties(Map<String, Object> customProperties) {
        CommonHelper.assertNotNull("customProperties", customProperties);
        this.customProperties = customProperties;
    }

    public void setProfileFactoryWhenNotAuthenticated(ProfileFactory profileFactoryWhenNotAuthenticated) {
        if (!warned) {
            this.logger.warn("Be careful when using the 'setProfileFactoryWhenNotAuthenticated' method: a custom profile is returned when the authentication fails or is cancelled and it is stored for the whole session. You may need to define additional 'Authorizer's to secure your web resources.");
            warned = true;
        }
        this.profileFactoryWhenNotAuthenticated = profileFactoryWhenNotAuthenticated;
    }

    public boolean isMultiProfile(WebContext context, UserProfile profile) {
        return this.multiProfile;
    }

    public Boolean getSaveProfileInSession(WebContext context, UserProfile profile) {
        return this.saveProfileInSession;
    }

    public SessionLogoutHandler findSessionLogoutHandler() {
        if (this.getConfig() != null) {
            return this.getConfig().getSessionLogoutHandler();
        }
        return null;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<AuthorizationGenerator> getAuthorizationGenerators() {
        return this.authorizationGenerators;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CredentialsExtractor getCredentialsExtractor() {
        return this.credentialsExtractor;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ProfileCreator getProfileCreator() {
        return this.profileCreator;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ProfileFactory getProfileFactoryWhenNotAuthenticated() {
        return this.profileFactoryWhenNotAuthenticated;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isMultiProfile() {
        return this.multiProfile;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Boolean getSaveProfileInSession() {
        return this.saveProfileInSession;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Config getConfig() {
        return this.config;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BaseClient setName(String name) {
        this.name = name;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BaseClient setCredentialsExtractor(CredentialsExtractor credentialsExtractor) {
        this.credentialsExtractor = credentialsExtractor;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BaseClient setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BaseClient setProfileCreator(ProfileCreator profileCreator) {
        this.profileCreator = profileCreator;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BaseClient setMultiProfile(boolean multiProfile) {
        this.multiProfile = multiProfile;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BaseClient setSaveProfileInSession(Boolean saveProfileInSession) {
        this.saveProfileInSession = saveProfileInSession;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BaseClient setConfig(Config config) {
        this.config = config;
        return this;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "BaseClient(name=" + this.name + ", authorizationGenerators=" + this.authorizationGenerators + ", credentialsExtractor=" + this.credentialsExtractor + ", authenticator=" + this.authenticator + ", profileCreator=" + this.profileCreator + ", customProperties=" + this.customProperties + ", profileFactoryWhenNotAuthenticated=" + this.profileFactoryWhenNotAuthenticated + ", multiProfile=" + this.multiProfile + ", saveProfileInSession=" + this.saveProfileInSession + ", config=" + this.config + ")";
    }
}

