/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.resources;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.rest.ConnectorRestClient;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.topology.TopologyNode;
import org.apache.syncope.client.console.wizards.resources.AbstractResourceWizardBuilder;
import org.apache.syncope.client.console.wizards.resources.ResourceConnCapabilitiesPanel;
import org.apache.syncope.client.console.wizards.resources.ResourceConnConfPanel;
import org.apache.syncope.client.console.wizards.resources.ResourceDetailsPanel;
import org.apache.syncope.client.console.wizards.resources.ResourceSecurityPanel;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class ResourceWizardBuilder
extends AbstractResourceWizardBuilder<ResourceTO> {
    private static final long serialVersionUID = 1734415311027284221L;
    protected final ResourceRestClient resourceRestClient;
    protected final ConnectorRestClient connectorRestClient;
    protected boolean createFlag;

    public ResourceWizardBuilder(ResourceTO resourceTO, ResourceRestClient resourceRestClient, ConnectorRestClient connectorRestClient, PageReference pageRef) {
        super(resourceTO, pageRef);
        this.resourceRestClient = resourceRestClient;
        this.connectorRestClient = connectorRestClient;
    }

    public AjaxWizard<Serializable> build(String id, AjaxWizard.Mode mode) {
        this.createFlag = mode == AjaxWizard.Mode.CREATE;
        return super.build(id, mode);
    }

    protected WizardModel buildModelSteps(Serializable modelObject, WizardModel wizardModel) {
        final ResourceTO resourceTO = (ResourceTO)ResourceTO.class.cast(modelObject);
        final ResourceDetailsPanel resourceDetailsPanel = new ResourceDetailsPanel(resourceTO, this.createFlag);
        final ResourceConnConfPanel resourceConnConfPanel = new ResourceConnConfPanel(resourceTO){
            private static final long serialVersionUID = -1128269449868933504L;

            @Override
            protected Pair<Boolean, String> check(AjaxRequestTarget target) {
                return ResourceWizardBuilder.this.resourceRestClient.check((ResourceTO)this.modelObject);
            }

            protected void onComponentTag(ComponentTag tag) {
                tag.append("class", (CharSequence)"scrollable-tab-content", " ");
            }
        };
        if (this.createFlag && resourceDetailsPanel.getConnector() != null) {
            resourceDetailsPanel.getConnector().getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = 4600298808455564695L;

                protected void onUpdate(AjaxRequestTarget target) {
                    resourceTO.setConnector((String)((Object)resourceDetailsPanel.getConnector().getModelObject()));
                    LoadableDetachableModel<List<ConnConfProperty>> model = new LoadableDetachableModel<List<ConnConfProperty>>(){
                        private static final long serialVersionUID = -2965284931860212687L;

                        protected List<ConnConfProperty> load() {
                            List<ConnConfProperty> confOverride = resourceConnConfPanel.getConnProperties(resourceTO);
                            resourceTO.setConfOverride(Optional.of(confOverride));
                            return confOverride;
                        }
                    };
                    resourceConnConfPanel.setConfPropertyListView((IModel<List<ConnConfProperty>>)model, true);
                    target.add(new Component[]{resourceConnConfPanel.getCheck().setVisible(true).setEnabled(true)});
                }
            }});
        }
        wizardModel.add((IWizardStep)resourceDetailsPanel);
        wizardModel.add((IWizardStep)resourceConnConfPanel);
        Optional.ofNullable(resourceTO.getConnector()).ifPresentOrElse(conn -> wizardModel.add((IWizardStep)new ResourceConnCapabilitiesPanel(resourceTO, this.connectorRestClient.read((String)conn).getCapabilities())), () -> wizardModel.add((IWizardStep)new ResourceConnCapabilitiesPanel(resourceTO, Set.of())));
        wizardModel.add((IWizardStep)new ResourceSecurityPanel(resourceTO));
        return wizardModel;
    }

    protected ResourceTO onApplyInternal(Serializable modelObject) {
        ResourceTO resourceTO = (ResourceTO)modelObject;
        if (this.createFlag) {
            resourceTO = this.resourceRestClient.create(resourceTO);
        } else {
            this.resourceRestClient.update(resourceTO);
        }
        return resourceTO;
    }

    protected Serializable getCreateCustomPayloadEvent(Serializable afterObject, AjaxRequestTarget target) {
        ResourceTO actual = (ResourceTO)ResourceTO.class.cast(afterObject);
        return new AbstractResourceWizardBuilder.CreateEvent(actual.getKey(), actual.getKey(), TopologyNode.Kind.RESOURCE, (Serializable)((Object)actual.getConnector()), target);
    }
}

