/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.query.simple;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.query.simple.SimpleQuery;
import com.googlecode.cqengine.query.support.QueryValidation;

public class StringEndsWith<O, A extends CharSequence>
extends SimpleQuery<O, A> {
    private final A value;

    public StringEndsWith(Attribute<O, A> attribute, A value) {
        super(attribute);
        this.value = (CharSequence)QueryValidation.checkQueryValueNotNull(value);
    }

    public A getValue() {
        return this.value;
    }

    @Override
    protected boolean matchesSimpleAttribute(SimpleAttribute<O, A> attribute, O object, QueryOptions queryOptions) {
        CharSequence attributeValue = (CharSequence)attribute.getValue(object, queryOptions);
        return this.matchesValue(attributeValue, queryOptions);
    }

    @Override
    protected boolean matchesNonSimpleAttribute(Attribute<O, A> attribute, O object, QueryOptions queryOptions) {
        for (CharSequence attributeValue : attribute.getValues(object, queryOptions)) {
            if (!this.matchesValue(attributeValue, queryOptions)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesValue(A aValue, QueryOptions queryOptions) {
        char suffixChar;
        char documentChar;
        int charsMatched = 0;
        int i = aValue.length() - 1;
        for (int j = this.value.length() - 1; i >= 0 && j >= 0 && (documentChar = aValue.charAt(i)) == (suffixChar = this.value.charAt(j)); --i, --j) {
            ++charsMatched;
        }
        return charsMatched == this.value.length();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringEndsWith)) {
            return false;
        }
        StringEndsWith that = (StringEndsWith)o;
        if (!this.attribute.equals(that.attribute)) {
            return false;
        }
        return this.value.equals(that.value);
    }

    @Override
    protected int calcHashCode() {
        int result = this.attribute.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public String toString() {
        return "endsWith(" + StringEndsWith.asLiteral(super.getAttributeName()) + ", " + StringEndsWith.asLiteral(this.value) + ")";
    }
}

