/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator.token;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.token.BaseOAuth20TokenRequestValidator;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20PasswordGrantTypeTokenRequestValidator
extends BaseOAuth20TokenRequestValidator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20PasswordGrantTypeTokenRequestValidator.class);

    public OAuth20PasswordGrantTypeTokenRequestValidator(OAuth20ConfigurationContext configurationContext) {
        super(configurationContext);
    }

    @Override
    protected OAuth20GrantTypes getGrantType() {
        return OAuth20GrantTypes.PASSWORD;
    }

    @Override
    protected boolean validateInternal(WebContext context, String grantType, ProfileManager manager, UserProfile uProfile) throws Throwable {
        CallContext callContext = new CallContext(context, this.getConfigurationContext().getSessionStore());
        Pair clientIdAndSecret = this.getConfigurationContext().getRequestParameterResolver().resolveClientIdAndClientSecret(callContext);
        if (StringUtils.isBlank((CharSequence)((CharSequence)clientIdAndSecret.getKey()))) {
            return false;
        }
        String clientId = (String)clientIdAndSecret.getKey();
        LOGGER.debug("Received grant type [{}] with client id [{}]", (Object)grantType, (Object)clientId);
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.getConfigurationContext().getServicesManager(), clientId);
        RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((RegisteredService)registeredService);
        WebApplicationService service = (WebApplicationService)this.getConfigurationContext().getWebApplicationServiceServiceFactory().createService(registeredService.getServiceId());
        AuditableContext audit = AuditableContext.builder().service((Service)service).registeredService((RegisteredService)registeredService).build();
        AuditableExecutionResult accessResult = this.getConfigurationContext().getRegisteredServiceAccessStrategyEnforcer().execute(audit);
        accessResult.throwExceptionIfNeeded();
        if (!this.isGrantTypeSupportedBy(registeredService, grantType)) {
            LOGGER.warn("Requested grant type [{}] is not authorized by service definition [{}]", (Object)grantType, (Object)registeredService.getServiceId());
            return false;
        }
        return true;
    }
}

