/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta.strats;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.ReflectingPersistenceCapable;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.Embeddable;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.FieldStrategy;
import org.apache.openjpa.jdbc.meta.Joinable;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.ValueMappingImpl;
import org.apache.openjpa.jdbc.meta.ValueMappingInfo;
import org.apache.openjpa.jdbc.meta.strats.AbstractFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.ContainerFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.EmbedValueHandler;
import org.apache.openjpa.jdbc.meta.strats.HandlerRelationMapTableFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.HandlerStrategies;
import org.apache.openjpa.jdbc.meta.strats.RelationStrategies;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ColumnIO;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.Row;
import org.apache.openjpa.jdbc.sql.RowManager;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.jdbc.sql.SelectExecutor;
import org.apache.openjpa.jdbc.sql.Union;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.JavaTypes;
import org.apache.openjpa.meta.MetaDataContext;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.util.ApplicationIds;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.MetaDataException;
import org.apache.openjpa.util.ObjectId;
import org.apache.openjpa.util.OpenJPAId;
import org.apache.openjpa.util.UnsupportedException;

public class RelationFieldStrategy
extends AbstractFieldStrategy
implements Joinable,
Embeddable {
    private static final long serialVersionUID = 1L;
    private static final Localizer _loc = Localizer.forPackage(RelationFieldStrategy.class);
    private Boolean _fkOid = null;

    @Override
    public void map(boolean adapt) {
        if (this.field.getTypeCode() != 15 || this.field.isEmbeddedPC()) {
            throw new MetaDataException(_loc.get("not-relation", (Object)this.field));
        }
        this.field.getKeyMapping().getValueInfo().assertNoSchemaComponents((MetaDataContext)this.field.getKey(), !adapt);
        if (!this.field.isNonDefaultMappingUsingJoinTableStrategy()) {
            this.field.getElementMapping().getValueInfo().assertNoSchemaComponents((MetaDataContext)this.field.getElement(), !adapt);
        }
        boolean criteria = this.field.getValueInfo().getUseClassCriteria();
        FieldMapping mapped = this.field.getMappedByMapping();
        if (mapped != null) {
            this.field.getMappingInfo().assertNoSchemaComponents(this.field, !adapt);
            this.field.getValueInfo().assertNoSchemaComponents(this.field, !adapt);
            mapped.resolve(3);
            if (!mapped.isMapped() || mapped.isSerialized()) {
                throw new MetaDataException(_loc.get("mapped-by-unmapped", (Object)this.field, (Object)mapped));
            }
            if (mapped.getTypeCode() == 15) {
                if (mapped.getJoinDirection() == 0) {
                    this.field.setJoinDirection(1);
                    this.field.setColumns(mapped.getDefiningMapping().getPrimaryKeyColumns());
                } else if (this.isTypeUnjoinedSubclass(mapped)) {
                    throw new MetaDataException(_loc.get("mapped-inverse-unjoined", (Object)this.field.getName(), (Object)this.field.getDefiningMapping(), (Object)mapped));
                }
                this.field.setForeignKey(mapped.getForeignKey(this.field.getDefiningMapping()));
            } else if (mapped.getElement().getTypeCode() == 15) {
                if (this.isTypeUnjoinedSubclass(mapped.getElementMapping())) {
                    throw new MetaDataException(_loc.get("mapped-inverse-unjoined", (Object)this.field.getName(), (Object)this.field.getDefiningMapping(), (Object)mapped));
                }
                Log log = this.field.getRepository().getLog();
                if (log.isInfoEnabled()) {
                    log.info((Object)_loc.get("coll-owner", (Object)this.field, (Object)mapped));
                }
                this.field.setForeignKey(mapped.getElementMapping().getForeignKey());
            } else {
                throw new MetaDataException(_loc.get("not-inv-relation", (Object)this.field, (Object)mapped));
            }
            this.field.setUseClassCriteria(criteria);
            return;
        }
        DBIdentifier tableName = this.field.getMappingInfo().getTableIdentifier();
        Table table = this.field.getTypeMapping().getTable();
        ValueMappingInfo vinfo = this.field.getValueInfo();
        if (!DBIdentifier.isNull(tableName) && table != null && (tableName.equals(table.getIdentifier()) || tableName.equals(table.getFullIdentifier()))) {
            vinfo.setJoinDirection(2);
            vinfo.setColumns(this.field.getMappingInfo().getColumns());
            this.field.getMappingInfo().setTableIdentifier(DBIdentifier.NULL);
            this.field.getMappingInfo().setColumns(null);
        }
        if (!this.field.isBiMTo1JT()) {
            this.field.mapJoin(adapt, false);
        }
        if (this.field.getTypeMapping().isMapped()) {
            if (this.field.getMappedByIdValue() != null) {
                this.setMappedByIdColumns();
            }
            if (!this.field.isBiMTo1JT()) {
                ForeignKey fk = vinfo.getTypeJoin((ValueMapping)this.field, this.field.getName(), true, adapt);
                this.field.setForeignKey(fk);
            }
            this.field.setColumnIO(vinfo.getColumnIO());
            if (vinfo.getJoinDirection() == 2) {
                this.field.setJoinDirection(1);
            }
        } else {
            RelationStrategies.mapRelationToUnmappedPC((ValueMapping)this.field, this.field.getName(), adapt);
        }
        this.field.setUseClassCriteria(criteria);
        this.field.mapPrimaryKey(adapt);
        PrimaryKey pk = this.field.getTable().getPrimaryKey();
        if (this.field.isPrimaryKey()) {
            Column[] cols = this.field.getColumns();
            if (pk != null && (adapt || pk.isLogical())) {
                for (Column col : cols) {
                    pk.addColumn(col);
                }
            }
            for (Column col : cols) {
                this.field.getDefiningMapping().setJoinable(col, this);
            }
        }
        this.field.mapConstraints(this.field.getName(), adapt);
    }

    private void setMappedByIdColumns() {
        FieldMetaData[] pks;
        ClassMetaData owner = this.field.getDefiningMetaData();
        for (FieldMetaData pk : pks = owner.getPrimaryKeyFields()) {
            FieldMapping fm = (FieldMapping)pk;
            ValueMappingImpl val = (ValueMappingImpl)this.field.getValue();
            ValueMappingInfo info = val.getValueInfo();
            if (info.getColumns().size() != 0) continue;
            info.setColumns(this.getMappedByIdColumns(fm));
        }
    }

    private List getMappedByIdColumns(FieldMapping pk) {
        ClassMetaData embeddedId = ((ValueMappingImpl)pk.getValue()).getEmbeddedMetaData();
        Column[] pkCols = null;
        ArrayList<Column> cols = new ArrayList<Column>();
        String mappedByIdValue = this.field.getMappedByIdValue();
        if (embeddedId != null) {
            FieldMetaData[] fmds;
            for (FieldMetaData fmd : fmds = embeddedId.getFields()) {
                if (!fmd.getName().equals(mappedByIdValue) && mappedByIdValue.length() != 0) continue;
                if (fmd.getValue().getEmbeddedMetaData() != null) {
                    EmbedValueHandler.getEmbeddedIdCols((FieldMapping)fmd, cols);
                    continue;
                }
                EmbedValueHandler.getIdColumns((FieldMapping)fmd, cols);
            }
            return cols;
        }
        Class pkType = pk.getDeclaredType();
        FieldMetaData[] pks = this.field.getValue().getDeclaredTypeMetaData().getPrimaryKeyFields();
        if (pks.length != 1 || pks[0].getDeclaredType() != pkType) {
            return Collections.EMPTY_LIST;
        }
        for (Column pkCol : pkCols = pk.getColumns()) {
            cols.add(pkCol);
        }
        return cols;
    }

    private boolean isTypeUnjoinedSubclass(ValueMapping mapped) {
        for (ClassMapping def = this.field.getDefiningMapping(); def != null; def = def.getJoinablePCSuperclassMapping()) {
            if (def != mapped.getTypeMapping()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void initialize() {
        this.field.setUsesIntermediate(true);
        ForeignKey fk = this.field.getForeignKey();
        if (fk == null) {
            this._fkOid = Boolean.TRUE;
        } else if (this.field.getJoinDirection() != 1) {
            this._fkOid = this.field.getTypeMapping().isForeignKeyObjectId(fk);
        }
    }

    @Override
    public void insert(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        if (this.field.getMappedBy() != null) {
            return;
        }
        Row row = null;
        OpenJPAStateManager rel = RelationStrategies.getStateManager(sm.fetchObjectField(this.field.getIndex()), store.getContext());
        if (sm instanceof StateManagerImpl) {
            List mappedByIdFields = ((StateManagerImpl)sm).getMappedByIdFields();
            if (rel != null && ((ClassMapping)rel.getMetaData()).getTable().getAutoAssignedColumns().length > 0 && mappedByIdFields != null && mappedByIdFields.contains(this.field) && (row = rm.getRow(((ClassMapping)rel.getMetaData()).getTable(), 1, rel, false)) != null) {
                return;
            }
        }
        if (this.field.getJoinDirection() == 1) {
            this.updateInverse(sm, rel, store, rm);
        } else {
            if (row == null) {
                row = this.field.getRow(sm, store, rm, 1);
            }
            if (row != null && !this.field.isBiMTo1JT()) {
                this.field.setForeignKey(row, rel);
                this.setMapKey(sm, rel, store, row);
            }
        }
    }

    private void setMapKey(OpenJPAStateManager sm, OpenJPAStateManager rel, JDBCStore store, Row row) throws SQLException {
        if (rel == null) {
            return;
        }
        ClassMetaData meta = rel.getMetaData();
        FieldMapping mapField = this.getMapField(meta);
        if (mapField == null) {
            return;
        }
        Map mapObj = (Map)rel.fetchObjectField(mapField.getIndex());
        Object keyObj = this.getMapKeyObj(mapObj, sm.getPersistenceCapable());
        ValueMapping key = mapField.getKeyMapping();
        if (!key.isEmbedded()) {
            if (keyObj instanceof PersistenceCapable) {
                OpenJPAStateManager keySm = RelationStrategies.getStateManager(keyObj, store.getContext());
                ForeignKey fk = mapField.getKeyMapping().getForeignKey();
                ColumnIO io = new ColumnIO();
                row.setForeignKey(fk, io, keySm);
            }
        } else {
            FieldStrategy strategy = mapField.getStrategy();
            if (strategy instanceof HandlerRelationMapTableFieldStrategy) {
                HandlerRelationMapTableFieldStrategy strat = (HandlerRelationMapTableFieldStrategy)strategy;
                Column[] kcols = strat.getKeyColumns((ClassMapping)meta);
                ColumnIO kio = strat.getKeyColumnIO();
                HandlerStrategies.set(key, keyObj, store, row, kcols, kio, true);
            }
        }
    }

    private FieldMapping getMapField(ClassMetaData meta) {
        FieldMapping[] fields;
        for (FieldMapping fieldMapping : fields = ((ClassMapping)meta).getFieldMappings()) {
            FieldMetaData mappedBy = fieldMapping.getMappedByMetaData();
            if (fieldMapping.getDeclaredTypeCode() != 13 || mappedBy != this.field) continue;
            return fieldMapping;
        }
        return null;
    }

    private Object getMapKeyObj(Map mapObj, Object value) {
        if (value instanceof ReflectingPersistenceCapable) {
            value = ((ReflectingPersistenceCapable)value).getManagedInstance();
        }
        Set entries = mapObj.entrySet();
        for (Map.Entry entry : entries) {
            if (entry.getValue() != value) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public void update(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        if (this.field.getMappedBy() != null) {
            return;
        }
        OpenJPAStateManager rel = RelationStrategies.getStateManager(sm.fetchObjectField(this.field.getIndex()), store.getContext());
        if (this.field.getJoinDirection() == 1) {
            this.nullInverse(sm, rm);
            this.updateInverse(sm, rel, store, rm);
        } else {
            int action = rel == null && this.field.isBidirectionalJoinTableMappingNonOwner() ? 2 : 0;
            Row row = this.field.getRow(sm, store, rm, action);
            if (row != null && !this.field.isBiMTo1JT()) {
                this.field.setForeignKey(row, rel);
                this.setMapKey(sm, rel, store, row);
            }
            if (this.field.isBiMTo1JT()) {
                PersistenceCapable invPC = (PersistenceCapable)sm.fetchObject(this.field.getBi_1ToM_JTField().getIndex());
                Row secondaryRow = null;
                if (invPC != null) {
                    secondaryRow = rm.getSecondaryRow(this.field.getBi1ToMJoinFK().getTable(), 1);
                    secondaryRow.setForeignKey(this.field.getBi1ToMElemFK(), null, sm);
                    secondaryRow.setForeignKey(this.field.getBi1ToMJoinFK(), null, RelationStrategies.getStateManager(invPC, store.getContext()));
                    rm.flushSecondaryRow(secondaryRow);
                }
            }
        }
    }

    @Override
    public void delete(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        if (this.field.getMappedBy() != null) {
            return;
        }
        if (this.field.getJoinDirection() == 1) {
            if (sm.getLoaded().get(this.field.getIndex())) {
                OpenJPAStateManager rel = RelationStrategies.getStateManager(sm.fetchObjectField(this.field.getIndex()), store.getContext());
                this.updateInverse(sm, rel, store, rm);
            } else {
                this.nullInverse(sm, rm);
            }
        } else {
            ForeignKey fk;
            OpenJPAStateManager rel;
            this.field.deleteRow(sm, store, rm);
            Object lastRelPc = sm.fetchObjectField(this.field.getIndex());
            if (lastRelPc == null) {
                lastRelPc = sm.fetchInitialField(this.field.getIndex());
            }
            if ((rel = RelationStrategies.getStateManager(lastRelPc, store.getContext())) != null && ((fk = this.field.getForeignKey((ClassMapping)rel.getMetaData())).getDeleteAction() == 2 || fk.getDeleteAction() == 3)) {
                Row row = this.field.getRow(sm, store, rm, 2);
                row.setForeignKey(fk, null, rel);
                this.setMapKey(sm, rel, store, row);
            }
        }
    }

    private void nullInverse(OpenJPAStateManager sm, RowManager rm) throws SQLException {
        if (this.field.getUseClassCriteria()) {
            return;
        }
        ForeignKey fk = this.field.getForeignKey();
        ColumnIO io = this.field.getColumnIO();
        if (!io.isAnyUpdatable(fk, true)) {
            return;
        }
        if (this.field.getIndependentTypeMappings().length != 1) {
            throw RelationStrategies.uninversable(this.field);
        }
        Row row = rm.getAllRows(fk.getTable(), 0);
        row.setForeignKey(fk, io, null);
        row.whereForeignKey(fk, sm);
        rm.flushAllRows(row);
    }

    private void updateInverse(OpenJPAStateManager sm, OpenJPAStateManager rel, JDBCStore store, RowManager rm) throws SQLException {
        FieldMapping[] invs;
        int action;
        if (rel == null) {
            return;
        }
        ForeignKey fk = this.field.getForeignKey();
        ColumnIO io = this.field.getColumnIO();
        if (rel.isNew() && !rel.isFlushed()) {
            if (sm.isDeleted() || !io.isAnyInsertable(fk, false)) {
                return;
            }
            action = 1;
        } else if (rel.isDeleted()) {
            if (rel.isFlushed() || !sm.isDeleted()) {
                return;
            }
            action = 2;
        } else {
            if (sm.isDeleted()) {
                sm = null;
            }
            if (!io.isAnyUpdatable(fk, sm == null)) {
                return;
            }
            action = 0;
        }
        if (this.field.getIndependentTypeMappings().length != 1) {
            throw RelationStrategies.uninversable(this.field);
        }
        Row row = null;
        for (FieldMapping inv : invs = this.field.getInverseMappings()) {
            if (inv.getMappedByMetaData() != this.field || inv.getTypeCode() != 15) continue;
            row = inv.getRow(rel, store, rm, action);
            break;
        }
        ClassMapping relMapping = this.field.getTypeMapping();
        if (row == null) {
            row = rm.getRow(relMapping.getTable(), action, rel, true);
        }
        if (action == 0 && row.getTable() == relMapping.getTable()) {
            row.wherePrimaryKey(rel);
        }
        row.setForeignKey(fk, io, sm);
    }

    @Override
    public int supportsSelect(Select sel, int type, OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch) {
        if (type == 3) {
            return this.field.getJoinDirection() != 1 && sel.isSelected(this.field.getTable()) ? 1 : 0;
        }
        if (type == 4) {
            return 1;
        }
        if (sm != null) {
            Object oid = sm.getIntermediate(this.field.getIndex());
            if (store.getContext().findCached(oid, null) != null) {
                return 0;
            }
        }
        ClassMapping[] clss = this.field.getIndependentTypeMappings();
        switch (type) {
            case 2: {
                return clss.length;
            }
            case 1: {
                return clss.length == 1 && store.getDBDictionary().canOuterJoin(sel.getJoinSyntax(), this.field.getForeignKey(clss[0])) ? 1 : 0;
            }
            case 0: {
                return clss.length == 1 ? 1 : 0;
            }
        }
        return 0;
    }

    @Override
    public void selectEagerParallel(SelectExecutor sel, OpenJPAStateManager sm, final JDBCStore store, final JDBCFetchConfiguration fetch, final int eagerMode) {
        final ClassMapping[] clss = this.field.getIndependentTypeMappings();
        if (!(sel instanceof Union)) {
            this.selectEagerParallel((Select)sel, clss[0], store, fetch, eagerMode);
        } else {
            Union union = (Union)sel;
            if (fetch.getSubclassFetchMode(this.field.getTypeMapping()) != 1) {
                union.abortUnion();
            }
            union.select(new Union.Selector(){

                @Override
                public void select(Select sel, int idx) {
                    RelationFieldStrategy.this.selectEagerParallel(sel, clss[idx], store, fetch, eagerMode);
                }
            });
        }
    }

    private void selectEagerParallel(Select sel, ClassMapping cls, JDBCStore store, JDBCFetchConfiguration fetch, int eagerMode) {
        if (this.field.isBiMTo1JT()) {
            return;
        }
        sel.selectPrimaryKey(this.field.getDefiningMapping());
        Joins joins = sel.newJoins().setVariable("*");
        this.eagerJoin(joins, cls, true);
        sel.select(cls, this.field.getSelectSubclasses(), store, fetch, eagerMode, joins);
    }

    @Override
    public void selectEagerJoin(Select sel, OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch, int eagerMode) {
        if (this.field.isBiMTo1JT()) {
            return;
        }
        ClassMapping cls = this.field.getIndependentTypeMappings()[0];
        boolean forceInner = fetch.hasFetchInnerJoin(this.field.getFullName(false));
        sel.select(cls, this.field.getSelectSubclasses(), store, fetch, 1, this.eagerJoin(sel.newJoins(), cls, forceInner));
    }

    private Joins eagerJoin(Joins joins, ClassMapping cls, boolean forceInner) {
        boolean inverse;
        boolean bl = inverse = this.field.getJoinDirection() == 1;
        if (!inverse) {
            joins = this.join(joins, false);
            joins = this.setEmbeddedVariable(joins);
        }
        ForeignKey fk = this.field.getForeignKey(cls);
        if (!forceInner && this.field.getNullValue() != 2) {
            return joins.outerJoinRelation(this.field.getName(), fk, this.field.getTypeMapping(), this.field.getSelectSubclasses(), inverse, false);
        }
        return joins.joinRelation(this.field.getName(), fk, this.field.getTypeMapping(), this.field.getSelectSubclasses(), inverse, false);
    }

    private Joins setEmbeddedVariable(Joins joins) {
        if (this.field.getDefiningMetaData().getEmbeddingMetaData() == null) {
            return joins;
        }
        return joins.setVariable(this.field.getDefiningMetaData().getEmbeddingMetaData().getFieldMetaData().getName());
    }

    @Override
    public int select(Select sel, OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch, int eagerMode) {
        if (this.field.getJoinDirection() == 1) {
            return -1;
        }
        if (sm != null && sm.getIntermediate(this.field.getIndex()) != null) {
            return -1;
        }
        if (!Boolean.TRUE.equals(this._fkOid)) {
            return -1;
        }
        sel.select(this.field.getColumns(), this.field.join(sel));
        return 0;
    }

    @Override
    public Object loadEagerParallel(OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch, Object res) throws SQLException {
        Map rels = res instanceof Result ? this.processEagerParallelResult(sm, store, fetch, (Result)res) : (Map)res;
        sm.storeObject(this.field.getIndex(), rels.remove(sm.getObjectId()));
        return rels;
    }

    private Map processEagerParallelResult(OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch, Result res) throws SQLException {
        ClassMapping[] clss = this.field.getIndependentTypeMappings();
        Joins joins = res.newJoins().setVariable("*");
        this.eagerJoin(joins, clss[0], true);
        HashMap<Object, Object> rels = new HashMap<Object, Object>();
        ClassMapping owner = this.field.getDefiningMapping();
        while (res.next()) {
            ClassMapping cls = res.getBaseMapping();
            if (cls == null) {
                cls = clss[0];
            }
            Object oid = owner.getObjectId(store, res, null, true, null);
            rels.put(oid, res.load(cls, store, fetch, joins));
        }
        res.close();
        return rels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadEagerJoin(OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch, Result res) throws SQLException {
        ValueMapping val;
        ClassMetaData decMeta;
        if (this.field.isBiMTo1JT()) {
            return;
        }
        ClassMapping cls = this.field.getIndependentTypeMappings()[0];
        FieldMapping mappedByFieldMapping = this.field.getMappedByMapping();
        PersistenceCapable mappedByValue = null;
        if (mappedByFieldMapping != null && (decMeta = (val = mappedByFieldMapping.getValueMapping()).getTypeMetaData()) != null && !sm.isEmbedded()) {
            mappedByValue = sm.getPersistenceCapable();
            res.setMappedByFieldMapping(mappedByFieldMapping);
            res.setMappedByValue(mappedByValue);
        }
        boolean isLocked = res.isLocking();
        try {
            if (store.getLockManager() != null) {
                res.setLocking(store.getLockManager().skipRelationFieldLock());
            }
            sm.storeObject(this.field.getIndex(), res.load(cls, store, fetch, this.eagerJoin(res.newJoins(), cls, false)));
        }
        finally {
            res.setLocking(isLocked);
        }
        res.setMappedByFieldMapping(null);
        res.setMappedByValue(null);
    }

    @Override
    public void load(OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch, Result res) throws SQLException {
        if (this.field.getJoinDirection() == 1) {
            return;
        }
        if (sm != null && sm.getIntermediate(this.field.getIndex()) != null) {
            return;
        }
        if (!Boolean.TRUE.equals(this._fkOid)) {
            return;
        }
        if (!res.containsAll(this.field.getColumns())) {
            return;
        }
        ClassMapping relMapping = this.field.getTypeMapping();
        Object oid = null;
        if (relMapping.isMapped() && !this.field.isBiMTo1JT()) {
            oid = relMapping.getObjectId(store, res, this.field.getForeignKey(), this.field.getPolymorphic() != 1, null);
        } else {
            Column[] cols = this.field.getColumns();
            if (relMapping.getIdentityType() == 1) {
                long id = res.getLong(cols[0]);
                if (!res.wasNull()) {
                    oid = store.newDataStoreId(id, relMapping, true);
                }
            } else if (cols.length == 1) {
                Object val = res.getObject(cols[0], null, null);
                if (val != null) {
                    oid = ApplicationIds.fromPKValues((Object[])new Object[]{val}, (ClassMetaData)relMapping);
                }
            } else {
                Object[] vals = new Object[cols.length];
                for (int i = 0; i < cols.length; ++i) {
                    vals[i] = res.getObject(cols[i], null, null);
                    if (vals[i] == null) break;
                    if (i != cols.length - 1) continue;
                    oid = ApplicationIds.fromPKValues((Object[])vals, (ClassMetaData)relMapping);
                }
            }
        }
        if (oid == null) {
            sm.storeObject(this.field.getIndex(), null);
        } else {
            sm.setIntermediate(this.field.getIndex(), oid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(final OpenJPAStateManager sm, final JDBCStore store, final JDBCFetchConfiguration fetch) throws SQLException {
        Object oid;
        if (Boolean.TRUE.equals(this._fkOid) && (oid = sm.getIntermediate(this.field.getIndex())) != null) {
            Object val = store.find(oid, this.field, fetch);
            sm.storeObject(this.field.getIndex(), val);
            return;
        }
        final ClassMapping[] rels = this.field.getIndependentTypeMappings();
        final int subs = this.field.getSelectSubclasses();
        final Joins[] resJoins = new Joins[rels.length];
        Union union = store.getSQLFactory().newUnion(rels.length);
        union.setExpectedResultCount(1, false);
        if (fetch.getSubclassFetchMode(this.field.getTypeMapping()) != 1) {
            union.abortUnion();
        }
        union.select(new Union.Selector(){

            @Override
            public void select(Select sel, int idx) {
                if (RelationFieldStrategy.this.field.getJoinDirection() == 1) {
                    sel.whereForeignKey(RelationFieldStrategy.this.field.getForeignKey(rels[idx]), sm.getObjectId(), RelationFieldStrategy.this.field.getDefiningMapping(), store);
                } else if (!RelationFieldStrategy.this.field.isBiMTo1JT()) {
                    resJoins[idx] = sel.newJoins().joinRelation(RelationFieldStrategy.this.field.getName(), RelationFieldStrategy.this.field.getForeignKey(rels[idx]), rels[idx], RelationFieldStrategy.this.field.getSelectSubclasses(), false, false);
                    RelationFieldStrategy.this.field.wherePrimaryKey(sel, sm, store);
                } else {
                    resJoins[idx] = sel.newJoins().joinRelation(null, RelationFieldStrategy.this.field.getBi1ToMJoinFK(), rels[idx], RelationFieldStrategy.this.field.getSelectSubclasses(), false, false);
                    sel.whereForeignKey(RelationFieldStrategy.this.field.getBi1ToMElemFK(), sm.getObjectId(), RelationFieldStrategy.this.field.getDefiningMapping(), store);
                }
                sel.select(rels[idx], subs, store, fetch, 1, resJoins[idx]);
            }
        });
        try (Result res = union.execute(store, fetch);){
            Object val = null;
            if (res.next()) {
                val = res.load(rels[res.indexOf()], store, fetch, resJoins[res.indexOf()]);
            }
            sm.storeObject(this.field.getIndex(), val);
        }
    }

    @Override
    public Object toDataStoreValue(Object val, JDBCStore store) {
        return RelationStrategies.toDataStoreValue(this.field, val, store);
    }

    @Override
    public void appendIsNull(SQLBuffer sql, Select sel, Joins joins) {
        if (this.field.getJoinDirection() != 1) {
            joins = this.join(joins, false);
            Column[] cols = this.field.getColumns();
            if (cols.length == 0) {
                sql.append("1 <> 1");
            } else {
                sql.append(sel.getColumnAlias(cols[0], joins)).append(" IS ").appendValue(null, cols[0]);
            }
        } else {
            this.testInverseNull(sql, sel, joins, true);
        }
    }

    @Override
    public void appendIsNotNull(SQLBuffer sql, Select sel, Joins joins) {
        if (this.field.getJoinDirection() != 1) {
            joins = this.join(joins, false);
            Column[] cols = this.field.getColumns();
            if (cols.length == 0) {
                sql.append("1 = 1");
            } else {
                sql.append(sel.getColumnAlias(cols[0], joins)).append(" IS NOT ").appendValue(null, cols[0]);
            }
        } else {
            this.testInverseNull(sql, sel, joins, false);
        }
    }

    private void testInverseNull(SQLBuffer sql, Select sel, Joins joins, boolean empty) {
        DBDictionary dict = this.field.getMappingRepository().getDBDictionary();
        dict.assertSupport(dict.supportsSubselect, "SupportsSubselect");
        if (this.field.getIndependentTypeMappings().length != 1) {
            throw RelationStrategies.uninversable(this.field);
        }
        if (empty) {
            sql.append("0 = ");
        } else {
            sql.append("0 < ");
        }
        ForeignKey fk = this.field.getForeignKey();
        ContainerFieldStrategy.appendJoinCount(sql, sel, joins, dict, this.field, fk);
    }

    @Override
    public Joins join(Joins joins, boolean forceOuter) {
        if (this.field.getJoinDirection() != 1) {
            return this.field.join(joins, forceOuter, false);
        }
        ClassMapping[] clss = this.field.getIndependentTypeMappings();
        if (clss.length != 1) {
            throw RelationStrategies.uninversable(this.field);
        }
        if (forceOuter) {
            return joins.outerJoinRelation(this.field.getName(), this.field.getForeignKey(), clss[0], this.field.getSelectSubclasses(), true, false);
        }
        return joins.joinRelation(this.field.getName(), this.field.getForeignKey(), clss[0], this.field.getSelectSubclasses(), true, false);
    }

    @Override
    public Joins joinRelation(Joins joins, boolean forceOuter, boolean traverse) {
        if (this.field.getJoinDirection() == 1) {
            return joins;
        }
        ClassMapping[] clss = this.field.getIndependentTypeMappings();
        if (clss.length != 1) {
            if (traverse) {
                throw RelationStrategies.unjoinable(this.field);
            }
            return joins;
        }
        joins = this.setEmbeddedVariable(joins);
        if (forceOuter) {
            return joins.outerJoinRelation(this.field.getName(), this.field.getForeignKey(clss[0]), clss[0], this.field.getSelectSubclasses(), false, false);
        }
        return joins.joinRelation(this.field.getName(), this.field.getForeignKey(clss[0]), clss[0], this.field.getSelectSubclasses(), false, false);
    }

    @Override
    public int getFieldIndex() {
        return this.field.getIndex();
    }

    @Override
    public Object getPrimaryKeyValue(Result res, Column[] cols, ForeignKey fk, JDBCStore store, Joins joins) throws SQLException {
        ClassMapping relmapping = this.field.getTypeMapping();
        if (relmapping.getIdentityType() == 1) {
            Column col = cols[0];
            if (fk != null) {
                col = fk.getColumn(col);
            }
            long id = res.getLong(col, joins);
            if (this.field.getObjectIdFieldTypeCode() == 6) {
                return id;
            }
            return store.newDataStoreId(id, relmapping, this.field.getPolymorphic() != 1);
        }
        if (relmapping.isOpenJPAIdentity()) {
            return ((Joinable)((Object)relmapping.getPrimaryKeyFieldMappings()[0].getStrategy())).getPrimaryKeyValue(res, cols, fk, store, joins);
        }
        fk = cols == this.getColumns() && fk == null ? this.field.getForeignKey() : this.createTranslatingForeignKey(relmapping, cols, fk);
        return relmapping.getObjectId(store, res, fk, this.field.getPolymorphic() != 1, joins);
    }

    private ForeignKey createTranslatingForeignKey(ClassMapping relmapping, Column[] gcols, ForeignKey gfk) {
        ForeignKey fk = this.field.getForeignKey();
        Column[] cols = fk.getColumns();
        ForeignKey tfk = null;
        for (int i = 0; i < gcols.length; ++i) {
            Column tcol = gcols[i];
            if (gfk != null) {
                tcol = gfk.getColumn(tcol);
            }
            if (tfk == null) {
                tfk = new ForeignKey(DBIdentifier.NULL, tcol.getTable());
            }
            tfk.join(tcol, fk.getPrimaryKeyColumn(cols[i]));
        }
        return tfk;
    }

    @Override
    public Object getJoinValue(Object fieldVal, Column col, JDBCStore store) {
        Object o = this.field.getForeignKey().getConstant(col);
        if (o != null) {
            return o;
        }
        col = this.field.getForeignKey().getPrimaryKeyColumn(col);
        if (col == null) {
            throw new InternalException();
        }
        Object savedFieldVal = fieldVal;
        ClassMapping relmapping = this.field.getTypeMapping();
        Joinable j = this.field.getTypeMapping().assertJoinable(col);
        if (ImplHelper.isManageable((Object)fieldVal) && !this.field.getDefiningMetaData().useIdClassFromParent()) {
            fieldVal = store.getContext().getObjectId(fieldVal);
        }
        if (fieldVal instanceof OpenJPAId) {
            fieldVal = ((OpenJPAId)fieldVal).getIdObject();
        }
        if (relmapping.getObjectIdType() != null && relmapping.getObjectIdType().isInstance(fieldVal)) {
            Object[] pks = ApplicationIds.toPKValues((Object)fieldVal, (ClassMetaData)relmapping);
            fieldVal = pks[relmapping.getField(j.getFieldIndex()).getPrimaryKeyIndex()];
        } else if (relmapping.getObjectIdType() == ObjectId.class && relmapping.getPrimaryKeyFieldMappings()[0].getValueMapping().isEmbedded()) {
            if (fieldVal == null) {
                return j.getJoinValue(savedFieldVal, col, store);
            }
            return j.getJoinValue(fieldVal, col, store);
        }
        return j.getJoinValue(fieldVal, col, store);
    }

    @Override
    public Object getJoinValue(OpenJPAStateManager sm, Column col, JDBCStore store) {
        return this.getJoinValue(sm.fetch(this.field.getIndex()), col, store);
    }

    @Override
    public void setAutoAssignedValue(OpenJPAStateManager sm, JDBCStore store, Column col, Object autoInc) {
        throw new UnsupportedException();
    }

    @Override
    public Column[] getColumns() {
        return this.field.getColumns();
    }

    @Override
    public ColumnIO getColumnIO() {
        return this.field.getColumnIO();
    }

    @Override
    public Object[] getResultArguments() {
        return null;
    }

    @Override
    public Object toEmbeddedDataStoreValue(Object val, JDBCStore store) {
        return this.toDataStoreValue(val, store);
    }

    @Override
    public Object toEmbeddedObjectValue(Object val) {
        return UNSUPPORTED;
    }

    @Override
    public void loadEmbedded(OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch, Object val) throws SQLException {
        Object oid;
        ClassMapping relMapping = this.field.getTypeMapping();
        if (val == null) {
            oid = null;
        } else if (relMapping.getIdentityType() == 1) {
            oid = store.newDataStoreId(((Number)val).longValue(), relMapping, this.field.getPolymorphic() != 1);
        } else {
            Object[] objectArray;
            if (this.getColumns().length == 1) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = val;
            } else {
                objectArray = (Object[])val;
            }
            Object[] pks = objectArray;
            boolean nulls = true;
            for (int i = 0; nulls && i < pks.length; ++i) {
                nulls = pks[i] == null;
            }
            if (nulls) {
                oid = null;
            } else {
                oid = ApplicationIds.fromPKValues((Object[])pks, (ClassMetaData)relMapping);
                if (this.field.getPolymorphic() == 1 && oid instanceof OpenJPAId) {
                    ((OpenJPAId)oid).setManagedInstanceType(relMapping.getDescribedType());
                }
            }
        }
        if (oid == null) {
            sm.storeObject(this.field.getIndex(), null);
        } else if (JavaTypes.maybePC((ValueMetaData)this.field.getValue()) && this.field.getElement().getEmbeddedMetaData() == null) {
            Object obj = store.find(oid, this.field, fetch);
            sm.storeObject(this.field.getIndex(), obj);
        } else {
            sm.setIntermediate(this.field.getIndex(), oid);
        }
    }
}

