/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.validation;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.validation.AbstractValidationConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.validation.FeedbackMessageBehaviorVisitor;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.validation.ParametrizedFunction;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.validation.ValidationJS;
import de.agilecoders.wicket.jquery.JQuery;
import de.agilecoders.wicket.jquery.function.IFunction;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.visit.IVisitor;

public abstract class ValidationBehavior<T extends AbstractValidationConfig>
extends Behavior {
    private static final long serialVersionUID = 1L;
    private static final String attribute = "wb-validation-message";
    protected final T config;

    public ValidationBehavior(T config) {
        this.config = (AbstractValidationConfig)((Object)Args.notNull(config, (String)"config"));
    }

    public void bind(Component component) {
        super.bind(component);
        if (component instanceof MarkupContainer) {
            FeedbackMessageBehaviorVisitor.add((MarkupContainer)component, attribute);
        }
    }

    public void onEvent(Component component, IEvent<?> event) {
        if (event.getPayload() instanceof IPartialPageRequestHandler) {
            IPartialPageRequestHandler target = (IPartialPageRequestHandler)event.getPayload();
            if (component instanceof Form) {
                this.attachJavaScript(target, component);
            } else if (component instanceof MarkupContainer) {
                for (Form form : this.getChildren((MarkupContainer)component, Form.class)) {
                    this.attachJavaScript(target, (Component)form);
                }
            }
        }
    }

    public void renderHead(Component component, IHeaderResponse response) {
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)ValidationJS.common()));
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)("$.wb_validation.updateConfig(" + this.getConfig().toJsonString() + ");")));
        if (component instanceof Form) {
            this.renderJavaScript(response, component);
        } else if (component instanceof MarkupContainer) {
            for (Form form : this.getChildren((MarkupContainer)component, Form.class)) {
                this.renderJavaScript(response, (Component)form);
            }
        }
    }

    public T getConfig() {
        return this.config;
    }

    private void attachJavaScript(IPartialPageRequestHandler target, Component component) {
        target.appendJavaScript((CharSequence)JQuery.$((Component)component).chain((CharSequence)"wb_validation").get());
    }

    private void renderJavaScript(IHeaderResponse response, Component component) {
        response.render((HeaderItem)JQuery.$((Component)component).chain((IFunction)ParametrizedFunction.func("wb_validation", "validate")).asDomReadyScript());
    }

    private <T extends Component> List<T> getChildren(MarkupContainer container, Class<T> clazz) {
        ArrayList result = new ArrayList();
        IVisitor visitor = (object, visit) -> result.add((Component)clazz.cast(object));
        container.visitChildren(clazz, visitor);
        return result;
    }
}

