/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.RealmMember;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyObjectUR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.ConnObject;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.OrgUnit;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.provisioning.java.utils.TemplateUtils;
import org.apache.syncope.core.spring.security.Encryptor;
import org.apache.syncope.core.spring.security.PasswordGenerator;
import org.identityconnectors.common.security.GuardedByteArray;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class ConnObjectUtils {
    protected static final Logger LOG = LoggerFactory.getLogger(ConnObjectUtils.class);
    protected final TemplateUtils templateUtils;
    protected final RealmDAO realmDAO;
    protected final UserDAO userDAO;
    protected final ExternalResourceDAO resourceDAO;
    protected final PasswordGenerator passwordGenerator;
    protected final MappingManager mappingManager;
    protected final AnyUtilsFactory anyUtilsFactory;

    public static SyncToken toSyncToken(String syncToken) {
        return Optional.ofNullable(syncToken).map(st -> (SyncToken)POJOHelper.deserialize((String)st, SyncToken.class)).orElse(null);
    }

    public static String toString(SyncToken syncToken) {
        return Optional.ofNullable(syncToken).map(POJOHelper::serialize).orElse(null);
    }

    public static String getPassword(Object pwd) {
        StringBuilder result = new StringBuilder();
        if (pwd instanceof GuardedString) {
            result.append(SecurityUtil.decrypt((GuardedString)((GuardedString)pwd)));
        } else if (pwd instanceof GuardedByteArray) {
            result.append(Arrays.toString(SecurityUtil.decrypt((GuardedByteArray)((GuardedByteArray)pwd))));
        } else if (pwd instanceof String) {
            result.append((String)pwd);
        } else {
            result.append(pwd.toString());
        }
        return result.toString();
    }

    public static ConnObject getConnObjectTO(String fiql, Set<Attribute> attrs) {
        ConnObject connObjectTO = new ConnObject();
        connObjectTO.setFiql(fiql);
        if (!CollectionUtils.isEmpty(attrs)) {
            connObjectTO.getAttrs().addAll(attrs.stream().map(attr -> {
                Attr attrTO = new Attr();
                attrTO.setSchema(attr.getName());
                if (!CollectionUtils.isEmpty((Collection)attr.getValue())) {
                    attr.getValue().stream().filter(Objects::nonNull).forEach(value -> {
                        if (value instanceof GuardedString || value instanceof GuardedByteArray) {
                            attrTO.getValues().add(ConnObjectUtils.getPassword(value));
                        } else if (value instanceof byte[]) {
                            attrTO.getValues().add(Base64.getEncoder().encodeToString((byte[])value));
                        } else {
                            attrTO.getValues().add(value.toString());
                        }
                    });
                }
                return attrTO;
            }).collect(Collectors.toList()));
        }
        return connObjectTO;
    }

    public ConnObjectUtils(TemplateUtils templateUtils, RealmDAO realmDAO, UserDAO userDAO, ExternalResourceDAO resourceDAO, PasswordGenerator passwordGenerator, MappingManager mappingManager, AnyUtilsFactory anyUtilsFactory) {
        this.templateUtils = templateUtils;
        this.realmDAO = realmDAO;
        this.userDAO = userDAO;
        this.resourceDAO = resourceDAO;
        this.passwordGenerator = passwordGenerator;
        this.mappingManager = mappingManager;
        this.anyUtilsFactory = anyUtilsFactory;
    }

    @Transactional(readOnly=true)
    public <C extends AnyCR> C getAnyCR(ConnectorObject obj, PullTask pullTask, AnyTypeKind anyTypeKind, Provision provision, boolean generatePassword) {
        Object anyTO = this.getAnyTOFromConnObject(obj, pullTask, anyTypeKind, provision);
        AnyCR anyCR = this.anyUtilsFactory.getInstance(anyTypeKind).newAnyCR();
        EntityTOUtils.toAnyCR(anyTO, (AnyCR)anyCR);
        if (anyCR instanceof UserCR && StringUtils.isBlank((CharSequence)((UserCR)anyCR).getPassword()) && generatePassword) {
            UserCR userCR = (UserCR)anyCR;
            ArrayList passwordPolicies = new ArrayList();
            userCR.getResources().stream().map(arg_0 -> ((ExternalResourceDAO)this.resourceDAO).find(arg_0)).filter(r -> r != null && r.getPasswordPolicy() != null).forEach(r -> passwordPolicies.add(r.getPasswordPolicy()));
            Optional.ofNullable(this.realmDAO.findByFullPath(userCR.getRealm())).ifPresent(realm -> this.realmDAO.findAncestors(realm).stream().filter(ancestor -> ancestor.getPasswordPolicy() != null && !passwordPolicies.contains(ancestor.getPasswordPolicy())).forEach(ancestor -> passwordPolicies.add(ancestor.getPasswordPolicy())));
            userCR.setPassword(this.passwordGenerator.generate(passwordPolicies));
        }
        return (C)anyCR;
    }

    public RealmTO getRealmTO(ConnectorObject obj, OrgUnit orgUnit) {
        RealmTO realmTO = new RealmTO();
        MappingUtils.getPullItems(orgUnit.getItems().stream()).forEach(item -> this.mappingManager.setIntValues(item, obj.getAttributeByName(item.getExtAttrName()), realmTO));
        return realmTO;
    }

    @Transactional(readOnly=true)
    public <U extends AnyUR> U getAnyUR(String key, ConnectorObject obj, AnyTO original, PullTask pullTask, AnyTypeKind anyTypeKind, Provision provision) {
        AnyObjectUR anyUR;
        Object updated = this.getAnyTOFromConnObject(obj, pullTask, anyTypeKind, provision);
        updated.setKey(key);
        switch (provision.getAnyType()) {
            case "USER": {
                UserTO originalUser = (UserTO)original;
                UserTO updatedUser = (UserTO)updated;
                if (StringUtils.isBlank((CharSequence)updatedUser.getUsername())) {
                    updatedUser.setUsername(originalUser.getUsername());
                }
                User user = (User)this.userDAO.authFind(key);
                if (StringUtils.isBlank((CharSequence)updatedUser.getPassword()) || Encryptor.getInstance().verify(updatedUser.getPassword(), user.getCipherAlgorithm(), user.getPassword())) {
                    updatedUser.setPassword(null);
                }
                updatedUser.setSecurityQuestion(originalUser.getSecurityQuestion());
                if (!this.mappingManager.hasMustChangePassword(provision)) {
                    updatedUser.setMustChangePassword(originalUser.isMustChangePassword());
                }
                anyUR = AnyOperations.diff((UserTO)updatedUser, (UserTO)originalUser, (boolean)true);
                break;
            }
            case "GROUP": {
                GroupTO originalGroup = (GroupTO)original;
                GroupTO updatedGroup = (GroupTO)updated;
                if (StringUtils.isBlank((CharSequence)updatedGroup.getName())) {
                    updatedGroup.setName(originalGroup.getName());
                }
                updatedGroup.setUserOwner(originalGroup.getUserOwner());
                updatedGroup.setGroupOwner(originalGroup.getGroupOwner());
                updatedGroup.setUDynMembershipCond(originalGroup.getUDynMembershipCond());
                updatedGroup.getADynMembershipConds().putAll(originalGroup.getADynMembershipConds());
                updatedGroup.getTypeExtensions().addAll(originalGroup.getTypeExtensions());
                anyUR = AnyOperations.diff((GroupTO)updatedGroup, (GroupTO)originalGroup, (boolean)true);
                break;
            }
            default: {
                AnyObjectTO originalAnyObject = (AnyObjectTO)original;
                AnyObjectTO updatedAnyObject = (AnyObjectTO)updated;
                if (StringUtils.isBlank((CharSequence)updatedAnyObject.getName())) {
                    updatedAnyObject.setName(originalAnyObject.getName());
                }
                anyUR = AnyOperations.diff((AnyObjectTO)updatedAnyObject, (AnyObjectTO)originalAnyObject, (boolean)true);
            }
        }
        if (anyUR != null) {
            anyUR.setRealm(null);
            AnyOperations.cleanEmptyAttrs(updated, (AnyUR)anyUR);
        }
        return (U)anyUR;
    }

    protected <T extends AnyTO> T getAnyTOFromConnObject(ConnectorObject obj, PullTask pullTask, AnyTypeKind anyTypeKind, Provision provision) {
        AnyTO anyTO = this.anyUtilsFactory.getInstance(anyTypeKind).newAnyTO();
        anyTO.setType(provision.getAnyType());
        anyTO.getAuxClasses().addAll(provision.getAuxClasses());
        anyTO.setRealm(pullTask.getDestinationRealm().getFullPath());
        MappingUtils.getPullItems(provision.getMapping().getItems().stream()).forEach(item -> this.mappingManager.setIntValues(item, obj.getAttributeByName(item.getExtAttrName()), anyTO));
        this.templateUtils.apply((RealmMember)anyTO, pullTask.getTemplate(provision.getAnyType()));
        return (T)anyTO;
    }
}

