/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.Iterator;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ApplicationTO;
import org.apache.syncope.common.lib.to.PrivilegeTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.dao.ApplicationDAO;
import org.apache.syncope.core.persistence.api.entity.Application;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Privilege;
import org.apache.syncope.core.provisioning.api.data.ApplicationDataBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationDataBinderImpl
implements ApplicationDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(ApplicationDataBinder.class);
    protected final ApplicationDAO applicationDAO;
    protected final EntityFactory entityFactory;

    public ApplicationDataBinderImpl(ApplicationDAO applicationDAO, EntityFactory entityFactory) {
        this.applicationDAO = applicationDAO;
        this.entityFactory = entityFactory;
    }

    public Application create(ApplicationTO applicationTO) {
        return this.update((Application)this.entityFactory.newEntity(Application.class), applicationTO);
    }

    public Application update(Application toBeUpdated, ApplicationTO applicationTO) {
        toBeUpdated.setKey(applicationTO.getKey());
        Application application = this.applicationDAO.save(toBeUpdated);
        application.setDescription(applicationTO.getDescription());
        applicationTO.getPrivileges().forEach(privilegeTO -> {
            if (privilegeTO == null) {
                LOG.error("Null {}", (Object)PrivilegeTO.class.getSimpleName());
            } else {
                Privilege privilege = this.applicationDAO.findPrivilege(privilegeTO.getKey());
                if (privilege == null) {
                    privilege = (Privilege)this.entityFactory.newEntity(Privilege.class);
                    privilege.setKey(privilegeTO.getKey());
                    privilege.setApplication(application);
                    application.add(privilege);
                } else if (!application.equals(privilege.getApplication())) {
                    SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPrivilege);
                    sce.getElements().add("Privilege " + privilege.getKey() + " already owned by " + String.valueOf(privilege.getApplication()));
                    throw sce;
                }
                privilege.setDescription(privilegeTO.getDescription());
                privilege.setSpec(privilegeTO.getSpec());
            }
        });
        Iterator itor = application.getPrivileges().iterator();
        while (itor.hasNext()) {
            Privilege privilege = (Privilege)itor.next();
            if (applicationTO.getPrivileges().stream().anyMatch(privilegeTO -> privilege.getKey().equals(privilegeTO.getKey()))) continue;
            privilege.setApplication(null);
            itor.remove();
        }
        return application;
    }

    public PrivilegeTO getPrivilegeTO(Privilege privilege) {
        PrivilegeTO privilegeTO = new PrivilegeTO();
        privilegeTO.setKey(privilege.getKey());
        privilegeTO.setDescription(privilege.getDescription());
        privilegeTO.setApplication(privilege.getApplication().getKey());
        privilegeTO.setSpec(privilege.getSpec());
        return privilegeTO;
    }

    public ApplicationTO getApplicationTO(Application application) {
        ApplicationTO applicationTO = new ApplicationTO();
        applicationTO.setKey(application.getKey());
        applicationTO.setDescription(application.getDescription());
        applicationTO.getPrivileges().addAll(application.getPrivileges().stream().map(this::getPrivilegeTO).collect(Collectors.toList()));
        return applicationTO;
    }
}

