/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.child;

import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.child.BaseChildElementParser;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.MultiInstanceLoopCharacteristics;
import org.flowable.bpmn.model.VariableAggregationDefinition;

public class VariableAggregationDefinitionParser
extends BaseChildElementParser {
    @Override
    public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
        if (!(parentElement instanceof MultiInstanceLoopCharacteristics)) {
            return;
        }
        MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics = (MultiInstanceLoopCharacteristics)parentElement;
        VariableAggregationDefinition aggregationDefinition = new VariableAggregationDefinition();
        if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "class"))) {
            aggregationDefinition.setImplementation(xtr.getAttributeValue(null, "class"));
            aggregationDefinition.setImplementationType("class");
        } else if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "delegateExpression"))) {
            aggregationDefinition.setImplementation(xtr.getAttributeValue(null, "delegateExpression"));
            aggregationDefinition.setImplementationType("delegateExpression");
        }
        aggregationDefinition.setTarget(xtr.getAttributeValue(null, "target"));
        aggregationDefinition.setTargetExpression(xtr.getAttributeValue(null, "targetExpression"));
        aggregationDefinition.setStoreAsTransientVariable(Boolean.parseBoolean(xtr.getAttributeValue(null, "storeAsTransientVariable")));
        aggregationDefinition.setCreateOverviewVariable(Boolean.parseBoolean(xtr.getAttributeValue(null, "createOverviewVariable")));
        multiInstanceLoopCharacteristics.addAggregation(aggregationDefinition);
        boolean readyWithAggregation = false;
        try {
            while (!readyWithAggregation && xtr.hasNext()) {
                xtr.next();
                if (xtr.isStartElement() && "variable".equalsIgnoreCase(xtr.getLocalName())) {
                    VariableAggregationDefinition.Variable definition = new VariableAggregationDefinition.Variable();
                    definition.setSource(xtr.getAttributeValue(null, "source"));
                    definition.setSourceExpression(xtr.getAttributeValue(null, "sourceExpression"));
                    definition.setTarget(xtr.getAttributeValue(null, "target"));
                    definition.setTargetExpression(xtr.getAttributeValue(null, "targetExpression"));
                    aggregationDefinition.addDefinition(definition);
                    continue;
                }
                if (!xtr.isEndElement() || !this.getElementName().equalsIgnoreCase(xtr.getLocalName())) continue;
                readyWithAggregation = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error parsing collection child elements", (Throwable)e);
        }
    }

    @Override
    public String getElementName() {
        return "variableAggregation";
    }
}

