/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.config.builder;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.pac4j.config.builder.AbstractBuilder;
import org.pac4j.core.client.Client;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.config.SAML2Configuration;

public class Saml2ClientBuilder
extends AbstractBuilder {
    public Saml2ClientBuilder(Map<String, String> properties) {
        super(properties);
    }

    public void tryCreateSaml2Client(List<Client> clients) {
        for (int i = 0; i <= 100; ++i) {
            String wantsResponsesSigned;
            String wantsAssertionsSigned;
            String responseBindingType;
            String passive;
            String nameIdAttribute;
            String mappedAttributes;
            String authnRequestSigned;
            String issuerFormat;
            String comparisonType;
            String authnContextClassRefs;
            String attributeAsId;
            String forceAuth;
            String assertionConsumerServiceIndex;
            String acceptedSkew;
            String keystorePassword = this.getProperty("saml.keystorePassword", i);
            String privateKeyPassword = this.getProperty("saml.privateKeyPassword", i);
            String keystorePath = this.getProperty("saml.keystorePath", i);
            String identityProviderMetadataPath = this.getProperty("saml.identityProviderMetadataPath", i);
            if (!CommonHelper.isNotBlank((String)keystorePassword) || !CommonHelper.isNotBlank((String)privateKeyPassword) || !CommonHelper.isNotBlank((String)keystorePath) || !CommonHelper.isNotBlank((String)identityProviderMetadataPath)) continue;
            String maximumAuthenticationLifetime = this.getProperty("saml.maximumAuthenticationLifetime", i);
            String serviceProviderEntityId = this.getProperty("saml.serviceProviderEntityId", i);
            String serviceProviderMetadataPath = this.getProperty("saml.serviceProviderMetadataPath", i);
            String destinationBindingType = this.getProperty("saml.authnRequestBindingType", i);
            String keystoreAlias = this.getProperty("saml.keystoreAlias", i);
            SAML2Configuration cfg = new SAML2Configuration(keystorePath, keystorePassword, privateKeyPassword, identityProviderMetadataPath);
            if (CommonHelper.isNotBlank((String)maximumAuthenticationLifetime)) {
                cfg.setMaximumAuthenticationLifetime((long)Integer.parseInt(maximumAuthenticationLifetime));
            }
            if (CommonHelper.isNotBlank((String)serviceProviderEntityId)) {
                cfg.setServiceProviderEntityId(serviceProviderEntityId);
            }
            if (CommonHelper.isNotBlank((String)serviceProviderMetadataPath)) {
                cfg.setServiceProviderMetadataPath(serviceProviderMetadataPath);
            }
            if (CommonHelper.isNotBlank((String)destinationBindingType)) {
                cfg.setAuthnRequestBindingType(destinationBindingType);
            }
            if (CommonHelper.isNotBlank((String)keystoreAlias)) {
                cfg.setKeystoreAlias(keystoreAlias);
            }
            if (CommonHelper.isNotBlank((String)(acceptedSkew = this.getProperty("saml.acceptedSkew", i)))) {
                cfg.setAcceptedSkew(Long.parseLong(acceptedSkew));
            }
            if (CommonHelper.isNotBlank((String)(assertionConsumerServiceIndex = this.getProperty("saml.assertionConsumerServiceIndex", i)))) {
                cfg.setAssertionConsumerServiceIndex(Integer.parseInt(assertionConsumerServiceIndex));
            }
            if (CommonHelper.isNotBlank((String)(forceAuth = this.getProperty("saml.forceAuth", i)))) {
                cfg.setForceAuth(Boolean.parseBoolean(forceAuth));
            }
            if (CommonHelper.isNotBlank((String)(attributeAsId = this.getProperty("saml.attributeAsId", i)))) {
                cfg.setAttributeAsId(attributeAsId);
            }
            if (CommonHelper.isNotBlank((String)(authnContextClassRefs = this.getProperty("saml.authnContextClassRefs", i)))) {
                cfg.setAuthnContextClassRefs(Arrays.stream(authnContextClassRefs.split(",")).collect(Collectors.toList()));
            }
            if (CommonHelper.isNotBlank((String)(comparisonType = this.getProperty("saml.comparisonType", i)))) {
                cfg.setComparisonType(comparisonType);
            }
            if (CommonHelper.isNotBlank((String)(issuerFormat = this.getProperty("saml.issuerFormat", i)))) {
                cfg.setIssuerFormat(issuerFormat);
            }
            if (CommonHelper.isNotBlank((String)(authnRequestSigned = this.getProperty("saml.authnRequestSigned", i)))) {
                cfg.setAuthnRequestSigned(Boolean.parseBoolean(authnRequestSigned));
            }
            if (CommonHelper.isNotBlank((String)(mappedAttributes = this.getProperty("saml.mappedAttributes", i)))) {
                Map<String, String> mapped = Arrays.stream(mappedAttributes.split(",")).collect(Collectors.toMap(key -> key.split(":")[0], value -> value.split(":")[1]));
                cfg.setMappedAttributes(mapped);
            }
            if (CommonHelper.isNotBlank((String)(nameIdAttribute = this.getProperty("saml.nameIdAttribute", i)))) {
                cfg.setNameIdAttribute(nameIdAttribute);
            }
            if (CommonHelper.isNotBlank((String)(passive = this.getProperty("saml.passive", i)))) {
                cfg.setPassive(Boolean.parseBoolean(passive));
            }
            if (CommonHelper.isNotBlank((String)(responseBindingType = this.getProperty("saml.responseBindingType", i)))) {
                cfg.setResponseBindingType(responseBindingType);
            }
            if (CommonHelper.isNotBlank((String)(wantsAssertionsSigned = this.getProperty("saml.wantsAssertionsSigned", i)))) {
                cfg.setWantsAssertionsSigned(Boolean.parseBoolean(wantsAssertionsSigned));
            }
            if (CommonHelper.isNotBlank((String)(wantsResponsesSigned = this.getProperty("saml.wantsResponsesSigned", i)))) {
                cfg.setWantsResponsesSigned(Boolean.parseBoolean(wantsResponsesSigned));
            }
            SAML2Client saml2Client = new SAML2Client(cfg);
            String clientName = StringUtils.defaultString((String)this.getProperty("client.name", i), (String)this.concat(saml2Client.getName(), i));
            saml2Client.setName(clientName);
            clients.add((Client)saml2Client);
        }
    }
}

