/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.utilities;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.util.Attributes;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;

public class BackgroundColorBehavior
extends BootstrapBaseBehavior {
    private Color color;

    public BackgroundColorBehavior(Color color) {
        this.color = color;
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        Attributes.addClass(tag, this.color.cssClassName());
    }

    public void color(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public static BackgroundColorBehavior primary() {
        return new BackgroundColorBehavior(Color.Primary);
    }

    public static BackgroundColorBehavior secondary() {
        return new BackgroundColorBehavior(Color.Secondary);
    }

    public static BackgroundColorBehavior danger() {
        return new BackgroundColorBehavior(Color.Danger);
    }

    public static BackgroundColorBehavior warning() {
        return new BackgroundColorBehavior(Color.Warning);
    }

    public static BackgroundColorBehavior success() {
        return new BackgroundColorBehavior(Color.Success);
    }

    public static BackgroundColorBehavior info() {
        return new BackgroundColorBehavior(Color.Info);
    }

    public static BackgroundColorBehavior light() {
        return new BackgroundColorBehavior(Color.Light);
    }

    public static BackgroundColorBehavior dark() {
        return new BackgroundColorBehavior(Color.Dark);
    }

    public static BackgroundColorBehavior white() {
        return new BackgroundColorBehavior(Color.White);
    }

    public static BackgroundColorBehavior transparent() {
        return new BackgroundColorBehavior(Color.Transparent);
    }

    public static enum Color {
        Primary("primary"),
        Secondary("secondary"),
        Danger("danger"),
        Warning("warning"),
        Info("info"),
        Success("success"),
        Light("light"),
        Dark("dark"),
        White("white"),
        Transparent("transparent");

        private final String value;

        private Color(String value) {
            this.value = value;
        }

        public String cssClassName() {
            return String.format("bg-%s", this.value);
        }
    }
}

