/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.ecp;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.web.idp.profile.AbstractSamlIdPProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.SamlProfileHandlerConfigurationContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.AuthenticatedAssertionContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileBuilderContext;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Envelope;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.extractor.BasicAuthExtractor;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;

public class ECPSamlIdPProfileHandlerController
extends AbstractSamlIdPProfileHandlerController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ECPSamlIdPProfileHandlerController.class);

    public ECPSamlIdPProfileHandlerController(SamlProfileHandlerConfigurationContext configurationContext) {
        super(configurationContext);
    }

    @PostMapping(path={"/idp/profile/SAML2/SOAP/ECP"}, consumes={"text/xml", "application/vnd.paos+xml"}, produces={"text/xml", "application/vnd.paos+xml"})
    public void handleEcpRequest(HttpServletResponse response, HttpServletRequest request) throws Exception {
        MessageContext soapContext = this.decodeSoapRequest(request);
        Credential credential = this.extractBasicAuthenticationCredential(request, response);
        if (credential == null) {
            LOGGER.error("Credentials could not be extracted from the SAML ECP request");
            response.setStatus(401);
            return;
        }
        if (soapContext == null) {
            LOGGER.error("SAML ECP request could not be determined from the authentication request");
            return;
        }
        Object buildContext = ((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)SamlProfileBuilderContext.builder().httpRequest(request)).httpResponse(response)).binding("urn:oasis:names:tc:SAML:2.0:bindings:PAOS")).messageContext(soapContext)).build();
        this.handleEcpRequest((SamlProfileBuilderContext)buildContext, credential);
    }

    protected void handleEcpRequest(SamlProfileBuilderContext context, Credential credential) throws Exception {
        LOGGER.debug("Handling ECP request for SOAP context [{}]", (Object)context.getMessageContext());
        Envelope envelope = ((SOAP11Context)context.getMessageContext().getSubcontext(SOAP11Context.class)).getEnvelope();
        this.getConfigurationContext().getOpenSamlConfigBean().logObject((XMLObject)envelope);
        AuthnRequest authnRequest = (AuthnRequest)context.getMessageContext().getMessage();
        Pair authenticationContext = Pair.of((Object)authnRequest, (Object)context.getMessageContext());
        try {
            LOGGER.trace("Verifying ECP authentication request [{}]", (Object)authnRequest);
            Pair<SamlRegisteredService, SamlRegisteredServiceServiceProviderMetadataFacade> serviceRequest = this.verifySamlAuthenticationRequest((Pair<? extends RequestAbstractType, MessageContext>)authenticationContext, context.getHttpRequest());
            LOGGER.trace("Attempting to authenticate ECP request for credential id [{}]", (Object)credential.getId());
            Authentication authentication = this.authenticateEcpRequest(credential, (Pair<AuthnRequest, MessageContext>)authenticationContext);
            LOGGER.debug("Authenticated [{}] successfully with authenticated principal [{}]", (Object)credential.getId(), (Object)authentication.getPrincipal());
            LOGGER.trace("Building ECP SAML response for [{}]", (Object)credential.getId());
            String issuer = SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)authnRequest);
            WebApplicationService service = (WebApplicationService)this.getConfigurationContext().getWebApplicationServiceFactory().createService(issuer);
            AuthenticatedAssertionContext casAssertion = this.buildCasAssertion(authentication, (Service)service, (RegisteredService)serviceRequest.getKey(), new LinkedHashMap<String, List<Object>>(0));
            LOGGER.trace("CAS assertion to use for building ECP SAML2 response is [{}]", (Object)casAssertion);
            this.buildSamlResponse(context.getHttpResponse(), context.getHttpRequest(), (Pair<? extends RequestAbstractType, MessageContext>)authenticationContext, casAssertion, context.getBinding());
        }
        catch (AuthenticationException e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            String error = e.getHandlerErrors().values().stream().map(Throwable::getMessage).filter(Objects::nonNull).collect(Collectors.joining(","));
            this.buildEcpFaultResponse(context, error);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            this.buildEcpFaultResponse(context, e.getMessage());
        }
    }

    protected void buildEcpFaultResponse(SamlProfileBuilderContext context, String error) throws Exception {
        context.getHttpRequest().setAttribute("samlError", (Object)error);
        this.getConfigurationContext().getSamlFaultResponseBuilder().build(context);
    }

    protected Authentication authenticateEcpRequest(Credential credential, Pair<AuthnRequest, MessageContext> authnRequest) {
        String issuer = SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)((SAMLObject)authnRequest.getKey()));
        LOGGER.debug("Located issuer [{}] from request prior to authenticating [{}]", (Object)issuer, (Object)credential.getId());
        WebApplicationService service = (WebApplicationService)this.getConfigurationContext().getWebApplicationServiceFactory().createService(issuer);
        service.getAttributes().put("entityId", CollectionUtils.wrapList((Object[])new Object[]{issuer}));
        LOGGER.debug("Executing authentication request for service [{}] on behalf of credential id [{}]", (Object)service, (Object)credential.getId());
        AuthenticationResult authenticationResult = this.getConfigurationContext().getAuthenticationSystemSupport().finalizeAuthenticationTransaction((Service)service, new Credential[]{credential});
        return authenticationResult.getAuthentication();
    }

    private Credential extractBasicAuthenticationCredential(HttpServletRequest request, HttpServletResponse response) {
        BasicAuthExtractor extractor = new BasicAuthExtractor();
        JEEContext webContext = new JEEContext(request, response);
        Optional credentialsResult = extractor.extract((WebContext)webContext, this.configurationContext.getSessionStore());
        if (credentialsResult.isPresent()) {
            UsernamePasswordCredentials credentials = (UsernamePasswordCredentials)credentialsResult.get();
            LOGGER.debug("Received basic authentication ECP request from credentials [{}]", (Object)credentials);
            return new UsernamePasswordCredential(credentials.getUsername(), credentials.getPassword());
        }
        return null;
    }
}

