/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.api.search;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.apache.cxf.jaxrs.ext.search.SearchBean;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchUtils;
import org.apache.cxf.jaxrs.ext.search.visitor.AbstractSearchConditionVisitor;
import org.apache.syncope.common.lib.search.SearchableFields;
import org.apache.syncope.common.lib.search.SpecialAttr;
import org.apache.syncope.common.lib.search.SyncopeFiqlSearchCondition;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyTypeCond;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.dao.search.AuxClassCond;
import org.apache.syncope.core.persistence.api.dao.search.DynRealmCond;
import org.apache.syncope.core.persistence.api.dao.search.MemberCond;
import org.apache.syncope.core.persistence.api.dao.search.MembershipCond;
import org.apache.syncope.core.persistence.api.dao.search.PrivilegeCond;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipCond;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipTypeCond;
import org.apache.syncope.core.persistence.api.dao.search.ResourceCond;
import org.apache.syncope.core.persistence.api.dao.search.RoleCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;

public class SearchCondVisitor
extends AbstractSearchConditionVisitor<SearchBean, SearchCond> {
    protected static final ThreadLocal<String> REALM = new ThreadLocal();
    protected static final ThreadLocal<SearchCond> SEARCH_COND = new ThreadLocal();

    public SearchCondVisitor() {
        super(null);
    }

    public void setRealm(String realm) {
        REALM.set(realm);
    }

    protected static AttrCond createAttrCond(String schema) {
        AttrCond attrCond = SearchableFields.contains((String)schema) ? new AnyCond() : new AttrCond();
        attrCond.setSchema(schema);
        return attrCond;
    }

    protected static String getValue(SearchCondition<SearchBean> sc) {
        String value = SearchUtils.toSqlWildcardString((String)URLDecoder.decode(sc.getStatement().getValue().toString().replace("+", "%2B"), StandardCharsets.UTF_8), (boolean)false);
        if (value.indexOf(37) == -1) {
            value = value.replaceAll("\\\\_", "_");
        }
        return value;
    }

    protected static ConditionType getConditionType(SearchCondition<SearchBean> sc) {
        ConditionType ct = sc.getConditionType();
        if (sc instanceof SyncopeFiqlSearchCondition && sc.getConditionType() == ConditionType.CUSTOM) {
            SyncopeFiqlSearchCondition sfsc = (SyncopeFiqlSearchCondition)sc;
            switch (sfsc.getOperator()) {
                case "=~": {
                    ct = ConditionType.EQUALS;
                    break;
                }
                case "!~": {
                    ct = ConditionType.NOT_EQUALS;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Condition type %s is not supported", sfsc.getOperator()));
                }
            }
        }
        return ct;
    }

    protected SearchCond visitPrimitive(SearchCondition<SearchBean> sc) {
        Optional<AttrCond> reprocess;
        SearchCond leaf;
        String name = this.getRealPropertyName(sc.getStatement().getProperty());
        Optional specialAttrName = SpecialAttr.fromString((String)name);
        String value = SearchCondVisitor.getValue(sc);
        Optional specialAttrValue = SpecialAttr.fromString((String)value);
        AttrCond attrCond = SearchCondVisitor.createAttrCond(name);
        attrCond.setExpression(value);
        ConditionType ct = SearchCondVisitor.getConditionType(sc);
        switch (ct) {
            case EQUALS: 
            case NOT_EQUALS: {
                if (specialAttrName.isEmpty()) {
                    if (specialAttrValue.isPresent() && specialAttrValue.get() == SpecialAttr.NULL) {
                        attrCond.setType(AttrCond.Type.ISNULL);
                        attrCond.setExpression(null);
                    } else if (value.indexOf(37) == -1) {
                        attrCond.setType(sc.getConditionType() == ConditionType.CUSTOM ? AttrCond.Type.IEQ : AttrCond.Type.EQ);
                    } else {
                        attrCond.setType(sc.getConditionType() == ConditionType.CUSTOM ? AttrCond.Type.ILIKE : AttrCond.Type.LIKE);
                    }
                    leaf = SearchCond.getLeaf(attrCond);
                } else {
                    switch ((SpecialAttr)specialAttrName.get()) {
                        case TYPE: {
                            AnyTypeCond typeCond = new AnyTypeCond();
                            typeCond.setAnyTypeKey(value);
                            leaf = SearchCond.getLeaf(typeCond);
                            break;
                        }
                        case AUX_CLASSES: {
                            AuxClassCond auxClassCond = new AuxClassCond();
                            auxClassCond.setAuxClass(value);
                            leaf = SearchCond.getLeaf(auxClassCond);
                            break;
                        }
                        case RESOURCES: {
                            ResourceCond resourceCond = new ResourceCond();
                            resourceCond.setResource(value);
                            leaf = SearchCond.getLeaf(resourceCond);
                            break;
                        }
                        case GROUPS: {
                            MembershipCond groupCond = new MembershipCond();
                            groupCond.setGroup(value);
                            leaf = SearchCond.getLeaf(groupCond);
                            break;
                        }
                        case RELATIONSHIPS: {
                            RelationshipCond relationshipCond = new RelationshipCond();
                            relationshipCond.setAnyObject(value);
                            leaf = SearchCond.getLeaf(relationshipCond);
                            break;
                        }
                        case RELATIONSHIP_TYPES: {
                            RelationshipTypeCond relationshipTypeCond = new RelationshipTypeCond();
                            relationshipTypeCond.setRelationshipTypeKey(value);
                            leaf = SearchCond.getLeaf(relationshipTypeCond);
                            break;
                        }
                        case ROLES: {
                            RoleCond roleCond = new RoleCond();
                            roleCond.setRole(value);
                            leaf = SearchCond.getLeaf(roleCond);
                            break;
                        }
                        case PRIVILEGES: {
                            PrivilegeCond privilegeCond = new PrivilegeCond();
                            privilegeCond.setPrivilege(value);
                            leaf = SearchCond.getLeaf(privilegeCond);
                            break;
                        }
                        case DYNREALMS: {
                            DynRealmCond dynRealmCond = new DynRealmCond();
                            dynRealmCond.setDynRealm(value);
                            leaf = SearchCond.getLeaf(dynRealmCond);
                            break;
                        }
                        case MEMBER: {
                            MemberCond memberCond = new MemberCond();
                            memberCond.setMember(value);
                            leaf = SearchCond.getLeaf(memberCond);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(String.format("Special attr name %s is not supported", specialAttrName));
                        }
                    }
                }
                if (ct != ConditionType.NOT_EQUALS) break;
                Optional<AttrCond> notEquals = leaf.getLeaf(AttrCond.class);
                if (notEquals.isPresent() && notEquals.get().getType() == AttrCond.Type.ISNULL) {
                    notEquals.get().setType(AttrCond.Type.ISNOTNULL);
                    break;
                }
                leaf = SearchCond.getNotLeaf(leaf);
                break;
            }
            case GREATER_OR_EQUALS: {
                attrCond.setType(AttrCond.Type.GE);
                leaf = SearchCond.getLeaf(attrCond);
                break;
            }
            case GREATER_THAN: {
                attrCond.setType(AttrCond.Type.GT);
                leaf = SearchCond.getLeaf(attrCond);
                break;
            }
            case LESS_OR_EQUALS: {
                attrCond.setType(AttrCond.Type.LE);
                leaf = SearchCond.getLeaf(attrCond);
                break;
            }
            case LESS_THAN: {
                attrCond.setType(AttrCond.Type.LT);
                leaf = SearchCond.getLeaf(attrCond);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Condition type %s is not supported", ct.name()));
            }
        }
        if ((reprocess = leaf.getLeaf(AttrCond.class).filter(cond -> "token".equals(cond.getSchema()) && (cond.getType() == AttrCond.Type.ISNULL || cond.getType() == AttrCond.Type.ISNOTNULL) && cond.getExpression() == null)).isPresent()) {
            AnyCond tokenCond = new AnyCond();
            tokenCond.setSchema(reprocess.get().getSchema());
            tokenCond.setType(reprocess.get().getType());
            tokenCond.setExpression(null);
            leaf = SearchCond.getLeaf(tokenCond);
        }
        return leaf;
    }

    protected SearchCond visitCompound(SearchCondition<SearchBean> sc) {
        SearchCond compound;
        ArrayList<SearchCond> searchConds = new ArrayList<SearchCond>();
        sc.getSearchConditions().forEach(searchCond -> searchConds.add(searchCond.getStatement() == null ? this.visitCompound((SearchCondition<SearchBean>)searchCond) : this.visitPrimitive((SearchCondition<SearchBean>)searchCond)));
        switch (sc.getConditionType()) {
            case AND: {
                compound = SearchCond.getAnd(searchConds);
                break;
            }
            case OR: {
                compound = SearchCond.getOr(searchConds);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Condition type %s is not supported", sc.getConditionType().name()));
            }
        }
        return compound;
    }

    public void visit(SearchCondition<SearchBean> sc) {
        SEARCH_COND.set(sc.getStatement() == null ? this.visitCompound(sc) : this.visitPrimitive(sc));
    }

    public SearchCond getQuery() {
        return SEARCH_COND.get();
    }
}

