/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ad.authentication;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.tirasa.connid.bundles.ad.ADConfiguration;
import net.tirasa.connid.bundles.ad.ADConnection;
import net.tirasa.connid.bundles.ldap.LdapAuthenticate;
import net.tirasa.connid.bundles.ldap.LdapConnection;
import net.tirasa.connid.bundles.ldap.search.LdapSearches;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.ConnectorSecurityException;
import org.identityconnectors.framework.common.exceptions.InvalidCredentialException;
import org.identityconnectors.framework.common.exceptions.PasswordExpiredException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.Uid;

public class ADAuthenticate
extends LdapAuthenticate {
    private static final Log LOG = Log.getLog(ADAuthenticate.class);

    public ADAuthenticate(ADConnection conn, ObjectClass oclass, String username, OperationOptions options) {
        super((LdapConnection)conn, oclass, username, options);
    }

    public Uid authenticate(GuardedString password) {
        ConnectorObject authnObject = this.getObjectToAuthenticate();
        LdapConnection.AuthenticationResult authnResult = null;
        if (authnObject != null) {
            String entryDN = authnObject.getName().getNameValue();
            authnResult = this.conn.authenticate(entryDN, password);
        }
        if (!ADAuthenticate.isSuccess(authnResult)) {
            throw new InvalidCredentialException(this.conn.format("authenticationFailed", null, new Object[]{this.username}));
        }
        try {
            authnResult.propagate();
        }
        catch (PasswordExpiredException e) {
            e.initUid(authnObject.getUid());
            throw e;
        }
        return authnObject.getUid();
    }

    protected ConnectorObject getObjectToAuthenticate() {
        List<String> userNameAttrs = this.getUserNameAttributes();
        HashMap<String, ConnectorObject> entryDN2Object = new HashMap<String, ConnectorObject>();
        String dnAttributeName = this.conn.getConfiguration().getDnAttribute();
        for (String baseContext : ((ADConfiguration)this.conn.getConfiguration()).getUserBaseContexts()) {
            for (String userNameAttr : userNameAttrs) {
                Attribute attr = AttributeBuilder.build((String)userNameAttr, (Object[])new Object[]{this.username});
                for (ConnectorObject object : LdapSearches.findObjects((LdapConnection)this.conn, (ObjectClass)this.oclass, (String)baseContext, (Attribute)attr, (String[])new String[]{dnAttributeName})) {
                    String entryDN = object.getAttributeByName(dnAttributeName).getValue().get(0).toString();
                    entryDN2Object.put(entryDN, object);
                }
                if (entryDN2Object.size() <= 1) continue;
                throw new ConnectorSecurityException(this.conn.format("moreThanOneEntryMatched", null, new Object[]{this.username}));
            }
        }
        if (!entryDN2Object.isEmpty()) {
            return (ConnectorObject)entryDN2Object.values().iterator().next();
        }
        return null;
    }

    protected List<String> getUserNameAttributes() {
        String[] result = ((ADConfiguration)((Object)ADConfiguration.class.cast(this.conn.getConfiguration()))).getUserAuthenticationAttributes();
        if (result != null && result.length > 0) {
            return Arrays.asList(result);
        }
        return super.getUserNameAttributes();
    }
}

