/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.profile;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.security.Key;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettings;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyCacheKey;
import org.apereo.cas.oidc.token.BaseOidcJsonWebKeyTokenSigningAndEncryptionService;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.util.jwt.JsonWebTokenEncryptor;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcUserProfileSigningAndEncryptionService
extends BaseOidcJsonWebKeyTokenSigningAndEncryptionService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcUserProfileSigningAndEncryptionService.class);
    public static final String USER_INFO_RESPONSE_ENCRYPTION_ENCODING_DEFAULT = "A128CBC-HS256";
    private final OidcServerDiscoverySettings discoverySettings;

    public OidcUserProfileSigningAndEncryptionService(LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> defaultJsonWebKeystoreCache, LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> serviceJsonWebKeystoreCache, OidcIssuerService issuerService, OidcServerDiscoverySettings discoverySettings) {
        super(defaultJsonWebKeystoreCache, serviceJsonWebKeystoreCache, issuerService);
        this.discoverySettings = discoverySettings;
    }

    public String getJsonWebKeySigningAlgorithm(OAuthRegisteredService svc) {
        if (svc instanceof OidcRegisteredService) {
            return ((OidcRegisteredService)OidcRegisteredService.class.cast(svc)).getUserInfoSigningAlg();
        }
        return super.getJsonWebKeySigningAlgorithm(svc);
    }

    public boolean shouldSignToken(OAuthRegisteredService svc) {
        if (svc instanceof OidcRegisteredService) {
            OidcRegisteredService service = (OidcRegisteredService)svc;
            if ("none".equalsIgnoreCase(service.getUserInfoSigningAlg()) && !this.discoverySettings.getUserInfoSigningAlgValuesSupported().contains("none")) {
                LOGGER.error("Service [{}] has defined 'none' for user-info signing algorithm, yet CAS is configured to support the following signing algorithms: [{}]. This is quite likely due to misconfiguration of the CAS server or the service definition", (Object)svc.getServiceId(), this.discoverySettings.getUserInfoSigningAlgValuesSupported());
                throw new IllegalArgumentException("Unable to use 'none' as user-info signing algorithm");
            }
            return StringUtils.isNotBlank((CharSequence)service.getUserInfoSigningAlg()) && !StringUtils.equalsIgnoreCase((CharSequence)service.getUserInfoSigningAlg(), (CharSequence)"none");
        }
        return false;
    }

    public boolean shouldEncryptToken(OAuthRegisteredService svc) {
        if (svc instanceof OidcRegisteredService) {
            OidcRegisteredService service = (OidcRegisteredService)svc;
            if ("none".equalsIgnoreCase(service.getUserInfoEncryptedResponseAlg()) && !this.discoverySettings.getUserInfoEncryptionAlgValuesSupported().contains("none")) {
                LOGGER.error("Service [{}] has defined 'none' for user-info encryption algorithm, yet CAS is configured to support the following encryption algorithms: [{}]. This is quite likely due to misconfiguration of the CAS server or the service definition", (Object)svc.getServiceId(), this.discoverySettings.getUserInfoEncryptionAlgValuesSupported());
                throw new IllegalArgumentException("Unable to use 'none' as user-info encryption algorithm");
            }
            return StringUtils.isNotBlank((CharSequence)service.getUserInfoEncryptedResponseAlg()) && !StringUtils.equalsIgnoreCase((CharSequence)service.getUserInfoEncryptedResponseAlg(), (CharSequence)"none");
        }
        return false;
    }

    public Set<String> getAllowedSigningAlgorithms(OAuthRegisteredService svc) {
        return this.discoverySettings.getUserInfoSigningAlgValuesSupported();
    }

    @Override
    protected String encryptToken(OAuthRegisteredService service, String innerJwt) {
        if (service instanceof OidcRegisteredService) {
            OidcRegisteredService svc = (OidcRegisteredService)OidcRegisteredService.class.cast(service);
            PublicJsonWebKey jsonWebKey = this.getJsonWebKeyForEncryption((OAuthRegisteredService)svc);
            return JsonWebTokenEncryptor.builder().key((Key)jsonWebKey.getPublicKey()).keyId(jsonWebKey.getKeyId()).algorithm(svc.getIdTokenEncryptionAlg()).encryptionMethod(svc.getIdTokenEncryptionEncoding()).allowedAlgorithms(this.discoverySettings.getUserInfoEncryptionAlgValuesSupported()).allowedContentEncryptionAlgorithms(this.discoverySettings.getUserInfoEncryptionEncodingValuesSupported()).build().encrypt((Serializable)((Object)innerJwt));
        }
        return innerJwt;
    }
}

