/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.impl.history;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apereo.cas.pm.PasswordChangeRequest;
import org.apereo.cas.pm.impl.history.BasePasswordHistoryService;
import org.apereo.cas.pm.impl.history.PasswordHistoryEntity;

public class InMemoryPasswordHistoryService
extends BasePasswordHistoryService {
    private final List<PasswordHistoryEntity> history = new ArrayList<PasswordHistoryEntity>(0);

    @Override
    public boolean exists(PasswordChangeRequest changeRequest) {
        String username = changeRequest.getUsername();
        String password = changeRequest.getPassword();
        String encodedPassword = this.encodePassword(password);
        return this.history.stream().anyMatch(p -> p.getPassword().equalsIgnoreCase(encodedPassword) && p.getUsername().equalsIgnoreCase(username));
    }

    @Override
    public Collection<? extends PasswordHistoryEntity> fetchAll() {
        return new ArrayList<PasswordHistoryEntity>(this.history);
    }

    @Override
    public Collection<? extends PasswordHistoryEntity> fetch(String username) {
        return this.history.stream().filter(p -> p.getUsername().equalsIgnoreCase(username)).collect(Collectors.toList());
    }

    @Override
    public boolean store(PasswordChangeRequest changeRequest) {
        String username = changeRequest.getUsername();
        String password = changeRequest.getPassword();
        String encodedPassword = this.encodePassword(password);
        PasswordHistoryEntity entity = new PasswordHistoryEntity();
        entity.setUsername(username);
        entity.setPassword(encodedPassword);
        this.history.add(entity);
        return true;
    }

    @Override
    public void remove(String username) {
        this.history.removeIf(p -> p.getUsername().equalsIgnoreCase(username));
    }

    @Override
    public void removeAll() {
        this.history.clear();
    }
}

