/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.impl;

import lombok.Generated;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.pm.PasswordChangeRequest;
import org.apereo.cas.pm.PasswordHistoryService;
import org.apereo.cas.pm.PasswordValidationService;
import org.apereo.cas.util.RegexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DefaultPasswordValidationService
implements PasswordValidationService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPasswordValidationService.class);
    private final String policyPattern;
    private final PasswordHistoryService passwordHistoryService;

    @Override
    public boolean isValid(UsernamePasswordCredential upc, PasswordChangeRequest bean) {
        if (!StringUtils.hasText((String)bean.getPassword())) {
            LOGGER.error("Provided password is blank");
            return false;
        }
        if (bean.getPassword().equals(upc.toPassword())) {
            LOGGER.error("Provided password cannot be the same as the current password");
            return false;
        }
        if (!bean.getPassword().equals(bean.getConfirmedPassword())) {
            LOGGER.error("Provided password does not match the confirmed password");
            return false;
        }
        if (!RegexUtils.find((String)this.policyPattern, (String)bean.getPassword())) {
            LOGGER.error("Provided password does not match the pattern required for password policy [{}]", (Object)this.policyPattern);
            return false;
        }
        if (this.passwordHistoryService.exists(bean)) {
            LOGGER.error("Recycled password from password history is not allowed for [{}]", (Object)bean.getUsername());
            return false;
        }
        return this.validatePassword(upc, bean);
    }

    protected boolean validatePassword(UsernamePasswordCredential credential, PasswordChangeRequest bean) {
        return true;
    }

    @Generated
    public DefaultPasswordValidationService(String policyPattern, PasswordHistoryService passwordHistoryService) {
        this.policyPattern = policyPattern;
        this.passwordHistoryService = passwordHistoryService;
    }
}

