/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.to.AuthProfileTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.logic.AbstractAuthProfileLogic;
import org.apache.syncope.core.persistence.api.dao.AuthProfileDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.am.AuthProfile;
import org.apache.syncope.core.provisioning.api.data.AuthProfileDataBinder;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class AuthProfileLogic
extends AbstractAuthProfileLogic {
    public AuthProfileLogic(AuthProfileDAO authProfileDAO, AuthProfileDataBinder binder) {
        super(authProfileDAO, binder);
    }

    @PreAuthorize(value="hasRole('AUTH_PROFILE_LIST')")
    @Transactional(readOnly=true)
    public Pair<Integer, List<AuthProfileTO>> list(int page, int size) {
        int count = this.authProfileDAO.count();
        List result = this.authProfileDAO.findAll(page, size).stream().map(arg_0 -> ((AuthProfileDataBinder)this.binder).getAuthProfileTO(arg_0)).collect(Collectors.toList());
        return Pair.of((Object)count, result);
    }

    @PreAuthorize(value="hasRole('AUTH_PROFILE_READ') ")
    @Transactional(readOnly=true)
    public AuthProfileTO read(String key) {
        return Optional.ofNullable(this.authProfileDAO.find(key)).map(arg_0 -> ((AuthProfileDataBinder)this.binder).getAuthProfileTO(arg_0)).orElseThrow(() -> new NotFoundException(key + " not found"));
    }

    @PreAuthorize(value="isAuthenticated() and not(hasRole('ANONYMOUS'))")
    @Transactional(readOnly=true)
    public AuthProfileTO selfRead() {
        return this.authProfileDAO.findByOwner(AuthContextUtils.getUsername()).map(arg_0 -> ((AuthProfileDataBinder)this.binder).getAuthProfileTO(arg_0)).orElseThrow(() -> new NotFoundException("AuthProfile for " + AuthContextUtils.getUsername()));
    }

    @PreAuthorize(value="hasRole('AUTH_PROFILE_CREATE') ")
    public AuthProfileTO create(AuthProfileTO authProfileTO) {
        return this.binder.getAuthProfileTO(this.authProfileDAO.save(this.binder.create(authProfileTO)));
    }

    @PreAuthorize(value="hasRole('AUTH_PROFILE_UPDATE') ")
    public void update(AuthProfileTO authProfileTO) {
        AuthProfile authProfile = Optional.ofNullable(this.authProfileDAO.find(authProfileTO.getKey())).orElseThrow(() -> new NotFoundException(authProfileTO.getKey() + " not found"));
        this.binder.update(authProfile, authProfileTO);
        this.authProfileDAO.save(authProfile);
    }

    @PreAuthorize(value="isAuthenticated() and not(hasRole('ANONYMOUS'))")
    public void selfUpdate(AuthProfileTO authProfileTO) {
        this.authProfileDAO.findByOwner(AuthContextUtils.getUsername()).filter(authProfile -> authProfile.getKey().equals(authProfileTO.getKey()) && authProfile.getOwner().equals(authProfileTO.getOwner())).orElseThrow(() -> new DelegatedAdministrationException(AnyTypeKind.USER, authProfileTO.getOwner()));
        this.update(authProfileTO);
    }

    @PreAuthorize(value="hasRole('AUTH_PROFILE_DELETE') ")
    public void delete(String key) {
        this.authProfileDAO.delete(key);
    }

    @PreAuthorize(value="isAuthenticated() and not(hasRole('ANONYMOUS'))")
    public void selfDelete() {
        this.authProfileDAO.delete(((AuthProfile)this.authProfileDAO.findByOwner(AuthContextUtils.getUsername()).orElseThrow(() -> new DelegatedAdministrationException(AnyTypeKind.USER, AuthContextUtils.getUsername()))).getKey());
    }
}

