/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.logging.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.logging.LogSpi;

public class JDKLogger
implements LogSpi {
    private volatile ConcurrentMap<String, Logger> map = new ConcurrentHashMap<String, Logger>(1);

    public void log(Class<?> clazz, String methodName, Log.Level level, String message, Throwable ex) {
        String clazzName = clazz.getName();
        Level jdkLevel = this.getJDKLevel(level);
        Logger logger = this.getJDKLogger(clazzName);
        if (ex == null) {
            logger.logp(jdkLevel, clazzName, methodName, message);
        } else {
            logger.logp(jdkLevel, clazzName, methodName, message, ex);
        }
    }

    public void log(Class<?> clazz, StackTraceElement caller, Log.Level level, String message, Throwable ex) {
        String methodName = null;
        methodName = null != caller ? caller.getMethodName() + (caller.isNativeMethod() ? "(Native Method)" : (caller.getFileName() != null && caller.getLineNumber() >= 0 ? "(" + caller.getFileName() + ":" + caller.getLineNumber() + ")" : (caller.getFileName() != null ? "(" + caller.getFileName() + ")" : "(Unknown Source)"))) : "unknown";
        this.log(clazz, methodName, level, message, ex);
    }

    public boolean isLoggable(Class<?> clazz, Log.Level level) {
        return this.getJDKLogger(clazz.getName()).isLoggable(this.getJDKLevel(level));
    }

    public boolean needToInferCaller(Class<?> clazz, Log.Level level) {
        return true;
    }

    Level getJDKLevel(Log.Level level) {
        Level ret = Level.SEVERE;
        if (Log.Level.OK.equals((Object)level)) {
            ret = Level.FINE;
        } else if (Log.Level.INFO.equals((Object)level)) {
            ret = Level.INFO;
        } else if (Log.Level.WARN.equals((Object)level)) {
            ret = Level.WARNING;
        }
        return ret;
    }

    Logger getJDKLogger(String key) {
        Logger aLogger = (Logger)this.map.get(key);
        if (aLogger == null) {
            aLogger = Logger.getLogger(key);
            Logger old = this.map.putIfAbsent(key, aLogger);
            aLogger = old != null ? old : aLogger;
        }
        return aLogger;
    }

    ConcurrentMap<String, Logger> getMap() {
        return this.map;
    }
}

