/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.u2f.web.flow;

import com.yubico.u2f.U2F;
import com.yubico.u2f.data.DeviceRegistration;
import com.yubico.u2f.data.messages.RegisterRequest;
import com.yubico.u2f.data.messages.RegisterRequestData;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.adaptors.u2f.U2FMultifactorAuthenticationProvider;
import org.apereo.cas.adaptors.u2f.U2FRegistration;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRepository;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.web.flow.actions.AbstractMultifactorAuthenticationAction;
import org.apereo.cas.web.support.WebUtils;
import org.jooq.lambda.Unchecked;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class U2FStartRegistrationAction
extends AbstractMultifactorAuthenticationAction<U2FMultifactorAuthenticationProvider> {
    private final U2F u2f;
    private final String serverAddress;
    private final U2FDeviceRepository u2FDeviceRepository;

    protected Event doExecute(RequestContext requestContext) throws Exception {
        Principal p = this.resolvePrincipal(WebUtils.getAuthentication((RequestContext)requestContext).getPrincipal());
        List registeredDevices = this.u2FDeviceRepository.getRegisteredDevices(p.getId()).stream().map(arg_0 -> ((U2FDeviceRepository)this.u2FDeviceRepository).decode(arg_0)).map(Unchecked.function(r -> DeviceRegistration.fromJson((String)r.getRecord()))).filter(Objects::nonNull).collect(Collectors.toList());
        RegisterRequestData registerRequestData = this.u2f.startRegistration(this.serverAddress, registeredDevices);
        this.u2FDeviceRepository.requestDeviceRegistration(registerRequestData.getRequestId(), p.getId(), registerRequestData.toJson());
        if (!registerRequestData.getRegisterRequests().isEmpty()) {
            RegisterRequest req = (RegisterRequest)registerRequestData.getRegisterRequests().get(0);
            U2FRegistration u2fReg = new U2FRegistration(req.getChallenge(), req.getAppId(), registerRequestData.getRequestId(), p.getId(), registerRequestData.toJson());
            requestContext.getFlowScope().put("u2fReg", (Object)u2fReg);
            return this.success();
        }
        return this.error();
    }

    @Generated
    public U2FStartRegistrationAction(U2F u2f, String serverAddress, U2FDeviceRepository u2FDeviceRepository) {
        this.u2f = u2f;
        this.serverAddress = serverAddress;
        this.u2FDeviceRepository = u2FDeviceRepository;
    }
}

