/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.u2f.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRegistration;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRepository;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.annotation.DeleteOperation;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;

@Endpoint(id="u2fDevices", enableByDefault=false)
public class U2FRegisteredDevicesEndpoint
extends BaseCasActuatorEndpoint {
    private final ObjectProvider<U2FDeviceRepository> u2fDeviceRepository;

    public U2FRegisteredDevicesEndpoint(CasConfigurationProperties casProperties, ObjectProvider<U2FDeviceRepository> u2fDeviceRepository) {
        super(casProperties);
        this.u2fDeviceRepository = u2fDeviceRepository;
    }

    @ReadOperation(produces={"application/json"})
    @Operation(summary="Get all registered devices")
    public Collection<? extends U2FDeviceRegistration> fetchAll() {
        return ((U2FDeviceRepository)this.u2fDeviceRepository.getObject()).getRegisteredDevices().stream().map(arg_0 -> ((U2FDeviceRepository)((U2FDeviceRepository)this.u2fDeviceRepository.getObject())).decode(arg_0)).collect(Collectors.toList());
    }

    @ReadOperation(produces={"application/json"})
    @Operation(summary="Get all registered devices for the user", parameters={@Parameter(name="username", required=true)})
    public Collection<? extends U2FDeviceRegistration> fetchBy(@Selector String username) {
        return ((U2FDeviceRepository)this.u2fDeviceRepository.getObject()).getRegisteredDevices(username).stream().map(arg_0 -> ((U2FDeviceRepository)((U2FDeviceRepository)this.u2fDeviceRepository.getObject())).decode(arg_0)).collect(Collectors.toList());
    }

    @DeleteOperation
    @Operation(summary="Delete all registered devices", parameters={@Parameter(name="username", required=true)})
    public void delete(@Selector String username) {
        ArrayList<U2FDeviceRegistration> registeredDevices = new ArrayList<U2FDeviceRegistration>(((U2FDeviceRepository)this.u2fDeviceRepository.getObject()).getRegisteredDevices(username));
        registeredDevices.forEach(arg_0 -> ((U2FDeviceRepository)((U2FDeviceRepository)this.u2fDeviceRepository.getObject())).deleteRegisteredDevice(arg_0));
    }

    @DeleteOperation
    @Operation(summary="Delete registered device for username and device")
    public void delete(@Selector String username, @Selector Long id) {
        ArrayList registeredDevices = new ArrayList(((U2FDeviceRepository)this.u2fDeviceRepository.getObject()).getRegisteredDevices(username));
        registeredDevices.stream().filter(d -> d.getId() == id.longValue()).forEach(arg_0 -> ((U2FDeviceRepository)((U2FDeviceRepository)this.u2fDeviceRepository.getObject())).deleteRegisteredDevice(arg_0));
    }
}

