/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import java.util.function.IntFunction;
import org.apache.commons.jexl3.JexlCache;

final class MetaCache {
    private final IntFunction<JexlCache<?, ?>> factory;
    private final Set<Reference<JexlCache<?, ?>>> references;
    private final ReferenceQueue<JexlCache<?, ?>> queue;

    MetaCache(IntFunction<JexlCache<?, ?>> factory) {
        this.factory = factory;
        this.references = new HashSet();
        this.queue = new ReferenceQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <K, V> JexlCache<K, V> createCache(int capacity) {
        if (capacity > 0) {
            JexlCache<?, ?> cache = this.factory.apply(capacity);
            if (cache != null) {
                Set<Reference<JexlCache<?, ?>>> set = this.references;
                synchronized (set) {
                    this.references.add(new WeakReference(cache, this.queue));
                    this.cleanUp();
                }
            }
            return cache;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCaches() {
        Set<Reference<JexlCache<?, ?>>> set = this.references;
        synchronized (set) {
            for (Reference<JexlCache<?, ?>> ref : this.references) {
                JexlCache<?, ?> cache = ref.get();
                if (cache == null) continue;
                cache.clear();
            }
            this.cleanUp();
        }
    }

    private int cleanUp() {
        Reference<JexlCache<?, ?>> reference;
        while ((reference = this.queue.poll()) != null) {
            this.references.remove(reference);
        }
        return this.references.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int size() {
        Set<Reference<JexlCache<?, ?>>> set = this.references;
        synchronized (set) {
            return this.cleanUp();
        }
    }
}

