/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.soap;

import java.net.URL;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.spi.AbstractConfiguration;
import org.identityconnectors.framework.spi.ConfigurationProperty;

public class WebServiceConfiguration
extends AbstractConfiguration {
    private String endpoint = null;
    private String servicename = null;
    private String connectionTimeout = "30";
    private String receiveTimeout = "60";
    private String soapActionUriPrefix = null;

    @ConfigurationProperty(displayMessageKey="ENDPOINT_DISPLAY", helpMessageKey="ENDPOINT_HELP", confidential=false, order=1, required=true)
    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @ConfigurationProperty(displayMessageKey="CLASSNAME_DISPLAY", helpMessageKey="CLASSNAME_HELP", confidential=false, order=2, required=true)
    public String getServicename() {
        return this.servicename;
    }

    public void setServicename(String classname) {
        this.servicename = classname;
    }

    @ConfigurationProperty(displayMessageKey="CONNECTIONTIMEOUT_DISPLAY", helpMessageKey="CONNECTIONTIMEOUT_HELP", confidential=false, order=3)
    public String getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(String connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @ConfigurationProperty(displayMessageKey="RECEIVETIMEOUT_DISPLAY", helpMessageKey="RECEIVETIMEOUT_HELP", confidential=false, order=4)
    public String getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(String receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    @ConfigurationProperty(displayMessageKey="SOAPACTION_DISPLAY", helpMessageKey="SOAPACTION_HELP", confidential=false, order=5)
    public String getSoapActionUriPrefix() {
        return this.soapActionUriPrefix;
    }

    public void setSoapActionUriPrefix(String soapActionUriPrefix) {
        this.soapActionUriPrefix = soapActionUriPrefix;
    }

    public void validate() {
        if (StringUtil.isBlank((String)this.endpoint)) {
            throw new IllegalArgumentException("Endpoint cannot be null or empty.");
        }
        if (StringUtil.isBlank((String)this.servicename)) {
            throw new IllegalArgumentException("Service name cannot be null or empty.");
        }
        if (StringUtil.isBlank((String)this.connectionTimeout)) {
            this.connectionTimeout = "30";
        }
        try {
            Long.parseLong(this.connectionTimeout);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The specified connection timeout is not valid.");
        }
        if (StringUtil.isBlank((String)this.receiveTimeout)) {
            this.receiveTimeout = "60";
        }
        try {
            Long.parseLong(this.receiveTimeout);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The specified receive timeout is not valid.");
        }
        try {
            URL endpointURL = new URL(this.endpoint);
            endpointURL.toURI();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The specified endpoint is not a valid URL.");
        }
    }
}

