/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.validation;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationPolicyExecutionResult;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.validation.Assertion;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;

public class AuthenticationPolicyAwareServiceTicketValidationAuthorizer
implements ServiceTicketValidationAuthorizer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationPolicyAwareServiceTicketValidationAuthorizer.class);
    private final ServicesManager servicesManager;
    private final AuthenticationEventExecutionPlan authenticationEventExecutionPlan;
    private final ConfigurableApplicationContext applicationContext;

    public void authorize(HttpServletRequest request, Service service, Assertion assertion) {
        RegisteredService registeredService = this.servicesManager.findServiceBy(service);
        RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)service, (RegisteredService)registeredService);
        LOGGER.debug("Evaluating service [{}] to ensure required authentication handlers can satisfy assertion", (Object)service);
        Authentication primaryAuthentication = assertion.getPrimaryAuthentication();
        Map attributes = primaryAuthentication.getAttributes();
        if (!attributes.containsKey("successfulAuthenticationHandlers")) {
            throw new UnauthorizedServiceException("screen.service.error.message", "");
        }
        Set successfulHandlerNames = CollectionUtils.toCollection(attributes.get("successfulAuthenticationHandlers"));
        Set assertedHandlers = this.authenticationEventExecutionPlan.getAuthenticationHandlers().stream().filter(handler -> successfulHandlerNames.contains(handler.getName())).collect(Collectors.toSet());
        Collection policies = this.authenticationEventExecutionPlan.getAuthenticationPolicies(primaryAuthentication);
        policies.forEach(p -> {
            try {
                String simpleName = p.getClass().getSimpleName();
                LOGGER.trace("Executing authentication policy [{}]", (Object)simpleName);
                AuthenticationPolicyExecutionResult result = p.isSatisfiedBy(primaryAuthentication, assertedHandlers, this.applicationContext, Optional.of(assertion));
                if (!result.isSuccess()) {
                    throw new UnauthorizedServiceException("screen.service.error.message", "");
                }
            }
            catch (Exception e) {
                LoggingUtils.error((Logger)LOGGER, (Throwable)e);
                throw new UnauthorizedServiceException("screen.service.error.message", "");
            }
        });
    }

    @Generated
    public AuthenticationPolicyAwareServiceTicketValidationAuthorizer(ServicesManager servicesManager, AuthenticationEventExecutionPlan authenticationEventExecutionPlan, ConfigurableApplicationContext applicationContext) {
        this.servicesManager = servicesManager;
        this.authenticationEventExecutionPlan = authenticationEventExecutionPlan;
        this.applicationContext = applicationContext;
    }
}

