/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.delete;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.api.BatchPartQuery;
import org.flowable.batch.service.impl.persistence.entity.BatchEntity;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.ManagementService;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.JobHandler;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class DeleteHistoricProcessInstanceIdsStatusJobHandler
implements JobHandler {
    public static final String TYPE = "delete-historic-process-status";

    public String getType() {
        return TYPE;
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        long totalCompleted;
        ProcessEngineConfigurationImpl engineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        ManagementService managementService = engineConfiguration.getManagementService();
        Batch batch = (Batch)managementService.createBatchQuery().batchId(configuration).singleResult();
        if (batch == null) {
            throw new FlowableIllegalArgumentException("There is no batch with the id " + configuration);
        }
        if ("stopped".equals(batch.getStatus())) {
            job.setRepeat(null);
            return;
        }
        long totalBatchParts = this.createStatusQuery(batch, managementService).count();
        if (totalBatchParts == (totalCompleted = this.createStatusQuery(batch, managementService).completed().count())) {
            List failedParts = this.createStatusQuery(batch, managementService).status("failed").list();
            long totalFailed = failedParts.size();
            if (totalFailed == 0L) {
                this.completeBatch(batch, "completed", engineConfiguration);
            } else {
                this.completeBatchFail(batch, failedParts, engineConfiguration);
            }
            job.setRepeat(null);
        } else if (totalBatchParts == 0L) {
            this.completeBatch(batch, "completed", engineConfiguration);
            job.setRepeat(null);
        }
    }

    protected BatchPartQuery createStatusQuery(Batch batch, ManagementService managementService) {
        return managementService.createBatchPartQuery().batchId(batch.getId()).type("deleteProcess");
    }

    protected void completeBatch(Batch batch, String status, ProcessEngineConfigurationImpl engineConfiguration) {
        engineConfiguration.getBatchServiceConfiguration().getBatchService().completeBatch(batch.getId(), status);
    }

    protected void completeBatchFail(Batch batch, List<BatchPart> failedParts, ProcessEngineConfigurationImpl engineConfiguration) {
        this.completeBatch(batch, "failed", engineConfiguration);
        long totalFailedInstances = 0L;
        ObjectMapper objectMapper = engineConfiguration.getObjectMapper();
        for (BatchPart failedPart : failedParts) {
            JsonNode node = this.readJson(failedPart.getResultDocumentJson("bpmn"), objectMapper);
            if (node == null) continue;
            totalFailedInstances += (long)node.path("processInstanceIdsFailedToDelete").size();
        }
        ObjectNode batchDocument = (ObjectNode)this.readJson(batch.getBatchDocumentJson("bpmn"), objectMapper);
        batchDocument.put("numberOfFailedInstances", totalFailedInstances);
        ((BatchEntity)batch).setBatchDocumentJson(batchDocument.toString(), "bpmn");
    }

    protected JsonNode readJson(String json, ObjectMapper objectMapper) {
        if (json == null) {
            return null;
        }
        try {
            return objectMapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            throw new FlowableException("Failed to read json", (Throwable)e);
        }
    }
}

