/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.Map;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.cmd.AbstractExternalWorkerJobCmd;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.CountingEntityUtil;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntity;
import org.flowable.variable.service.VariableService;
import org.flowable.variable.service.VariableServiceConfiguration;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class ExternalWorkerJobCompleteCmd
extends AbstractExternalWorkerJobCmd
implements Command<Void> {
    protected Map<String, Object> variables;

    public ExternalWorkerJobCompleteCmd(String externalJobId, String workerId, Map<String, Object> variables, JobServiceConfiguration jobServiceConfiguration) {
        super(externalJobId, workerId, jobServiceConfiguration);
        this.variables = variables;
    }

    @Override
    protected void runJobLogic(ExternalWorkerJobEntity externalWorkerJob, CommandContext commandContext) {
        externalWorkerJob.setJobHandlerConfiguration(null);
        if (this.variables != null && !this.variables.isEmpty()) {
            ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
            VariableServiceConfiguration variableServiceConfiguration = processEngineConfiguration.getVariableServiceConfiguration();
            VariableService variableService = variableServiceConfiguration.getVariableService();
            for (Map.Entry<String, Object> variableEntry : this.variables.entrySet()) {
                String varName = variableEntry.getKey();
                Object varValue = variableEntry.getValue();
                VariableInstanceEntity variableInstance = variableService.createVariableInstance(varName);
                variableInstance.setScopeId(externalWorkerJob.getProcessInstanceId());
                variableInstance.setSubScopeId(externalWorkerJob.getExecutionId());
                variableInstance.setScopeType("bpmnExternalWorker");
                variableService.insertVariableInstanceWithValue(variableInstance, varValue, externalWorkerJob.getTenantId());
                CountingEntityUtil.handleInsertVariableInstanceEntityCount(variableInstance);
            }
        }
        this.moveExternalWorkerJobToExecutableJob(externalWorkerJob, commandContext);
    }
}

