/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.keymaster.client.self;

import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.keymaster.client.api.KeymasterException;
import org.apache.syncope.common.keymaster.client.self.SelfKeymasterOps;
import org.apache.syncope.common.keymaster.rest.api.service.ConfParamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfKeymasterConfParamOps
extends SelfKeymasterOps
implements ConfParamOps {
    private static final Logger LOG = LoggerFactory.getLogger(ConfParamOps.class);
    private static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();

    public SelfKeymasterConfParamOps(JAXRSClientFactoryBean clientFactory) {
        super(clientFactory);
    }

    public Map<String, Object> list(String domain) {
        return ((ConfParamService)this.client(ConfParamService.class, (Map)Map.of("X-Syncope-Domain", domain))).list();
    }

    public <T> T get(String domain, String key, T defaultValue, Class<T> reference) {
        Response response = ((ConfParamService)this.client(ConfParamService.class, (Map)Map.of("X-Syncope-Domain", domain))).get(key);
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            return defaultValue;
        }
        try {
            return (T)MAPPER.readValue((InputStream)response.readEntity(InputStream.class), reference);
        }
        catch (IOException e) {
            LOG.error("Could not deserialize response", (Throwable)e);
            return defaultValue;
        }
    }

    public <T> void set(String domain, String key, T value) {
        if (value == null) {
            this.remove(domain, key);
        } else {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                MAPPER.writeValue((OutputStream)baos, value);
                ((ConfParamService)this.client(ConfParamService.class, (Map)Map.of("X-Syncope-Domain", domain))).set(key, (InputStream)new ByteArrayInputStream(baos.toByteArray()));
            }
            catch (IOException e) {
                throw new KeymasterException("Could not serialize " + String.valueOf(value), (Throwable)e);
            }
        }
    }

    public void remove(String domain, String key) {
        ((ConfParamService)this.client(ConfParamService.class, (Map)Map.of("X-Syncope-Domain", domain))).remove(key);
    }
}

