/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.csvdir;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import net.tirasa.connid.bundles.csvdir.CSVDirConfiguration;
import net.tirasa.connid.bundles.csvdir.database.FileSystem;
import net.tirasa.connid.bundles.csvdir.methods.CSVDirCreate;
import net.tirasa.connid.bundles.csvdir.methods.CSVDirDelete;
import net.tirasa.connid.bundles.csvdir.methods.CSVDirExecuteQuery;
import net.tirasa.connid.bundles.csvdir.methods.CSVDirFilterTranslator;
import net.tirasa.connid.bundles.csvdir.methods.CSVDirSchema;
import net.tirasa.connid.bundles.csvdir.methods.CSVDirSync;
import net.tirasa.connid.bundles.csvdir.methods.CSVDirTest;
import net.tirasa.connid.bundles.csvdir.methods.CSVDirUpdate;
import net.tirasa.connid.commons.db.FilterWhereBuilder;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.ConnectorIOException;
import org.identityconnectors.framework.common.exceptions.InvalidCredentialException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.FilterBuilder;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.ConnectorClass;
import org.identityconnectors.framework.spi.operations.AuthenticateOp;
import org.identityconnectors.framework.spi.operations.CreateOp;
import org.identityconnectors.framework.spi.operations.DeleteOp;
import org.identityconnectors.framework.spi.operations.SchemaOp;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.framework.spi.operations.SyncOp;
import org.identityconnectors.framework.spi.operations.TestOp;
import org.identityconnectors.framework.spi.operations.UpdateOp;

@ConnectorClass(configurationClass=CSVDirConfiguration.class, displayNameKey="CSVDir")
public class CSVDirConnector
implements Connector,
SearchOp<FilterWhereBuilder>,
SchemaOp,
SyncOp,
CreateOp,
UpdateOp,
DeleteOp,
AuthenticateOp,
TestOp {
    private static final Log LOG = Log.getLog(CSVDirConnector.class);
    private CSVDirConfiguration configuration;

    public final Configuration getConfiguration() {
        return this.configuration;
    }

    public final void init(Configuration cfg) {
        this.configuration = (CSVDirConfiguration)cfg;
    }

    public final Schema schema() {
        return new CSVDirSchema(this.getClass(), this.configuration).execute();
    }

    public final FilterTranslator<FilterWhereBuilder> createFilterTranslator(ObjectClass oclass, OperationOptions options) {
        if (oclass == null || !Arrays.asList(this.configuration.getObjectClass()).contains(oclass.getObjectClassValue())) {
            throw new IllegalArgumentException("Invalid objectclass");
        }
        return new CSVDirFilterTranslator(this, oclass, options);
    }

    public final void executeQuery(ObjectClass oclass, FilterWhereBuilder where, ResultsHandler handler, OperationOptions options) {
        try {
            new CSVDirExecuteQuery(this.configuration, where, handler, options).execute(oclass);
        }
        catch (ClassNotFoundException e) {
            throw new ConnectorIOException((Throwable)e);
        }
        catch (SQLException e) {
            throw new ConnectorIOException((Throwable)e);
        }
    }

    public final void sync(ObjectClass objectClass, SyncToken syncToken, SyncResultsHandler handler, OperationOptions options) {
        try {
            new CSVDirSync(this.configuration, syncToken, handler, options).execute(objectClass);
        }
        catch (ClassNotFoundException e) {
            throw new ConnectorIOException((Throwable)e);
        }
        catch (SQLException ex) {
            throw new ConnectorIOException((Throwable)ex);
        }
    }

    public final SyncToken getLatestSyncToken(ObjectClass objectClass) {
        return new SyncToken((Object)new FileSystem(this.configuration).getHighestTimeStamp(0L));
    }

    public void dispose() {
    }

    public final Uid create(ObjectClass objectClass, Set<Attribute> set, OperationOptions options) {
        try {
            return new CSVDirCreate(this.configuration, set).execute(objectClass);
        }
        catch (ClassNotFoundException e) {
            throw new ConnectorIOException((Throwable)e);
        }
        catch (SQLException e) {
            throw new ConnectorIOException((Throwable)e);
        }
    }

    public final Uid update(ObjectClass objectClass, Uid uid, Set<Attribute> attrs, OperationOptions options) {
        try {
            return new CSVDirUpdate(this.configuration, uid, attrs).execute(objectClass);
        }
        catch (ClassNotFoundException e) {
            throw new ConnectorIOException((Throwable)e);
        }
        catch (SQLException e) {
            throw new ConnectorIOException((Throwable)e);
        }
    }

    public final void delete(ObjectClass objectClass, Uid uid, OperationOptions options) {
        try {
            new CSVDirDelete(this.configuration, uid).execute(objectClass);
        }
        catch (ClassNotFoundException e) {
            throw new ConnectorIOException((Throwable)e);
        }
        catch (SQLException e) {
            throw new ConnectorIOException((Throwable)e);
        }
    }

    public Uid authenticate(final ObjectClass objectClass, final String username, GuardedString password, OperationOptions options) {
        final ArrayList res = new ArrayList();
        final CSVDirFilterTranslator translator = new CSVDirFilterTranslator(this, objectClass, options);
        password.access(new GuardedString.Accessor(){

            public void access(char[] clearChars) {
                Filter uid = FilterBuilder.equalTo((Attribute)AttributeBuilder.build((String)Uid.NAME, (Object[])new Object[]{username}));
                Filter pwd = FilterBuilder.equalTo((Attribute)AttributeBuilder.build((String)CSVDirConnector.this.configuration.getPasswordColumnName(), (Object[])new Object[]{new String(clearChars)}));
                Filter filter = FilterBuilder.and((Filter)uid, (Filter)pwd);
                final ArrayList results = new ArrayList();
                ResultsHandler handler = new ResultsHandler(){

                    public boolean handle(ConnectorObject obj) {
                        if (obj != null && obj.getUid() != null) {
                            results.add(obj.getUid());
                            return true;
                        }
                        return false;
                    }
                };
                OperationOptionsBuilder op = new OperationOptionsBuilder();
                op.setAttributesToGet(new String[0]);
                CSVDirConnector.this.executeQuery(objectClass, (FilterWhereBuilder)translator.translate(filter).get(0), handler, op.build());
                if (results.isEmpty()) {
                    throw new InvalidCredentialException("User not found");
                }
                res.addAll(results);
            }
        });
        return (Uid)res.get(0);
    }

    public final void test() {
        LOG.info("Connection test", new Object[0]);
        try {
            new CSVDirTest(this.configuration).execute();
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Test failed", new Object[0]);
        }
    }
}

