<!--
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->

# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

# [0.20.0](https://github.com/apache/superset/compare/v2021.41.0...v0.20.0) (2024-09-09)

### Bug Fixes

- adjust timeseries grid right offset to match the rest ([#20933](https://github.com/apache/superset/issues/20933)) ([fe581a3](https://github.com/apache/superset/commit/fe581a36404ec1cfe689995b61a43164cb1988df))
- Allow comma in Number Format ([#21817](https://github.com/apache/superset/issues/21817)) ([383dc29](https://github.com/apache/superset/commit/383dc29ad1fb921ee618ed80b847316d77247886))
- Allow only dttm columns in comparison filter in Period over Period chart ([#27209](https://github.com/apache/superset/issues/27209)) ([a4c771e](https://github.com/apache/superset/commit/a4c771e013957e95d80d252dcdedad7046348964))
- annotation broken ([#20651](https://github.com/apache/superset/issues/20651)) ([7f918a4](https://github.com/apache/superset/commit/7f918a4ec0e162be13bf3fc0e2f15aaaa5450cec))
- **annotation:** Address regression from [#24694](https://github.com/apache/superset/issues/24694) ([#24874](https://github.com/apache/superset/issues/24874)) ([f05638b](https://github.com/apache/superset/commit/f05638ba845596faef088efa3ee98686d26dad26))
- Bar charts horizontal margin adjustment error ([#26817](https://github.com/apache/superset/issues/26817)) ([84c48d1](https://github.com/apache/superset/commit/84c48d11d8b3bef244823643804f5fd3d6e3ca86))
- **bar-chart-v2:** remove marker from bar chart V2 ([#20409](https://github.com/apache/superset/issues/20409)) ([b32288f](https://github.com/apache/superset/commit/b32288fddfc077d941452245a4e8002335746ba4))
- **bar-chart:** change legend padding for horizontal orientation ([#27883](https://github.com/apache/superset/issues/27883)) ([cfa0556](https://github.com/apache/superset/commit/cfa0556df7a6d82257deff7753b82628229c6e8c))
- big number with trendline can't calculate cumsum ([#19542](https://github.com/apache/superset/issues/19542)) ([2daa071](https://github.com/apache/superset/commit/2daa07163326b8555488dab523c5479cf92821cf))
- **big number:** time grain control is useless in BigNumber Viz ([#21372](https://github.com/apache/superset/issues/21372)) ([b80f659](https://github.com/apache/superset/commit/b80f6591018858b709194687fe7ea3d244131761))
- **big_number:** white-space: nowrap to prevent wrapping ([#27096](https://github.com/apache/superset/issues/27096)) ([4796484](https://github.com/apache/superset/commit/4796484190010275c037595c79b01d281d09ff60))
- **big-number-chart:** number format is not applying to percentage number of the time comparison ([#27502](https://github.com/apache/superset/issues/27502)) ([d2c9001](https://github.com/apache/superset/commit/d2c90013fcff8b8ff965f2c4420f458ab3ccda10))
- **big-number:** big number gets cut off on a Dashboard ([#20488](https://github.com/apache/superset/issues/20488)) ([24a53c3](https://github.com/apache/superset/commit/24a53c38c68108c47af9f7685542fcb8378915bf))
- **big-number:** Big Number with Trendline Chart is not working if Time Grain is set to Month ([#19043](https://github.com/apache/superset/issues/19043)) ([c32eaf4](https://github.com/apache/superset/commit/c32eaf47e50f5fc0cb7630cbf38819cd03b5294b))
- categorical x-axis can't apply the label of column ([#21869](https://github.com/apache/superset/issues/21869)) ([9aa804e](https://github.com/apache/superset/commit/9aa804e070d9361df5e7dcde326ef16a769ac322))
- **chart & gallery:** make to add mixed time-series into recommended charts ([#20064](https://github.com/apache/superset/issues/20064)) ([f43dbc0](https://github.com/apache/superset/commit/f43dbc0dfdbd9ee21267229b566dfab8f59cd0db))
- chart empty state & result panel when multiple queries are executed display incorrectly ([#20816](https://github.com/apache/superset/issues/20816)) ([279ab95](https://github.com/apache/superset/commit/279ab954b1977f7729442733a31c67715476a620))
- **charts:** big-number display broken in echarts ([#24492](https://github.com/apache/superset/issues/24492)) ([3f17945](https://github.com/apache/superset/commit/3f179457457bc2a21a824895aa1cd99b586d9ea0))
- **charts:** Hide Values greater than Max Y Axis Bound on Mixed Time Series with Bar series ([#21015](https://github.com/apache/superset/issues/21015)) ([bdcc0a9](https://github.com/apache/superset/commit/bdcc0a9bcfff476bcd43edc84f08423d8f415d50))
- **charts:** Time grain is None when dataset uses Jinja ([#25842](https://github.com/apache/superset/issues/25842)) ([7536dd1](https://github.com/apache/superset/commit/7536dd12cdd58a1bca7d72952a2b74641f16c959))
- **chart:** Time Series set showMaxLabel as null for time xAxis ([#20627](https://github.com/apache/superset/issues/20627)) ([9362e27](https://github.com/apache/superset/commit/9362e27ce2ace1803a975ab289fe2024fd195367))
- CI errors as the result of removing React imports ([#29089](https://github.com/apache/superset/issues/29089)) ([a9cebe8](https://github.com/apache/superset/commit/a9cebe81ea8cd1ae56df05d5807baa8f05398cc5))
- Context menu crashing when there is no dimension in Echarts Series charts ([#23797](https://github.com/apache/superset/issues/23797)) ([d4c0ae3](https://github.com/apache/superset/commit/d4c0ae34f4e23d1172d2ae3335f73873b0b37c1e))
- contribution operator meets nan value ([#18782](https://github.com/apache/superset/issues/18782)) ([987740a](https://github.com/apache/superset/commit/987740aa8dfff4bf771b587a40f1e12811453660))
- Contribution percentages for ECharts plugins ([#28368](https://github.com/apache/superset/issues/28368)) ([55f3b46](https://github.com/apache/superset/commit/55f3b46f4105e5bbdd0b025a4b61bc843d8e5b9e))
- custom SQL in the XAxis ([#21847](https://github.com/apache/superset/issues/21847)) ([0a4ecca](https://github.com/apache/superset/commit/0a4ecca9f259e2ee9cff27a879f2a889f876c7d7))
- **Dashboard:** Color inconsistency on refreshes and conflicts ([#27439](https://github.com/apache/superset/issues/27439)) ([313ee59](https://github.com/apache/superset/commit/313ee596f5435894f857d72be7269d5070c8c964))
- **dashboard:** Cross filters with time shifted series ([#23347](https://github.com/apache/superset/issues/23347)) ([78ee60e](https://github.com/apache/superset/commit/78ee60e22788395d5b1989e0cd92136725dd5cf0))
- Data zoom with horizontal orientation ([#27291](https://github.com/apache/superset/issues/27291)) ([7854b62](https://github.com/apache/superset/commit/7854b622a34c9a9674e2c916acb8acbc63714fb8))
- **dependencies:** stopping (and preventing) full lodash library import... now using only method level imports. ([#26710](https://github.com/apache/superset/issues/26710)) ([1d4b8b6](https://github.com/apache/superset/commit/1d4b8b69896776cf8831b8202e69424e14067011))
- Don't apply number formatting to the label in Treemap ([#25249](https://github.com/apache/superset/issues/25249)) ([894f250](https://github.com/apache/superset/commit/894f250229455427a0317f3a2f6aa801a6c26748))
- Drill to detail blocked by tooltip ([#22082](https://github.com/apache/superset/issues/22082)) ([3bc0865](https://github.com/apache/superset/commit/3bc0865d9071cdf32d268ee8fee4c4ad93680429))
- Drill to detail on values with comma ([#21151](https://github.com/apache/superset/issues/21151)) ([0bf4e56](https://github.com/apache/superset/commit/0bf4e56dc3e129d2b9239f055212249ba95521e4))
- drilling on the categorical xaxis on the mixed chart ([#21845](https://github.com/apache/superset/issues/21845)) ([f381154](https://github.com/apache/superset/commit/f38115489b09cb22bb77427bf73462784650cbaa))
- drilling on the categorical xaxis on the stacked barchart v2 ([#21844](https://github.com/apache/superset/issues/21844)) ([f41d0b0](https://github.com/apache/superset/commit/f41d0b0cbf47042bf510dc2b0b24b68e3fa11d37))
- duplicate `truncateXAxis` option in `BarChart` ([#29916](https://github.com/apache/superset/issues/29916)) ([e886cc4](https://github.com/apache/superset/commit/e886cc40fe30e97da545482fe48e63c1d15e7c4e))
- Ensure metrics is an array in Mixed Chart ([#24643](https://github.com/apache/superset/issues/24643)) ([fe2c14f](https://github.com/apache/superset/commit/fe2c14ff3acad11bf0f6a7b6544dfc52a6612152))
- **Explore:** Force different color for same metrics in Mixed Time-Series ([#18603](https://github.com/apache/superset/issues/18603)) ([f565230](https://github.com/apache/superset/commit/f565230d8d8342f7a51b263d2a0865122c8f756e))
- **explore:** make SORT-Descending visible if Sort-by has value ([#17726](https://github.com/apache/superset/issues/17726)) ([d5768ab](https://github.com/apache/superset/commit/d5768ab649a70fd4f541ad4982498f622160b220))
- **explore:** Pie chart label formatting when series is temporal ([#18216](https://github.com/apache/superset/issues/18216)) ([37430d4](https://github.com/apache/superset/commit/37430d404436b3d3833bfd9cbae602718c26c4a8))
- **explore:** Prevent shared controls from checking feature flags outside React render ([#21315](https://github.com/apache/superset/issues/21315)) ([2285ebe](https://github.com/apache/superset/commit/2285ebe72ec4edded6d195052740b7f9f13d1f1b))
- **explore:** Time column label not formatted when GENERIC_X_AXES enabled ([#21294](https://github.com/apache/superset/issues/21294)) ([c3a00d4](https://github.com/apache/superset/commit/c3a00d43d055224d4a31ea9315934a59b556eea7))
- **explore:** Time comparison in Mixed Chart in GENERIC_CHART_AXES not working ([#22945](https://github.com/apache/superset/issues/22945)) ([ed7b353](https://github.com/apache/superset/commit/ed7b3533bcc119b2240a613ebc56ace33f1e1002))
- **Gauge echart:** displaying column label ([#23396](https://github.com/apache/superset/issues/23396)) ([b613167](https://github.com/apache/superset/commit/b613167636aae82170b24f697d79fcd70ef1ac56))
- **generic-axes:** apply contribution before flatten ([#20077](https://github.com/apache/superset/issues/20077)) ([d5802f7](https://github.com/apache/superset/commit/d5802f78964a5027184ff9e7f6b78c14b04fd988))
- **generic-chart-axes:** set x-axis if unset and ff is enabled ([#20107](https://github.com/apache/superset/issues/20107)) ([0b3d3dd](https://github.com/apache/superset/commit/0b3d3dd4caa7f4c31c1ba7229966a40ba0469e85))
- Includes 90° x-axis label rotation ([#26207](https://github.com/apache/superset/issues/26207)) ([39c6488](https://github.com/apache/superset/commit/39c6488463ab81417223a2e1b171c769b86306cf))
- **line-chart:** Formula Annotations on Line Charts are broken ([#20687](https://github.com/apache/superset/issues/20687)) ([acdb271](https://github.com/apache/superset/commit/acdb271422b937314d7175ac85eeeac5ead3bc16))
- lost renameOperator in mixed timeseries chart ([#19802](https://github.com/apache/superset/issues/19802)) ([108a2a4](https://github.com/apache/superset/commit/108a2a4eafc3150f7b7c33ed734e843a5d5c9f62))
- Migration for single metric in Big Number with Time Comparison ([#27351](https://github.com/apache/superset/issues/27351)) ([ad6327d](https://github.com/apache/superset/commit/ad6327db95ba8628e9890e2b2813ae088178d9c1))
- missing shared color in mixed timeseries ([#27403](https://github.com/apache/superset/issues/27403)) ([9ced255](https://github.com/apache/superset/commit/9ced2552dbeeaf60217b385d4c40cbaf4372c787))
- **Mixed Timeseries Chart:** Custom Metric Label ([#17649](https://github.com/apache/superset/issues/17649)) ([89d0d38](https://github.com/apache/superset/commit/89d0d38ed0eb211d44de8067bd091392a0f84f85))
- **mixed-timeseries-plugin:** Second query stacks stacked on top of first query series ([#29119](https://github.com/apache/superset/issues/29119)) ([68fd189](https://github.com/apache/superset/commit/68fd1895865a7c7fefe368db05f6fb22c8f1c048))
- New tooltip inappropriately combines series on mixed chart ([#30137](https://github.com/apache/superset/issues/30137)) ([9cb9e5b](https://github.com/apache/superset/commit/9cb9e5beee0ffda72fec7cffaf5930f3ca2b40ff))
- Null values on Treemap right-click ([#21722](https://github.com/apache/superset/issues/21722)) ([0ff1e49](https://github.com/apache/superset/commit/0ff1e49e3c720ed229f6a08daaa70bf14a053dca))
- pie chart orientation description error ([#21514](https://github.com/apache/superset/issues/21514)) ([c66205f](https://github.com/apache/superset/commit/c66205feac118a444e30cd6b6cb48d2c2e3d6411))
- Pivot Table Conditional Formatting Doesn't Show All Options ([#19071](https://github.com/apache/superset/issues/19071)) ([0e0bece](https://github.com/apache/superset/commit/0e0beceac173f765d8f9a0887732029b78603f6d))
- **plugin-chart-echarts:** [feature parity] annotation line chart color not working ([#19758](https://github.com/apache/superset/issues/19758)) ([1156297](https://github.com/apache/superset/commit/11562971fb95a601d11b2902f1704b72409f302d))
- **plugin-chart-echarts:** [feature-parity] apply button of annotation layer doesn't work as expected ([#19761](https://github.com/apache/superset/issues/19761)) ([9f02ff6](https://github.com/apache/superset/commit/9f02ff656d63e537c06822657dcfc2ff46f70e67))
- **plugin-chart-echarts:** bar chart overflow ([#20805](https://github.com/apache/superset/issues/20805)) ([9bf7ed5](https://github.com/apache/superset/commit/9bf7ed58cdc1d5523d0cb661f8fdbf7df9b10fe7))
- **plugin-chart-echarts:** boxplot throw error in the dashboard ([#21661](https://github.com/apache/superset/issues/21661)) ([61bd696](https://github.com/apache/superset/commit/61bd6962265d879e168f208854fc17b145b9e04d))
- **plugin-chart-echarts:** calculate Gauge Chart intervals correctly when min value is set ([#27285](https://github.com/apache/superset/issues/27285)) ([d65f64d](https://github.com/apache/superset/commit/d65f64d1ceacb69226fa1907343405b5571bc6a8))
- **plugin-chart-echarts:** fix customize margin ([#18958](https://github.com/apache/superset/issues/18958)) ([c4e3c45](https://github.com/apache/superset/commit/c4e3c45b3c24034205a1ceeb5387d63dc666a7fe))
- **plugin-chart-echarts:** fix forecasts on verbose metrics ([#18252](https://github.com/apache/superset/issues/18252)) ([2929bb1](https://github.com/apache/superset/commit/2929bb1680d29e5fd1d3b351e3e2f86971a60b44))
- **plugin-chart-echarts:** force min y-tick for log axis with zero ([#24186](https://github.com/apache/superset/issues/24186)) ([bc0079f](https://github.com/apache/superset/commit/bc0079f2fb4d09b6c3b711ef950fcb6a907c7e96))
- **plugin-chart-echarts:** gauge chart enhancements and fixes ([#21007](https://github.com/apache/superset/issues/21007)) ([b303d1e](https://github.com/apache/superset/commit/b303d1e156185d134927246004a4804931cd6bca))
- **plugin-chart-echarts:** invalid total label location for negative values in stacked bar chart ([#21032](https://github.com/apache/superset/issues/21032)) ([a8ba544](https://github.com/apache/superset/commit/a8ba544e609ad3af449239c1fb956bb18c7066c4))
- **plugin-chart-echarts:** layout broken when resizing ([#20783](https://github.com/apache/superset/issues/20783)) ([d90b973](https://github.com/apache/superset/commit/d90b97323584dbd1602cccaa0aea6ac25f466038))
- **plugin-chart-echarts:** make to allow the custome of x & y axis title margin i… ([#18947](https://github.com/apache/superset/issues/18947)) ([c79ee56](https://github.com/apache/superset/commit/c79ee568849761d9c5793ce88f5b7aba8d9e7ac9))
- **plugin-chart-echarts:** missing value format in mixed timeseries ([#21044](https://github.com/apache/superset/issues/21044)) ([2d1ba46](https://github.com/apache/superset/commit/2d1ba468441b113c574d6fcc5984e8e09ddbc1c6))
- **plugin-chart-echarts:** normalize temporal string groupbys ([#24134](https://github.com/apache/superset/issues/24134)) ([f817c10](https://github.com/apache/superset/commit/f817c10422a74edb49858150ea5dae48499d5ef7))
- **plugin-chart-echarts:** render horizontal categories from top ([#23273](https://github.com/apache/superset/issues/23273)) ([71a9d0d](https://github.com/apache/superset/commit/71a9d0d403e122a0c8115f829883151fdcd1d4f1))
- **plugin-chart-echarts:** reorder totals and support multimetric sort ([#23675](https://github.com/apache/superset/issues/23675)) ([cbbcc8d](https://github.com/apache/superset/commit/cbbcc8d2e136f949778cda56affb981c2db05880))
- **plugin-chart-echarts:** show zero value in tooltip ([#21296](https://github.com/apache/superset/issues/21296)) ([1aeb8fd](https://github.com/apache/superset/commit/1aeb8fd6b78d5b53501d277f54b46a02f7067163))
- **plugin-chart-echarts:** support adhoc x-axis ([#20055](https://github.com/apache/superset/issues/20055)) ([b53daa9](https://github.com/apache/superset/commit/b53daa91ecf0e82fe219b498e907d0c3f3ca9ccb))
- **plugin-chart-echarts:** support forced categorical x-axis ([#26404](https://github.com/apache/superset/issues/26404)) ([219c4a1](https://github.com/apache/superset/commit/219c4a14b359b77dbfcda74e66b7d06c3792b861))
- **plugin-chart-echarts:** support numerical x-axis ([#26087](https://github.com/apache/superset/issues/26087)) ([aad67e4](https://github.com/apache/superset/commit/aad67e43dbabadad9a5e4accb29ecefb39315f6e))
- **plugin-chart-echarts:** support truncated numeric x-axis ([#26215](https://github.com/apache/superset/issues/26215)) ([07e5fe8](https://github.com/apache/superset/commit/07e5fe8a66fcce6baf1974de9ff3aaab4ad30884))
- **plugin-chart-echarts:** tooltip of big number truncated at then bottom ([#20029](https://github.com/apache/superset/issues/20029)) ([35e6e27](https://github.com/apache/superset/commit/35e6e2709c9dec3d9c08280489f42b5b6a8e632e))
- **plugin-chart-echarts:** tooltip overflow bug ([#22218](https://github.com/apache/superset/issues/22218)) ([2e650ea](https://github.com/apache/superset/commit/2e650eaebebc1197549636174f4c3945c55d4d5e))
- **plugin-chart-echarts:** undefined bounds for bubble chart ([#26243](https://github.com/apache/superset/issues/26243)) ([5df544b](https://github.com/apache/superset/commit/5df544b6fb079e98d4ab6839cfbdf7f08358a950))
- **plugin-chart-echarts:** use scale for truncating x-axis ([#26269](https://github.com/apache/superset/issues/26269)) ([67468c4](https://github.com/apache/superset/commit/67468c46c0c8c8a03833dd64eb84284890b7091c))
- **plugin-chart-echarts:** use verbose x-axis name when defined ([#18217](https://github.com/apache/superset/issues/18217)) ([cec4677](https://github.com/apache/superset/commit/cec467797187324269971d870520b360c56419f3))
- **plugin-chart-echarts:** xAxis scale is not correct when setting quarter time grain ([#19686](https://github.com/apache/superset/issues/19686)) ([059cb4e](https://github.com/apache/superset/commit/059cb4ec25855b844a9c35be9b6c462595e90a5c))
- **plugin-chart-period-over-period-kpi:** Blank chart when switching from BigNumberTotal ([#27203](https://github.com/apache/superset/issues/27203)) ([5403797](https://github.com/apache/superset/commit/54037972f2f56ec86a613e6684e8bbe20cafcf50))
- **plugins:** Big Number with Time Comparison ([#29520](https://github.com/apache/superset/issues/29520)) ([b481bc9](https://github.com/apache/superset/commit/b481bc95b5d49226f1a483bb330a260f9f60c39b))
- **plugins:** Fix dashboard filter for Table and Big Number with Time Comparison ([#29517](https://github.com/apache/superset/issues/29517)) ([9052f9f](https://github.com/apache/superset/commit/9052f9fbb4a17c8dc1e951a8d1b13bf92b29c8a8))
- removing problematic "formattable" tag ([#24207](https://github.com/apache/superset/issues/24207)) ([cc68d62](https://github.com/apache/superset/commit/cc68d626bce46d1dcb8e8ee97f19919774c1ab86))
- Revert "fix(chart): Time Series set showMaxLabel as null for time xAxis ([#20627](https://github.com/apache/superset/issues/20627)) ([#24995](https://github.com/apache/superset/issues/24995)) ([2b63577](https://github.com/apache/superset/commit/2b63577046887f982a8b3a56b335f0c11288f829))
- revert [#21356](https://github.com/apache/superset/issues/21356)(able to sort bar on the bar chart V2) ([#21481](https://github.com/apache/superset/issues/21481)) ([1c0bff3](https://github.com/apache/superset/commit/1c0bff3dfb3649d219abe6a13d9018ded14f334f))
- **revert 27883:** Excess padding in horizontal Bar charts ([#29345](https://github.com/apache/superset/issues/29345)) ([708afb7](https://github.com/apache/superset/commit/708afb71462fa616209bbff9b23000880158810e))
- Small tweaks for Line and Area chart migrations (ECharts) ([#28334](https://github.com/apache/superset/issues/28334)) ([b4ab36a](https://github.com/apache/superset/commit/b4ab36a6a54d68ba0ac1356d8caaee5d1ed0e91f))
- Stacked charts with numerical columns ([#26264](https://github.com/apache/superset/issues/26264)) ([429e2a3](https://github.com/apache/superset/commit/429e2a33c3ac5a4b035e0cb113bc6e1e63a39e4c))
- Time shifts calculation for ECharts plugins ([#28432](https://github.com/apache/superset/issues/28432)) ([821c7d7](https://github.com/apache/superset/commit/821c7d7f2c430c4a4294883a66128ba98fd949c5))
- Timeseries Y-axis format with contribution mode ([#27106](https://github.com/apache/superset/issues/27106)) ([af577d6](https://github.com/apache/superset/commit/af577d64b17a9730e28e9021376318326fe31437))
- Tooltip no longer highlights hovered data series ([#24756](https://github.com/apache/superset/issues/24756)) ([ac19f58](https://github.com/apache/superset/commit/ac19f58cf6998cfd269d5a45de3b8544afd5f47c))
- Total calculation in stacked Timeseries charts ([#24477](https://github.com/apache/superset/issues/24477)) ([c5b4ecd](https://github.com/apache/superset/commit/c5b4ecdca519ab4309a47bfc8feb4a1665c6ce96))
- **treemap-v2:** color scheme not work when there is only one dimension ([#20671](https://github.com/apache/superset/issues/20671)) ([bd6037e](https://github.com/apache/superset/commit/bd6037ef50a579c9e9e3a133482670f6acb5fe5f))
- Typing of labelMap ([#21181](https://github.com/apache/superset/issues/21181)) ([1143e17](https://github.com/apache/superset/commit/1143e17742d1fa4c4cbae2c86e4998f4cc7e9f88))

### Features

- add Advanced Analytics into mixed time series chart ([#19851](https://github.com/apache/superset/issues/19851)) ([f5e9f0e](https://github.com/apache/superset/commit/f5e9f0eb3b2045a9d441f59cb3a6109892e6aea9))
- Add Bubble chart migration logic ([#26033](https://github.com/apache/superset/issues/26033)) ([68e5e1a](https://github.com/apache/superset/commit/68e5e1afea0f2c898a641988f509427cce5484df))
- Add currencies controls in control panels ([#24718](https://github.com/apache/superset/issues/24718)) ([f7e76d0](https://github.com/apache/superset/commit/f7e76d02b7cbe4940946673590bb979984ace9f5))
- add Nightingale chart support for echarts pie chart ([#28597](https://github.com/apache/superset/issues/28597)) ([f9d2451](https://github.com/apache/superset/commit/f9d2451b23e0f5b0316a61889a8d964704e888dc))
- add renameOperator ([#19776](https://github.com/apache/superset/issues/19776)) ([3c28cd4](https://github.com/apache/superset/commit/3c28cd4625fdeeaeeac3ed730907af1fb86bc86e))
- Add ValuePercent option to LABEL TYPE for Pie and Funnel charts ([#26407](https://github.com/apache/superset/issues/26407)) ([3a7d76c](https://github.com/apache/superset/commit/3a7d76cece4408c8e80862ab9db3a38eaaafdc8c))
- adding truncate metric control on timeseries charts ([#20373](https://github.com/apache/superset/issues/20373)) ([7c252d7](https://github.com/apache/superset/commit/7c252d75240559d0bba9be3be8419b65b86967df))
- adding XAxis to BigNumberTrend ([#21577](https://github.com/apache/superset/issues/21577)) ([f4646f8](https://github.com/apache/superset/commit/f4646f8edba396dba24e6ff4fbc054d073d77fd7))
- Adds a control to set the Secondary Y-axis bounds in Mixed charts ([#23917](https://github.com/apache/superset/issues/23917)) ([b4371f6](https://github.com/apache/superset/commit/b4371f68b77a98231619d0288578b49d57b21053))
- Adds drill to detail context menu for ECharts visualizations ([#20891](https://github.com/apache/superset/issues/20891)) ([3df8335](https://github.com/apache/superset/commit/3df8335f8792c85d7e2f7fefa5dd60fb2c0befaf))
- Adds drill to detail context menu to Pivot Table ([#21198](https://github.com/apache/superset/issues/21198)) ([859b6d2](https://github.com/apache/superset/commit/859b6d2d20a58f2079c43bb66645fd3b604e077e))
- Adds Histogram chart migration logic ([#28780](https://github.com/apache/superset/issues/28780)) ([df0b1cb](https://github.com/apache/superset/commit/df0b1cb8ed6720f77793036d7fb68548670b3bec))
- Adds legacy time support for Waterfall chart ([#26136](https://github.com/apache/superset/issues/26136)) ([f405ba0](https://github.com/apache/superset/commit/f405ba033e04e2694f869738163d33e1d3991297))
- Adds Sunburst chart migration logic ([#25343](https://github.com/apache/superset/issues/25343)) ([0c083bd](https://github.com/apache/superset/commit/0c083bdc1af4e6a3e17155246a3134cb5cb5887d))
- Adds the ECharts Bubble chart ([#22107](https://github.com/apache/superset/issues/22107)) ([c81c60c](https://github.com/apache/superset/commit/c81c60c91fbcb09dd63c05f050e18ee09ceebfd6))
- Adds the ECharts Heatmap chart ([#25353](https://github.com/apache/superset/issues/25353)) ([546d48a](https://github.com/apache/superset/commit/546d48adbb84b1354d6a3d4ae88dbeba0ad14d44))
- Adds the ECharts Histogram chart ([#28652](https://github.com/apache/superset/issues/28652)) ([896fe85](https://github.com/apache/superset/commit/896fe854dc3865214325cfceea94824ff41a1b6c))
- Adds the ECharts Sankey chart ([#29329](https://github.com/apache/superset/issues/29329)) ([c83d5b8](https://github.com/apache/superset/commit/c83d5b88e159413d09fb346a95201255b1b5e196))
- Adds the ECharts Sunburst chart ([#22833](https://github.com/apache/superset/issues/22833)) ([30abefb](https://github.com/apache/superset/commit/30abefb519978e2760a492de51dc0d19803edf3a))
- Adds the Featured Charts dashboard ([#28789](https://github.com/apache/superset/issues/28789)) ([95706d9](https://github.com/apache/superset/commit/95706d9be2b5414ed496ad762ba1996041429e01))
- **advanced analysis:** support MultiIndex column in post processing stage ([#19116](https://github.com/apache/superset/issues/19116)) ([375c03e](https://github.com/apache/superset/commit/375c03e08407570bcf417acf5f3d25b28843329c))
- apply Time Grain to X-Axis column ([#21163](https://github.com/apache/superset/issues/21163)) ([ce3d38d](https://github.com/apache/superset/commit/ce3d38d2e72a56014fa96ee3d4afe066277cc5be))
- Axis sort in the Bar Chart V2 ([#21993](https://github.com/apache/superset/issues/21993)) ([22fab5e](https://github.com/apache/superset/commit/22fab5e58ce574e962518067d982e3036449e580))
- **bar_chart:** Stacked Bar chart with Time comparison in separated stacks ([#27589](https://github.com/apache/superset/issues/27589)) ([8a715cc](https://github.com/apache/superset/commit/8a715cc1b5fd687acda48443f18c93358e4a92e0))
- **chart & legend:** make to enable show legend by default ([#19927](https://github.com/apache/superset/issues/19927)) ([7b3d0f0](https://github.com/apache/superset/commit/7b3d0f040b050905f7d0901d0227f1cd6b761b56))
- conditional coloring for big number chart ([#23064](https://github.com/apache/superset/issues/23064)) ([61d8a0b](https://github.com/apache/superset/commit/61d8a0bd1206ffc96ea2f9284e4c238241fcca79))
- **dashboard:** Add cross filter from context menu ([#23141](https://github.com/apache/superset/issues/23141)) ([ee1952e](https://github.com/apache/superset/commit/ee1952e488f2cd0913fe6f35ffe551d18ee3d143))
- **dashboard:** menu improvements, fallback support for Drill to Detail ([#21351](https://github.com/apache/superset/issues/21351)) ([76e57ec](https://github.com/apache/superset/commit/76e57ec651bbfaf4f76031eeeca66f6a1fa81bc2))
- Data Zoom scrolls using the mouse (mark II) ([#28629](https://github.com/apache/superset/issues/28629)) ([ac53f7f](https://github.com/apache/superset/commit/ac53f7fea9d820fbc651be7d8e31d054d09f0787))
- derived metrics use different line style ([#20242](https://github.com/apache/superset/issues/20242)) ([7faf874](https://github.com/apache/superset/commit/7faf874c1b9613258606fb10f5800a185c30c81e))
- **echarts-funnel:** Implement % calculation type ([#26290](https://github.com/apache/superset/issues/26290)) ([5400d30](https://github.com/apache/superset/commit/5400d30b201d5ba987dfda8ade1a157580d9cc7c))
- **echarts-pie:** add string template support for labels ([#28774](https://github.com/apache/superset/issues/28774)) ([a067ffb](https://github.com/apache/superset/commit/a067ffb92d7f3d80bbcf8213d15a8c269c5f263b))
- **echarts:** Add x axis sort by to all series charts ([#23450](https://github.com/apache/superset/issues/23450)) ([8ecf0b1](https://github.com/apache/superset/commit/8ecf0b1c2009c86e56ba7930842f985c5f7f984a))
- **echarts:** Implement stream graph for Echarts Timeseries ([#23410](https://github.com/apache/superset/issues/23410)) ([b0d83e8](https://github.com/apache/superset/commit/b0d83e8c5086014492f1d11ca19c7c6871b102c7))
- Enable cross fitlers in WorldMap and Graph charts ([#22886](https://github.com/apache/superset/issues/22886)) ([871cab8](https://github.com/apache/superset/commit/871cab8cbe20971efd9b81f647ed537ad4fbe12b))
- Enables ECharts legend selector ([#23590](https://github.com/apache/superset/issues/23590)) ([30f210b](https://github.com/apache/superset/commit/30f210b84242051fe2f3d812ad8f5a10a0bed1b5))
- explicit distribute columns on BoxPlot and apply time grain ([#21593](https://github.com/apache/superset/issues/21593)) ([93f08e7](https://github.com/apache/superset/commit/93f08e778bfd48be150749f22d0b184467da73ac))
- **explore:** Denormalize form data in echarts, world map and nvd3 bar and line charts ([#20313](https://github.com/apache/superset/issues/20313)) ([354a899](https://github.com/apache/superset/commit/354a89950c4d001da3e107f60788cea873bd6bf6))
- **explore:** improve UI in the control panel ([#19748](https://github.com/apache/superset/issues/19748)) ([e3a54aa](https://github.com/apache/superset/commit/e3a54aa3c15bdd0c970aa73f898288a408205c97))
- format timestamps in drill by breadcrumbs ([#23698](https://github.com/apache/superset/issues/23698)) ([0bf8907](https://github.com/apache/superset/commit/0bf8907f2f6d7a17a1e3efa1c03a5af06daa8190))
- **formatters:** Add custom d3-time-format locale ([#24263](https://github.com/apache/superset/issues/24263)) ([024cfd8](https://github.com/apache/superset/commit/024cfd86e408ec5f7ddf49a9e90908e2fb2e6b70))
- Funnel/tooltip-customization ([#25666](https://github.com/apache/superset/issues/25666)) ([dfff3c1](https://github.com/apache/superset/commit/dfff3c1cbaccc416315aa09efd9b32430f473ef0))
- generate consistent QueryObject whether GenericAxis is enabled or disabled ([#21519](https://github.com/apache/superset/issues/21519)) ([4d12e37](https://github.com/apache/superset/commit/4d12e3709eb7ab1cc4f687c15ed54a4738266482))
- **generic-x-axis:** add x sorting on series limit metric ([#23274](https://github.com/apache/superset/issues/23274)) ([1b139d0](https://github.com/apache/superset/commit/1b139d074852e13c113a408a920991b2abc98387))
- Implement context menu for drill by ([#23454](https://github.com/apache/superset/issues/23454)) ([9fbfd1c](https://github.com/apache/superset/commit/9fbfd1c1d883f983ef96b8812297721e2a1a9695))
- Implement currencies formatter for saved metrics ([#24517](https://github.com/apache/superset/issues/24517)) ([83ff4cd](https://github.com/apache/superset/commit/83ff4cd86a4931fc8eda83aeb3d8d3c92d773202))
- Implement support for currencies in more charts ([#24594](https://github.com/apache/superset/issues/24594)) ([d74d7ec](https://github.com/apache/superset/commit/d74d7eca23a3c94bc48af082c115d34c103e815d))
- improve color consistency (save all labels) ([#19038](https://github.com/apache/superset/issues/19038)) ([dc57508](https://github.com/apache/superset/commit/dc575080d7e43d40b1734bb8f44fdc291cb95b11))
- Improves the Waterfall chart ([#25557](https://github.com/apache/superset/issues/25557)) ([d619078](https://github.com/apache/superset/commit/d619078d25dde63c55e9afd87e98f05d4fb82b86))
- Make time shifted series colors match the original series ([#24048](https://github.com/apache/superset/issues/24048)) ([df4d16a](https://github.com/apache/superset/commit/df4d16a7eec3ba06bf1d5e9f016cb0d86b9693e5))
- Move cross filters to Dashboard ([#22785](https://github.com/apache/superset/issues/22785)) ([9ed2326](https://github.com/apache/superset/commit/9ed2326a20329d41abc8e0995b0ba6110379088f))
- **plugin-chart-echarts:** [feature-parity] support extra control for the area chart V2 ([#16493](https://github.com/apache/superset/issues/16493)) ([eab0009](https://github.com/apache/superset/commit/eab0009101a295acf4d8d31df8a57f8fe0deb517))
- **plugin-chart-echarts:** able to sort bar on the bar chart V2 ([#21356](https://github.com/apache/superset/issues/21356)) ([59437ea](https://github.com/apache/superset/commit/59437ea6e7ec02267c6e03e174be39a6cae48893))
- **plugin-chart-echarts:** add aggregate total for the Pie/Donuct chart ([#19622](https://github.com/apache/superset/issues/19622)) ([a6bf041](https://github.com/apache/superset/commit/a6bf041eddcde0247461f35c806414df00ef105e))
- **plugin-chart-echarts:** add series sorting ([#23392](https://github.com/apache/superset/issues/23392)) ([0c454c6](https://github.com/apache/superset/commit/0c454c64426376d7fb209a8b16d15c580be811f4))
- **plugin-chart-echarts:** add support for generic axis to mixed chart ([#20097](https://github.com/apache/superset/issues/20097)) ([d5c5e58](https://github.com/apache/superset/commit/d5c5e58583771a35d8870ce3694b2a3f1b688159))
- **plugin-chart-echarts:** add x-axis sort to multi series ([#23644](https://github.com/apache/superset/issues/23644)) ([f49702f](https://github.com/apache/superset/commit/f49702feffb3b08476c22916e185c0ce2c64e7f1))
- **plugin-chart-echarts:** Echarts Waterfall ([#17906](https://github.com/apache/superset/issues/17906)) ([17792a5](https://github.com/apache/superset/commit/17792a507c7245c9e09c6eb98a774f2ef4ec8568))
- **plugin-chart-echarts:** support horizontal bar chart ([#19918](https://github.com/apache/superset/issues/19918)) ([9854d2d](https://github.com/apache/superset/commit/9854d2d0e8f849366b264353819c6fdf4b0d804d))
- **plugin-chart-echarts:** support non-timeseries x-axis ([#17917](https://github.com/apache/superset/issues/17917)) ([e9651ea](https://github.com/apache/superset/commit/e9651ea52fdc0edb574bfb9dc1b22c225bcc068f)), closes [#18021](https://github.com/apache/superset/issues/18021) [#18039](https://github.com/apache/superset/issues/18039) [#17569](https://github.com/apache/superset/issues/17569) [#18037](https://github.com/apache/superset/issues/18037)
- **plugin-chart-echarts:** Support stacking negative and positive values ([#20408](https://github.com/apache/superset/issues/20408)) ([c959d92](https://github.com/apache/superset/commit/c959d92dd17499e3fb7a0f4f02f3781516f3d3e6))
- **plugin-chart-echarts:** supports sunburst chart v2 [WIP] ([#21625](https://github.com/apache/superset/issues/21625)) ([b53941f](https://github.com/apache/superset/commit/b53941fb3eef7ab3936a0a3f16e22c921d946f53))
- **plugins:** add color options for big number with time comparison ([#27524](https://github.com/apache/superset/issues/27524)) ([ae29427](https://github.com/apache/superset/commit/ae294274c7da58826a309ab06356d097e98fbe0a))
- Responsive UI for Big Number with Time Comparison ([#27375](https://github.com/apache/superset/issues/27375)) ([5de2530](https://github.com/apache/superset/commit/5de2530e3cdc5799d08cfbad5871d24762a47ce4))
- setting limit value when Pie chart switches ([#20392](https://github.com/apache/superset/issues/20392)) ([0a50a9b](https://github.com/apache/superset/commit/0a50a9b3804837ea7130f91bfcfcca57ab50129f))
- **standardized form data:** keep all columns and metrics ([#20377](https://github.com/apache/superset/issues/20377)) ([bbbe102](https://github.com/apache/superset/commit/bbbe102887a524b1ee0ffd4ada8481078dbe5496))
- standardized form_data ([#20010](https://github.com/apache/superset/issues/20010)) ([dd4b581](https://github.com/apache/superset/commit/dd4b581fb55d920fc3b709fc044cea5339802ee2))
- **storybook:** Co-habitating/Upgrading Storybooks to v7 (dependency madness ensues) ([#26907](https://github.com/apache/superset/issues/26907)) ([753ef69](https://github.com/apache/superset/commit/753ef695294ce26238b68ff41ba0a9af6aea74de))
- **table:** Table with Time Comparison ([#28057](https://github.com/apache/superset/issues/28057)) ([7ddea62](https://github.com/apache/superset/commit/7ddea62331617dad1b8ade1abe7dd8c11a1ba20d))
- **time_comparison:** Support all date formats when computing custom and inherit offsets ([#30002](https://github.com/apache/superset/issues/30002)) ([bc6d2db](https://github.com/apache/superset/commit/bc6d2dba373e59a498d942909ab6631e5c8521e9))
- **timeseries-chart:** add percentage threshold input control ([#17758](https://github.com/apache/superset/issues/17758)) ([6bd4dd2](https://github.com/apache/superset/commit/6bd4dd257a6089a093bae3f251cf9f0976d353e6))
- Utility function to render chart tooltips ([#27950](https://github.com/apache/superset/issues/27950)) ([b549977](https://github.com/apache/superset/commit/b549977f0538d6939dce756c7615052e5f2e6c93))
- **viz picker:** Remove some tags, refactor Recommended section ([#27708](https://github.com/apache/superset/issues/27708)) ([c314999](https://github.com/apache/superset/commit/c3149994ac0d4392e0462421b62cd0c034142082))

### Performance Improvements

- Implement Echarts treeshaking ([#29874](https://github.com/apache/superset/issues/29874)) ([c220245](https://github.com/apache/superset/commit/c2202454147936d1770137eaac334719b8e746e2))

### Reverts

- Revert "feat(plugin-chart-echarts): Support stacking negative and positive values (#20408)" (#20571) ([f5f8dde](https://github.com/apache/superset/commit/f5f8ddec3e5c947896521003295e1acd93851674)), closes [#20408](https://github.com/apache/superset/issues/20408) [#20571](https://github.com/apache/superset/issues/20571)

# [0.19.0](https://github.com/apache/superset/compare/v2021.41.0...v0.19.0) (2024-09-07)

### Bug Fixes

- adjust timeseries grid right offset to match the rest ([#20933](https://github.com/apache/superset/issues/20933)) ([fe581a3](https://github.com/apache/superset/commit/fe581a36404ec1cfe689995b61a43164cb1988df))
- Allow comma in Number Format ([#21817](https://github.com/apache/superset/issues/21817)) ([383dc29](https://github.com/apache/superset/commit/383dc29ad1fb921ee618ed80b847316d77247886))
- Allow only dttm columns in comparison filter in Period over Period chart ([#27209](https://github.com/apache/superset/issues/27209)) ([a4c771e](https://github.com/apache/superset/commit/a4c771e013957e95d80d252dcdedad7046348964))
- annotation broken ([#20651](https://github.com/apache/superset/issues/20651)) ([7f918a4](https://github.com/apache/superset/commit/7f918a4ec0e162be13bf3fc0e2f15aaaa5450cec))
- **annotation:** Address regression from [#24694](https://github.com/apache/superset/issues/24694) ([#24874](https://github.com/apache/superset/issues/24874)) ([f05638b](https://github.com/apache/superset/commit/f05638ba845596faef088efa3ee98686d26dad26))
- Bar charts horizontal margin adjustment error ([#26817](https://github.com/apache/superset/issues/26817)) ([84c48d1](https://github.com/apache/superset/commit/84c48d11d8b3bef244823643804f5fd3d6e3ca86))
- **bar-chart-v2:** remove marker from bar chart V2 ([#20409](https://github.com/apache/superset/issues/20409)) ([b32288f](https://github.com/apache/superset/commit/b32288fddfc077d941452245a4e8002335746ba4))
- **bar-chart:** change legend padding for horizontal orientation ([#27883](https://github.com/apache/superset/issues/27883)) ([cfa0556](https://github.com/apache/superset/commit/cfa0556df7a6d82257deff7753b82628229c6e8c))
- big number with trendline can't calculate cumsum ([#19542](https://github.com/apache/superset/issues/19542)) ([2daa071](https://github.com/apache/superset/commit/2daa07163326b8555488dab523c5479cf92821cf))
- **big number:** time grain control is useless in BigNumber Viz ([#21372](https://github.com/apache/superset/issues/21372)) ([b80f659](https://github.com/apache/superset/commit/b80f6591018858b709194687fe7ea3d244131761))
- **big_number:** white-space: nowrap to prevent wrapping ([#27096](https://github.com/apache/superset/issues/27096)) ([4796484](https://github.com/apache/superset/commit/4796484190010275c037595c79b01d281d09ff60))
- **big-number-chart:** number format is not applying to percentage number of the time comparison ([#27502](https://github.com/apache/superset/issues/27502)) ([d2c9001](https://github.com/apache/superset/commit/d2c90013fcff8b8ff965f2c4420f458ab3ccda10))
- **big-number:** big number gets cut off on a Dashboard ([#20488](https://github.com/apache/superset/issues/20488)) ([24a53c3](https://github.com/apache/superset/commit/24a53c38c68108c47af9f7685542fcb8378915bf))
- **big-number:** Big Number with Trendline Chart is not working if Time Grain is set to Month ([#19043](https://github.com/apache/superset/issues/19043)) ([c32eaf4](https://github.com/apache/superset/commit/c32eaf47e50f5fc0cb7630cbf38819cd03b5294b))
- categorical x-axis can't apply the label of column ([#21869](https://github.com/apache/superset/issues/21869)) ([9aa804e](https://github.com/apache/superset/commit/9aa804e070d9361df5e7dcde326ef16a769ac322))
- **chart & gallery:** make to add mixed time-series into recommended charts ([#20064](https://github.com/apache/superset/issues/20064)) ([f43dbc0](https://github.com/apache/superset/commit/f43dbc0dfdbd9ee21267229b566dfab8f59cd0db))
- chart empty state & result panel when multiple queries are executed display incorrectly ([#20816](https://github.com/apache/superset/issues/20816)) ([279ab95](https://github.com/apache/superset/commit/279ab954b1977f7729442733a31c67715476a620))
- **charts:** big-number display broken in echarts ([#24492](https://github.com/apache/superset/issues/24492)) ([3f17945](https://github.com/apache/superset/commit/3f179457457bc2a21a824895aa1cd99b586d9ea0))
- **charts:** Hide Values greater than Max Y Axis Bound on Mixed Time Series with Bar series ([#21015](https://github.com/apache/superset/issues/21015)) ([bdcc0a9](https://github.com/apache/superset/commit/bdcc0a9bcfff476bcd43edc84f08423d8f415d50))
- **charts:** Time grain is None when dataset uses Jinja ([#25842](https://github.com/apache/superset/issues/25842)) ([7536dd1](https://github.com/apache/superset/commit/7536dd12cdd58a1bca7d72952a2b74641f16c959))
- **chart:** Time Series set showMaxLabel as null for time xAxis ([#20627](https://github.com/apache/superset/issues/20627)) ([9362e27](https://github.com/apache/superset/commit/9362e27ce2ace1803a975ab289fe2024fd195367))
- CI errors as the result of removing React imports ([#29089](https://github.com/apache/superset/issues/29089)) ([a9cebe8](https://github.com/apache/superset/commit/a9cebe81ea8cd1ae56df05d5807baa8f05398cc5))
- Context menu crashing when there is no dimension in Echarts Series charts ([#23797](https://github.com/apache/superset/issues/23797)) ([d4c0ae3](https://github.com/apache/superset/commit/d4c0ae34f4e23d1172d2ae3335f73873b0b37c1e))
- contribution operator meets nan value ([#18782](https://github.com/apache/superset/issues/18782)) ([987740a](https://github.com/apache/superset/commit/987740aa8dfff4bf771b587a40f1e12811453660))
- Contribution percentages for ECharts plugins ([#28368](https://github.com/apache/superset/issues/28368)) ([55f3b46](https://github.com/apache/superset/commit/55f3b46f4105e5bbdd0b025a4b61bc843d8e5b9e))
- custom SQL in the XAxis ([#21847](https://github.com/apache/superset/issues/21847)) ([0a4ecca](https://github.com/apache/superset/commit/0a4ecca9f259e2ee9cff27a879f2a889f876c7d7))
- **Dashboard:** Color inconsistency on refreshes and conflicts ([#27439](https://github.com/apache/superset/issues/27439)) ([313ee59](https://github.com/apache/superset/commit/313ee596f5435894f857d72be7269d5070c8c964))
- **dashboard:** Cross filters with time shifted series ([#23347](https://github.com/apache/superset/issues/23347)) ([78ee60e](https://github.com/apache/superset/commit/78ee60e22788395d5b1989e0cd92136725dd5cf0))
- Data zoom with horizontal orientation ([#27291](https://github.com/apache/superset/issues/27291)) ([7854b62](https://github.com/apache/superset/commit/7854b622a34c9a9674e2c916acb8acbc63714fb8))
- **dependencies:** stopping (and preventing) full lodash library import... now using only method level imports. ([#26710](https://github.com/apache/superset/issues/26710)) ([1d4b8b6](https://github.com/apache/superset/commit/1d4b8b69896776cf8831b8202e69424e14067011))
- Don't apply number formatting to the label in Treemap ([#25249](https://github.com/apache/superset/issues/25249)) ([894f250](https://github.com/apache/superset/commit/894f250229455427a0317f3a2f6aa801a6c26748))
- Drill to detail blocked by tooltip ([#22082](https://github.com/apache/superset/issues/22082)) ([3bc0865](https://github.com/apache/superset/commit/3bc0865d9071cdf32d268ee8fee4c4ad93680429))
- Drill to detail on values with comma ([#21151](https://github.com/apache/superset/issues/21151)) ([0bf4e56](https://github.com/apache/superset/commit/0bf4e56dc3e129d2b9239f055212249ba95521e4))
- drilling on the categorical xaxis on the mixed chart ([#21845](https://github.com/apache/superset/issues/21845)) ([f381154](https://github.com/apache/superset/commit/f38115489b09cb22bb77427bf73462784650cbaa))
- drilling on the categorical xaxis on the stacked barchart v2 ([#21844](https://github.com/apache/superset/issues/21844)) ([f41d0b0](https://github.com/apache/superset/commit/f41d0b0cbf47042bf510dc2b0b24b68e3fa11d37))
- duplicate `truncateXAxis` option in `BarChart` ([#29916](https://github.com/apache/superset/issues/29916)) ([e886cc4](https://github.com/apache/superset/commit/e886cc40fe30e97da545482fe48e63c1d15e7c4e))
- Ensure metrics is an array in Mixed Chart ([#24643](https://github.com/apache/superset/issues/24643)) ([fe2c14f](https://github.com/apache/superset/commit/fe2c14ff3acad11bf0f6a7b6544dfc52a6612152))
- **Explore:** Force different color for same metrics in Mixed Time-Series ([#18603](https://github.com/apache/superset/issues/18603)) ([f565230](https://github.com/apache/superset/commit/f565230d8d8342f7a51b263d2a0865122c8f756e))
- **explore:** make SORT-Descending visible if Sort-by has value ([#17726](https://github.com/apache/superset/issues/17726)) ([d5768ab](https://github.com/apache/superset/commit/d5768ab649a70fd4f541ad4982498f622160b220))
- **explore:** Pie chart label formatting when series is temporal ([#18216](https://github.com/apache/superset/issues/18216)) ([37430d4](https://github.com/apache/superset/commit/37430d404436b3d3833bfd9cbae602718c26c4a8))
- **explore:** Prevent shared controls from checking feature flags outside React render ([#21315](https://github.com/apache/superset/issues/21315)) ([2285ebe](https://github.com/apache/superset/commit/2285ebe72ec4edded6d195052740b7f9f13d1f1b))
- **explore:** Time column label not formatted when GENERIC_X_AXES enabled ([#21294](https://github.com/apache/superset/issues/21294)) ([c3a00d4](https://github.com/apache/superset/commit/c3a00d43d055224d4a31ea9315934a59b556eea7))
- **explore:** Time comparison in Mixed Chart in GENERIC_CHART_AXES not working ([#22945](https://github.com/apache/superset/issues/22945)) ([ed7b353](https://github.com/apache/superset/commit/ed7b3533bcc119b2240a613ebc56ace33f1e1002))
- **Gauge echart:** displaying column label ([#23396](https://github.com/apache/superset/issues/23396)) ([b613167](https://github.com/apache/superset/commit/b613167636aae82170b24f697d79fcd70ef1ac56))
- **generic-axes:** apply contribution before flatten ([#20077](https://github.com/apache/superset/issues/20077)) ([d5802f7](https://github.com/apache/superset/commit/d5802f78964a5027184ff9e7f6b78c14b04fd988))
- **generic-chart-axes:** set x-axis if unset and ff is enabled ([#20107](https://github.com/apache/superset/issues/20107)) ([0b3d3dd](https://github.com/apache/superset/commit/0b3d3dd4caa7f4c31c1ba7229966a40ba0469e85))
- Includes 90° x-axis label rotation ([#26207](https://github.com/apache/superset/issues/26207)) ([39c6488](https://github.com/apache/superset/commit/39c6488463ab81417223a2e1b171c769b86306cf))
- **line-chart:** Formula Annotations on Line Charts are broken ([#20687](https://github.com/apache/superset/issues/20687)) ([acdb271](https://github.com/apache/superset/commit/acdb271422b937314d7175ac85eeeac5ead3bc16))
- lost renameOperator in mixed timeseries chart ([#19802](https://github.com/apache/superset/issues/19802)) ([108a2a4](https://github.com/apache/superset/commit/108a2a4eafc3150f7b7c33ed734e843a5d5c9f62))
- Migration for single metric in Big Number with Time Comparison ([#27351](https://github.com/apache/superset/issues/27351)) ([ad6327d](https://github.com/apache/superset/commit/ad6327db95ba8628e9890e2b2813ae088178d9c1))
- missing shared color in mixed timeseries ([#27403](https://github.com/apache/superset/issues/27403)) ([9ced255](https://github.com/apache/superset/commit/9ced2552dbeeaf60217b385d4c40cbaf4372c787))
- **Mixed Timeseries Chart:** Custom Metric Label ([#17649](https://github.com/apache/superset/issues/17649)) ([89d0d38](https://github.com/apache/superset/commit/89d0d38ed0eb211d44de8067bd091392a0f84f85))
- **mixed-timeseries-plugin:** Second query stacks stacked on top of first query series ([#29119](https://github.com/apache/superset/issues/29119)) ([68fd189](https://github.com/apache/superset/commit/68fd1895865a7c7fefe368db05f6fb22c8f1c048))
- New tooltip inappropriately combines series on mixed chart ([#30137](https://github.com/apache/superset/issues/30137)) ([9cb9e5b](https://github.com/apache/superset/commit/9cb9e5beee0ffda72fec7cffaf5930f3ca2b40ff))
- Null values on Treemap right-click ([#21722](https://github.com/apache/superset/issues/21722)) ([0ff1e49](https://github.com/apache/superset/commit/0ff1e49e3c720ed229f6a08daaa70bf14a053dca))
- pie chart orientation description error ([#21514](https://github.com/apache/superset/issues/21514)) ([c66205f](https://github.com/apache/superset/commit/c66205feac118a444e30cd6b6cb48d2c2e3d6411))
- Pivot Table Conditional Formatting Doesn't Show All Options ([#19071](https://github.com/apache/superset/issues/19071)) ([0e0bece](https://github.com/apache/superset/commit/0e0beceac173f765d8f9a0887732029b78603f6d))
- **plugin-chart-echarts:** [feature parity] annotation line chart color not working ([#19758](https://github.com/apache/superset/issues/19758)) ([1156297](https://github.com/apache/superset/commit/11562971fb95a601d11b2902f1704b72409f302d))
- **plugin-chart-echarts:** [feature-parity] apply button of annotation layer doesn't work as expected ([#19761](https://github.com/apache/superset/issues/19761)) ([9f02ff6](https://github.com/apache/superset/commit/9f02ff656d63e537c06822657dcfc2ff46f70e67))
- **plugin-chart-echarts:** bar chart overflow ([#20805](https://github.com/apache/superset/issues/20805)) ([9bf7ed5](https://github.com/apache/superset/commit/9bf7ed58cdc1d5523d0cb661f8fdbf7df9b10fe7))
- **plugin-chart-echarts:** boxplot throw error in the dashboard ([#21661](https://github.com/apache/superset/issues/21661)) ([61bd696](https://github.com/apache/superset/commit/61bd6962265d879e168f208854fc17b145b9e04d))
- **plugin-chart-echarts:** calculate Gauge Chart intervals correctly when min value is set ([#27285](https://github.com/apache/superset/issues/27285)) ([d65f64d](https://github.com/apache/superset/commit/d65f64d1ceacb69226fa1907343405b5571bc6a8))
- **plugin-chart-echarts:** fix customize margin ([#18958](https://github.com/apache/superset/issues/18958)) ([c4e3c45](https://github.com/apache/superset/commit/c4e3c45b3c24034205a1ceeb5387d63dc666a7fe))
- **plugin-chart-echarts:** fix forecasts on verbose metrics ([#18252](https://github.com/apache/superset/issues/18252)) ([2929bb1](https://github.com/apache/superset/commit/2929bb1680d29e5fd1d3b351e3e2f86971a60b44))
- **plugin-chart-echarts:** force min y-tick for log axis with zero ([#24186](https://github.com/apache/superset/issues/24186)) ([bc0079f](https://github.com/apache/superset/commit/bc0079f2fb4d09b6c3b711ef950fcb6a907c7e96))
- **plugin-chart-echarts:** gauge chart enhancements and fixes ([#21007](https://github.com/apache/superset/issues/21007)) ([b303d1e](https://github.com/apache/superset/commit/b303d1e156185d134927246004a4804931cd6bca))
- **plugin-chart-echarts:** invalid total label location for negative values in stacked bar chart ([#21032](https://github.com/apache/superset/issues/21032)) ([a8ba544](https://github.com/apache/superset/commit/a8ba544e609ad3af449239c1fb956bb18c7066c4))
- **plugin-chart-echarts:** layout broken when resizing ([#20783](https://github.com/apache/superset/issues/20783)) ([d90b973](https://github.com/apache/superset/commit/d90b97323584dbd1602cccaa0aea6ac25f466038))
- **plugin-chart-echarts:** make to allow the custome of x & y axis title margin i… ([#18947](https://github.com/apache/superset/issues/18947)) ([c79ee56](https://github.com/apache/superset/commit/c79ee568849761d9c5793ce88f5b7aba8d9e7ac9))
- **plugin-chart-echarts:** missing value format in mixed timeseries ([#21044](https://github.com/apache/superset/issues/21044)) ([2d1ba46](https://github.com/apache/superset/commit/2d1ba468441b113c574d6fcc5984e8e09ddbc1c6))
- **plugin-chart-echarts:** normalize temporal string groupbys ([#24134](https://github.com/apache/superset/issues/24134)) ([f817c10](https://github.com/apache/superset/commit/f817c10422a74edb49858150ea5dae48499d5ef7))
- **plugin-chart-echarts:** render horizontal categories from top ([#23273](https://github.com/apache/superset/issues/23273)) ([71a9d0d](https://github.com/apache/superset/commit/71a9d0d403e122a0c8115f829883151fdcd1d4f1))
- **plugin-chart-echarts:** reorder totals and support multimetric sort ([#23675](https://github.com/apache/superset/issues/23675)) ([cbbcc8d](https://github.com/apache/superset/commit/cbbcc8d2e136f949778cda56affb981c2db05880))
- **plugin-chart-echarts:** show zero value in tooltip ([#21296](https://github.com/apache/superset/issues/21296)) ([1aeb8fd](https://github.com/apache/superset/commit/1aeb8fd6b78d5b53501d277f54b46a02f7067163))
- **plugin-chart-echarts:** support adhoc x-axis ([#20055](https://github.com/apache/superset/issues/20055)) ([b53daa9](https://github.com/apache/superset/commit/b53daa91ecf0e82fe219b498e907d0c3f3ca9ccb))
- **plugin-chart-echarts:** support forced categorical x-axis ([#26404](https://github.com/apache/superset/issues/26404)) ([219c4a1](https://github.com/apache/superset/commit/219c4a14b359b77dbfcda74e66b7d06c3792b861))
- **plugin-chart-echarts:** support numerical x-axis ([#26087](https://github.com/apache/superset/issues/26087)) ([aad67e4](https://github.com/apache/superset/commit/aad67e43dbabadad9a5e4accb29ecefb39315f6e))
- **plugin-chart-echarts:** support truncated numeric x-axis ([#26215](https://github.com/apache/superset/issues/26215)) ([07e5fe8](https://github.com/apache/superset/commit/07e5fe8a66fcce6baf1974de9ff3aaab4ad30884))
- **plugin-chart-echarts:** tooltip of big number truncated at then bottom ([#20029](https://github.com/apache/superset/issues/20029)) ([35e6e27](https://github.com/apache/superset/commit/35e6e2709c9dec3d9c08280489f42b5b6a8e632e))
- **plugin-chart-echarts:** tooltip overflow bug ([#22218](https://github.com/apache/superset/issues/22218)) ([2e650ea](https://github.com/apache/superset/commit/2e650eaebebc1197549636174f4c3945c55d4d5e))
- **plugin-chart-echarts:** undefined bounds for bubble chart ([#26243](https://github.com/apache/superset/issues/26243)) ([5df544b](https://github.com/apache/superset/commit/5df544b6fb079e98d4ab6839cfbdf7f08358a950))
- **plugin-chart-echarts:** use scale for truncating x-axis ([#26269](https://github.com/apache/superset/issues/26269)) ([67468c4](https://github.com/apache/superset/commit/67468c46c0c8c8a03833dd64eb84284890b7091c))
- **plugin-chart-echarts:** use verbose x-axis name when defined ([#18217](https://github.com/apache/superset/issues/18217)) ([cec4677](https://github.com/apache/superset/commit/cec467797187324269971d870520b360c56419f3))
- **plugin-chart-echarts:** xAxis scale is not correct when setting quarter time grain ([#19686](https://github.com/apache/superset/issues/19686)) ([059cb4e](https://github.com/apache/superset/commit/059cb4ec25855b844a9c35be9b6c462595e90a5c))
- **plugin-chart-period-over-period-kpi:** Blank chart when switching from BigNumberTotal ([#27203](https://github.com/apache/superset/issues/27203)) ([5403797](https://github.com/apache/superset/commit/54037972f2f56ec86a613e6684e8bbe20cafcf50))
- **plugins:** Big Number with Time Comparison ([#29520](https://github.com/apache/superset/issues/29520)) ([b481bc9](https://github.com/apache/superset/commit/b481bc95b5d49226f1a483bb330a260f9f60c39b))
- **plugins:** Fix dashboard filter for Table and Big Number with Time Comparison ([#29517](https://github.com/apache/superset/issues/29517)) ([9052f9f](https://github.com/apache/superset/commit/9052f9fbb4a17c8dc1e951a8d1b13bf92b29c8a8))
- removing problematic "formattable" tag ([#24207](https://github.com/apache/superset/issues/24207)) ([cc68d62](https://github.com/apache/superset/commit/cc68d626bce46d1dcb8e8ee97f19919774c1ab86))
- Revert "fix(chart): Time Series set showMaxLabel as null for time xAxis ([#20627](https://github.com/apache/superset/issues/20627)) ([#24995](https://github.com/apache/superset/issues/24995)) ([2b63577](https://github.com/apache/superset/commit/2b63577046887f982a8b3a56b335f0c11288f829))
- revert [#21356](https://github.com/apache/superset/issues/21356)(able to sort bar on the bar chart V2) ([#21481](https://github.com/apache/superset/issues/21481)) ([1c0bff3](https://github.com/apache/superset/commit/1c0bff3dfb3649d219abe6a13d9018ded14f334f))
- **revert 27883:** Excess padding in horizontal Bar charts ([#29345](https://github.com/apache/superset/issues/29345)) ([708afb7](https://github.com/apache/superset/commit/708afb71462fa616209bbff9b23000880158810e))
- Small tweaks for Line and Area chart migrations (ECharts) ([#28334](https://github.com/apache/superset/issues/28334)) ([b4ab36a](https://github.com/apache/superset/commit/b4ab36a6a54d68ba0ac1356d8caaee5d1ed0e91f))
- Stacked charts with numerical columns ([#26264](https://github.com/apache/superset/issues/26264)) ([429e2a3](https://github.com/apache/superset/commit/429e2a33c3ac5a4b035e0cb113bc6e1e63a39e4c))
- Time shifts calculation for ECharts plugins ([#28432](https://github.com/apache/superset/issues/28432)) ([821c7d7](https://github.com/apache/superset/commit/821c7d7f2c430c4a4294883a66128ba98fd949c5))
- Timeseries Y-axis format with contribution mode ([#27106](https://github.com/apache/superset/issues/27106)) ([af577d6](https://github.com/apache/superset/commit/af577d64b17a9730e28e9021376318326fe31437))
- Tooltip no longer highlights hovered data series ([#24756](https://github.com/apache/superset/issues/24756)) ([ac19f58](https://github.com/apache/superset/commit/ac19f58cf6998cfd269d5a45de3b8544afd5f47c))
- Total calculation in stacked Timeseries charts ([#24477](https://github.com/apache/superset/issues/24477)) ([c5b4ecd](https://github.com/apache/superset/commit/c5b4ecdca519ab4309a47bfc8feb4a1665c6ce96))
- **treemap-v2:** color scheme not work when there is only one dimension ([#20671](https://github.com/apache/superset/issues/20671)) ([bd6037e](https://github.com/apache/superset/commit/bd6037ef50a579c9e9e3a133482670f6acb5fe5f))
- Typing of labelMap ([#21181](https://github.com/apache/superset/issues/21181)) ([1143e17](https://github.com/apache/superset/commit/1143e17742d1fa4c4cbae2c86e4998f4cc7e9f88))

### Features

- add Advanced Analytics into mixed time series chart ([#19851](https://github.com/apache/superset/issues/19851)) ([f5e9f0e](https://github.com/apache/superset/commit/f5e9f0eb3b2045a9d441f59cb3a6109892e6aea9))
- Add Bubble chart migration logic ([#26033](https://github.com/apache/superset/issues/26033)) ([68e5e1a](https://github.com/apache/superset/commit/68e5e1afea0f2c898a641988f509427cce5484df))
- Add currencies controls in control panels ([#24718](https://github.com/apache/superset/issues/24718)) ([f7e76d0](https://github.com/apache/superset/commit/f7e76d02b7cbe4940946673590bb979984ace9f5))
- add Nightingale chart support for echarts pie chart ([#28597](https://github.com/apache/superset/issues/28597)) ([f9d2451](https://github.com/apache/superset/commit/f9d2451b23e0f5b0316a61889a8d964704e888dc))
- add renameOperator ([#19776](https://github.com/apache/superset/issues/19776)) ([3c28cd4](https://github.com/apache/superset/commit/3c28cd4625fdeeaeeac3ed730907af1fb86bc86e))
- Add ValuePercent option to LABEL TYPE for Pie and Funnel charts ([#26407](https://github.com/apache/superset/issues/26407)) ([3a7d76c](https://github.com/apache/superset/commit/3a7d76cece4408c8e80862ab9db3a38eaaafdc8c))
- adding truncate metric control on timeseries charts ([#20373](https://github.com/apache/superset/issues/20373)) ([7c252d7](https://github.com/apache/superset/commit/7c252d75240559d0bba9be3be8419b65b86967df))
- adding XAxis to BigNumberTrend ([#21577](https://github.com/apache/superset/issues/21577)) ([f4646f8](https://github.com/apache/superset/commit/f4646f8edba396dba24e6ff4fbc054d073d77fd7))
- Adds a control to set the Secondary Y-axis bounds in Mixed charts ([#23917](https://github.com/apache/superset/issues/23917)) ([b4371f6](https://github.com/apache/superset/commit/b4371f68b77a98231619d0288578b49d57b21053))
- Adds drill to detail context menu for ECharts visualizations ([#20891](https://github.com/apache/superset/issues/20891)) ([3df8335](https://github.com/apache/superset/commit/3df8335f8792c85d7e2f7fefa5dd60fb2c0befaf))
- Adds drill to detail context menu to Pivot Table ([#21198](https://github.com/apache/superset/issues/21198)) ([859b6d2](https://github.com/apache/superset/commit/859b6d2d20a58f2079c43bb66645fd3b604e077e))
- Adds Histogram chart migration logic ([#28780](https://github.com/apache/superset/issues/28780)) ([df0b1cb](https://github.com/apache/superset/commit/df0b1cb8ed6720f77793036d7fb68548670b3bec))
- Adds legacy time support for Waterfall chart ([#26136](https://github.com/apache/superset/issues/26136)) ([f405ba0](https://github.com/apache/superset/commit/f405ba033e04e2694f869738163d33e1d3991297))
- Adds Sunburst chart migration logic ([#25343](https://github.com/apache/superset/issues/25343)) ([0c083bd](https://github.com/apache/superset/commit/0c083bdc1af4e6a3e17155246a3134cb5cb5887d))
- Adds the ECharts Bubble chart ([#22107](https://github.com/apache/superset/issues/22107)) ([c81c60c](https://github.com/apache/superset/commit/c81c60c91fbcb09dd63c05f050e18ee09ceebfd6))
- Adds the ECharts Heatmap chart ([#25353](https://github.com/apache/superset/issues/25353)) ([546d48a](https://github.com/apache/superset/commit/546d48adbb84b1354d6a3d4ae88dbeba0ad14d44))
- Adds the ECharts Histogram chart ([#28652](https://github.com/apache/superset/issues/28652)) ([896fe85](https://github.com/apache/superset/commit/896fe854dc3865214325cfceea94824ff41a1b6c))
- Adds the ECharts Sankey chart ([#29329](https://github.com/apache/superset/issues/29329)) ([c83d5b8](https://github.com/apache/superset/commit/c83d5b88e159413d09fb346a95201255b1b5e196))
- Adds the ECharts Sunburst chart ([#22833](https://github.com/apache/superset/issues/22833)) ([30abefb](https://github.com/apache/superset/commit/30abefb519978e2760a492de51dc0d19803edf3a))
- Adds the Featured Charts dashboard ([#28789](https://github.com/apache/superset/issues/28789)) ([95706d9](https://github.com/apache/superset/commit/95706d9be2b5414ed496ad762ba1996041429e01))
- **advanced analysis:** support MultiIndex column in post processing stage ([#19116](https://github.com/apache/superset/issues/19116)) ([375c03e](https://github.com/apache/superset/commit/375c03e08407570bcf417acf5f3d25b28843329c))
- apply Time Grain to X-Axis column ([#21163](https://github.com/apache/superset/issues/21163)) ([ce3d38d](https://github.com/apache/superset/commit/ce3d38d2e72a56014fa96ee3d4afe066277cc5be))
- Axis sort in the Bar Chart V2 ([#21993](https://github.com/apache/superset/issues/21993)) ([22fab5e](https://github.com/apache/superset/commit/22fab5e58ce574e962518067d982e3036449e580))
- **bar_chart:** Stacked Bar chart with Time comparison in separated stacks ([#27589](https://github.com/apache/superset/issues/27589)) ([8a715cc](https://github.com/apache/superset/commit/8a715cc1b5fd687acda48443f18c93358e4a92e0))
- **chart & legend:** make to enable show legend by default ([#19927](https://github.com/apache/superset/issues/19927)) ([7b3d0f0](https://github.com/apache/superset/commit/7b3d0f040b050905f7d0901d0227f1cd6b761b56))
- conditional coloring for big number chart ([#23064](https://github.com/apache/superset/issues/23064)) ([61d8a0b](https://github.com/apache/superset/commit/61d8a0bd1206ffc96ea2f9284e4c238241fcca79))
- **dashboard:** Add cross filter from context menu ([#23141](https://github.com/apache/superset/issues/23141)) ([ee1952e](https://github.com/apache/superset/commit/ee1952e488f2cd0913fe6f35ffe551d18ee3d143))
- **dashboard:** menu improvements, fallback support for Drill to Detail ([#21351](https://github.com/apache/superset/issues/21351)) ([76e57ec](https://github.com/apache/superset/commit/76e57ec651bbfaf4f76031eeeca66f6a1fa81bc2))
- Data Zoom scrolls using the mouse (mark II) ([#28629](https://github.com/apache/superset/issues/28629)) ([ac53f7f](https://github.com/apache/superset/commit/ac53f7fea9d820fbc651be7d8e31d054d09f0787))
- derived metrics use different line style ([#20242](https://github.com/apache/superset/issues/20242)) ([7faf874](https://github.com/apache/superset/commit/7faf874c1b9613258606fb10f5800a185c30c81e))
- **echarts-funnel:** Implement % calculation type ([#26290](https://github.com/apache/superset/issues/26290)) ([5400d30](https://github.com/apache/superset/commit/5400d30b201d5ba987dfda8ade1a157580d9cc7c))
- **echarts-pie:** add string template support for labels ([#28774](https://github.com/apache/superset/issues/28774)) ([a067ffb](https://github.com/apache/superset/commit/a067ffb92d7f3d80bbcf8213d15a8c269c5f263b))
- **echarts:** Add x axis sort by to all series charts ([#23450](https://github.com/apache/superset/issues/23450)) ([8ecf0b1](https://github.com/apache/superset/commit/8ecf0b1c2009c86e56ba7930842f985c5f7f984a))
- **echarts:** Implement stream graph for Echarts Timeseries ([#23410](https://github.com/apache/superset/issues/23410)) ([b0d83e8](https://github.com/apache/superset/commit/b0d83e8c5086014492f1d11ca19c7c6871b102c7))
- Enable cross fitlers in WorldMap and Graph charts ([#22886](https://github.com/apache/superset/issues/22886)) ([871cab8](https://github.com/apache/superset/commit/871cab8cbe20971efd9b81f647ed537ad4fbe12b))
- Enables ECharts legend selector ([#23590](https://github.com/apache/superset/issues/23590)) ([30f210b](https://github.com/apache/superset/commit/30f210b84242051fe2f3d812ad8f5a10a0bed1b5))
- explicit distribute columns on BoxPlot and apply time grain ([#21593](https://github.com/apache/superset/issues/21593)) ([93f08e7](https://github.com/apache/superset/commit/93f08e778bfd48be150749f22d0b184467da73ac))
- **explore:** Denormalize form data in echarts, world map and nvd3 bar and line charts ([#20313](https://github.com/apache/superset/issues/20313)) ([354a899](https://github.com/apache/superset/commit/354a89950c4d001da3e107f60788cea873bd6bf6))
- **explore:** improve UI in the control panel ([#19748](https://github.com/apache/superset/issues/19748)) ([e3a54aa](https://github.com/apache/superset/commit/e3a54aa3c15bdd0c970aa73f898288a408205c97))
- format timestamps in drill by breadcrumbs ([#23698](https://github.com/apache/superset/issues/23698)) ([0bf8907](https://github.com/apache/superset/commit/0bf8907f2f6d7a17a1e3efa1c03a5af06daa8190))
- **formatters:** Add custom d3-time-format locale ([#24263](https://github.com/apache/superset/issues/24263)) ([024cfd8](https://github.com/apache/superset/commit/024cfd86e408ec5f7ddf49a9e90908e2fb2e6b70))
- Funnel/tooltip-customization ([#25666](https://github.com/apache/superset/issues/25666)) ([dfff3c1](https://github.com/apache/superset/commit/dfff3c1cbaccc416315aa09efd9b32430f473ef0))
- generate consistent QueryObject whether GenericAxis is enabled or disabled ([#21519](https://github.com/apache/superset/issues/21519)) ([4d12e37](https://github.com/apache/superset/commit/4d12e3709eb7ab1cc4f687c15ed54a4738266482))
- **generic-x-axis:** add x sorting on series limit metric ([#23274](https://github.com/apache/superset/issues/23274)) ([1b139d0](https://github.com/apache/superset/commit/1b139d074852e13c113a408a920991b2abc98387))
- Implement context menu for drill by ([#23454](https://github.com/apache/superset/issues/23454)) ([9fbfd1c](https://github.com/apache/superset/commit/9fbfd1c1d883f983ef96b8812297721e2a1a9695))
- Implement currencies formatter for saved metrics ([#24517](https://github.com/apache/superset/issues/24517)) ([83ff4cd](https://github.com/apache/superset/commit/83ff4cd86a4931fc8eda83aeb3d8d3c92d773202))
- Implement support for currencies in more charts ([#24594](https://github.com/apache/superset/issues/24594)) ([d74d7ec](https://github.com/apache/superset/commit/d74d7eca23a3c94bc48af082c115d34c103e815d))
- improve color consistency (save all labels) ([#19038](https://github.com/apache/superset/issues/19038)) ([dc57508](https://github.com/apache/superset/commit/dc575080d7e43d40b1734bb8f44fdc291cb95b11))
- Improves the Waterfall chart ([#25557](https://github.com/apache/superset/issues/25557)) ([d619078](https://github.com/apache/superset/commit/d619078d25dde63c55e9afd87e98f05d4fb82b86))
- Make time shifted series colors match the original series ([#24048](https://github.com/apache/superset/issues/24048)) ([df4d16a](https://github.com/apache/superset/commit/df4d16a7eec3ba06bf1d5e9f016cb0d86b9693e5))
- Move cross filters to Dashboard ([#22785](https://github.com/apache/superset/issues/22785)) ([9ed2326](https://github.com/apache/superset/commit/9ed2326a20329d41abc8e0995b0ba6110379088f))
- **plugin-chart-echarts:** [feature-parity] support extra control for the area chart V2 ([#16493](https://github.com/apache/superset/issues/16493)) ([eab0009](https://github.com/apache/superset/commit/eab0009101a295acf4d8d31df8a57f8fe0deb517))
- **plugin-chart-echarts:** able to sort bar on the bar chart V2 ([#21356](https://github.com/apache/superset/issues/21356)) ([59437ea](https://github.com/apache/superset/commit/59437ea6e7ec02267c6e03e174be39a6cae48893))
- **plugin-chart-echarts:** add aggregate total for the Pie/Donuct chart ([#19622](https://github.com/apache/superset/issues/19622)) ([a6bf041](https://github.com/apache/superset/commit/a6bf041eddcde0247461f35c806414df00ef105e))
- **plugin-chart-echarts:** add series sorting ([#23392](https://github.com/apache/superset/issues/23392)) ([0c454c6](https://github.com/apache/superset/commit/0c454c64426376d7fb209a8b16d15c580be811f4))
- **plugin-chart-echarts:** add support for generic axis to mixed chart ([#20097](https://github.com/apache/superset/issues/20097)) ([d5c5e58](https://github.com/apache/superset/commit/d5c5e58583771a35d8870ce3694b2a3f1b688159))
- **plugin-chart-echarts:** add x-axis sort to multi series ([#23644](https://github.com/apache/superset/issues/23644)) ([f49702f](https://github.com/apache/superset/commit/f49702feffb3b08476c22916e185c0ce2c64e7f1))
- **plugin-chart-echarts:** Echarts Waterfall ([#17906](https://github.com/apache/superset/issues/17906)) ([17792a5](https://github.com/apache/superset/commit/17792a507c7245c9e09c6eb98a774f2ef4ec8568))
- **plugin-chart-echarts:** support horizontal bar chart ([#19918](https://github.com/apache/superset/issues/19918)) ([9854d2d](https://github.com/apache/superset/commit/9854d2d0e8f849366b264353819c6fdf4b0d804d))
- **plugin-chart-echarts:** support non-timeseries x-axis ([#17917](https://github.com/apache/superset/issues/17917)) ([e9651ea](https://github.com/apache/superset/commit/e9651ea52fdc0edb574bfb9dc1b22c225bcc068f)), closes [#18021](https://github.com/apache/superset/issues/18021) [#18039](https://github.com/apache/superset/issues/18039) [#17569](https://github.com/apache/superset/issues/17569) [#18037](https://github.com/apache/superset/issues/18037)
- **plugin-chart-echarts:** Support stacking negative and positive values ([#20408](https://github.com/apache/superset/issues/20408)) ([c959d92](https://github.com/apache/superset/commit/c959d92dd17499e3fb7a0f4f02f3781516f3d3e6))
- **plugin-chart-echarts:** supports sunburst chart v2 [WIP] ([#21625](https://github.com/apache/superset/issues/21625)) ([b53941f](https://github.com/apache/superset/commit/b53941fb3eef7ab3936a0a3f16e22c921d946f53))
- **plugins:** add color options for big number with time comparison ([#27524](https://github.com/apache/superset/issues/27524)) ([ae29427](https://github.com/apache/superset/commit/ae294274c7da58826a309ab06356d097e98fbe0a))
- Responsive UI for Big Number with Time Comparison ([#27375](https://github.com/apache/superset/issues/27375)) ([5de2530](https://github.com/apache/superset/commit/5de2530e3cdc5799d08cfbad5871d24762a47ce4))
- setting limit value when Pie chart switches ([#20392](https://github.com/apache/superset/issues/20392)) ([0a50a9b](https://github.com/apache/superset/commit/0a50a9b3804837ea7130f91bfcfcca57ab50129f))
- **standardized form data:** keep all columns and metrics ([#20377](https://github.com/apache/superset/issues/20377)) ([bbbe102](https://github.com/apache/superset/commit/bbbe102887a524b1ee0ffd4ada8481078dbe5496))
- standardized form_data ([#20010](https://github.com/apache/superset/issues/20010)) ([dd4b581](https://github.com/apache/superset/commit/dd4b581fb55d920fc3b709fc044cea5339802ee2))
- **storybook:** Co-habitating/Upgrading Storybooks to v7 (dependency madness ensues) ([#26907](https://github.com/apache/superset/issues/26907)) ([753ef69](https://github.com/apache/superset/commit/753ef695294ce26238b68ff41ba0a9af6aea74de))
- **table:** Table with Time Comparison ([#28057](https://github.com/apache/superset/issues/28057)) ([7ddea62](https://github.com/apache/superset/commit/7ddea62331617dad1b8ade1abe7dd8c11a1ba20d))
- **time_comparison:** Support all date formats when computing custom and inherit offsets ([#30002](https://github.com/apache/superset/issues/30002)) ([bc6d2db](https://github.com/apache/superset/commit/bc6d2dba373e59a498d942909ab6631e5c8521e9))
- **timeseries-chart:** add percentage threshold input control ([#17758](https://github.com/apache/superset/issues/17758)) ([6bd4dd2](https://github.com/apache/superset/commit/6bd4dd257a6089a093bae3f251cf9f0976d353e6))
- Utility function to render chart tooltips ([#27950](https://github.com/apache/superset/issues/27950)) ([b549977](https://github.com/apache/superset/commit/b549977f0538d6939dce756c7615052e5f2e6c93))
- **viz picker:** Remove some tags, refactor Recommended section ([#27708](https://github.com/apache/superset/issues/27708)) ([c314999](https://github.com/apache/superset/commit/c3149994ac0d4392e0462421b62cd0c034142082))

### Performance Improvements

- Implement Echarts treeshaking ([#29874](https://github.com/apache/superset/issues/29874)) ([c220245](https://github.com/apache/superset/commit/c2202454147936d1770137eaac334719b8e746e2))

### Reverts

- Revert "feat(plugin-chart-echarts): Support stacking negative and positive values (#20408)" (#20571) ([f5f8dde](https://github.com/apache/superset/commit/f5f8ddec3e5c947896521003295e1acd93851674)), closes [#20408](https://github.com/apache/superset/issues/20408) [#20571](https://github.com/apache/superset/issues/20571)

# [0.18.0](https://github.com/apache-superset/superset-ui/compare/v0.17.87...v0.18.0) (2021-08-30)

**Note:** Version bump only for package @superset-ui/plugin-chart-echarts

## [0.17.63](https://github.com/apache-superset/superset-ui/compare/v0.17.62...v0.17.63) (2021-07-02)

**Note:** Version bump only for package @superset-ui/plugin-chart-echarts

## [0.17.61](https://github.com/apache-superset/superset-ui/compare/v0.17.60...v0.17.61) (2021-07-02)

### Bug Fixes

- **plugin-chart-echarts:** enable animation to clear old nodes ([#1200](https://github.com/apache-superset/superset-ui/issues/1200)) ([1ee7f4e](https://github.com/apache-superset/superset-ui/commit/1ee7f4e36e1245917e61999f190a84425e82ea38))
- **plugin-chart-echarts:** sanitize series from html tags ([#1126](https://github.com/apache-superset/superset-ui/issues/1126)) ([fcd6fde](https://github.com/apache-superset/superset-ui/commit/fcd6fde44bb45df3aab5ac5bb990504e7dbde324))
