/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.osgi;

import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.config.PackageProvider;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.osgi.BundleAccessor;
import org.apache.struts2.osgi.OsgiConfigurationProvider;
import org.apache.struts2.util.ObjectFactoryDestroyable;

public class DelegatingObjectFactory
extends ObjectFactory
implements ObjectFactoryDestroyable {
    private static final Logger LOG = LogManager.getLogger(DelegatingObjectFactory.class);
    private ObjectFactory delegateObjectFactory;
    private BundleAccessor bundleResourceLoader;
    private OsgiConfigurationProvider osgiConfigurationProvider;

    public DelegatingObjectFactory() {
        LOG.trace("OSGi Plugin - DelegatingObjectFactory() constructor called.");
    }

    @Inject
    public void setDelegateObjectFactory(@Inject Container container, @Inject(value="struts.objectFactory.delegate") String delegate) {
        LOG.trace("OSGi Plugin - setDelegateObjectFactory() call - Delegate: [{}], Container: [{}]", (Object)delegate, (Object)container);
        if (delegate == null) {
            delegate = "struts";
        }
        this.delegateObjectFactory = (ObjectFactory)container.getInstance(ObjectFactory.class, delegate);
        LOG.trace("OSGi Plugin - setDelegateObjectFactory() call - Result: [{}]", (Object)this.delegateObjectFactory);
    }

    @Inject
    public void setBundleResourceLoader(BundleAccessor rl) {
        LOG.trace("OSGi Plugin - Set BundleResourceLoader() call - BundleAccessor: [{}]", (Object)rl);
        this.bundleResourceLoader = rl;
    }

    public boolean isNoArgConstructorRequired() {
        if (this.delegateObjectFactory == null) {
            throw new IllegalStateException("Cannot check if no-argument constructor required, delegate object factory is null");
        }
        return this.delegateObjectFactory.isNoArgConstructorRequired();
    }

    public Object buildBean(Class clazz, Map extraContext) throws Exception {
        if (this.delegateObjectFactory == null) {
            LOG.trace("OSGi Plugin - buildbean(Class, Map) call when delegateObjectFactory is NULL.  NPE would result, calling ancestor (fallback)");
            return super.buildBean(clazz, extraContext);
        }
        return this.delegateObjectFactory.buildBean(clazz, extraContext);
    }

    public Object buildBean(String className, Map<String, Object> extraContext, boolean injectInternal) throws Exception {
        if (this.delegateObjectFactory == null) {
            LOG.trace("OSGi Plugin - buildbean(Class, Map, boolean) call when delegateObjectFactory is NULL.  NPE would result, calling ancestor (fallback)");
            return super.buildBean(className, extraContext, injectInternal);
        }
        try {
            return this.delegateObjectFactory.buildBean(className, extraContext, injectInternal);
        }
        catch (Exception e) {
            if (this.bundleResourceLoader == null) {
                throw new IllegalStateException("Cannot build bean, bundle resource loader is null");
            }
            Object object = this.bundleResourceLoader.loadClass(className).newInstance();
            if (injectInternal) {
                this.injectInternalBeans(object);
            }
            return object;
        }
    }

    public Class getClassInstance(String className) throws ClassNotFoundException {
        if (this.delegateObjectFactory == null) {
            LOG.trace("OSGi Plugin - buildbean(Class, Map, boolean) call when delegateObjectFactory is NULL.  NPE would result, calling ancestor (fallback)");
            return super.getClassInstance(className);
        }
        try {
            return this.delegateObjectFactory.getClassInstance(className);
        }
        catch (Exception e) {
            if (this.bundleResourceLoader == null) {
                throw new IllegalStateException("Cannot get class instance, bundle resource loader is null");
            }
            return this.bundleResourceLoader.loadClass(className);
        }
    }

    public void destroy() {
        if (this.osgiConfigurationProvider != null) {
            this.osgiConfigurationProvider.destroy();
        }
    }

    @Inject(value="osgi")
    public void setOsgiConfigurationProvider(PackageProvider osgiConfigurationProvider) {
        LOG.trace("OSGi Plugin - setOsgiConfigurationProvider() call - PackageProvider: [{}]", (Object)osgiConfigurationProvider);
        this.osgiConfigurationProvider = (OsgiConfigurationProvider)osgiConfigurationProvider;
    }
}

