/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.common.enums.ExecutionMode;
import org.apache.streampark.common.util.AssertUtils;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.apache.streampark.console.base.mybatis.pager.MybatisPager;
import org.apache.streampark.console.core.bean.ResponseResult;
import org.apache.streampark.console.core.entity.YarnQueue;
import org.apache.streampark.console.core.mapper.YarnQueueMapper;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.service.FlinkClusterService;
import org.apache.streampark.console.core.service.YarnQueueService;
import org.apache.streampark.console.core.utils.YarnQueueLabelExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
public class YarnQueueServiceImpl
extends ServiceImpl<YarnQueueMapper, YarnQueue>
implements YarnQueueService {
    private static final Logger log = LoggerFactory.getLogger(YarnQueueServiceImpl.class);
    public static final String DEFAULT_QUEUE = "default";
    public static final String QUEUE_USED_FORMAT = "Please remove the yarn queue for '%s' referenced it before '%s'.";
    public static final String QUEUE_EXISTED_IN_TEAM_HINT = "The queue label existed already. Try on a new queue label, please.";
    public static final String QUEUE_EMPTY_HINT = "Yarn queue label mustn't be empty.";
    public static final String QUEUE_AVAILABLE_HINT = "The queue label is available.";
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private FlinkClusterService flinkClusterService;

    @Override
    public IPage<YarnQueue> page(YarnQueue yarnQueue, RestRequest request) {
        AssertUtils.notNull((Object)yarnQueue, (String)"Yarn queue query params mustn't be null.");
        AssertUtils.notNull((Object)yarnQueue.getTeamId(), (String)"Team id of yarn queue query params mustn't be null.");
        Page page = MybatisPager.getPage(request);
        return ((YarnQueueMapper)this.baseMapper).findQueues(page, yarnQueue);
    }

    @Override
    public ResponseResult<String> checkYarnQueue(YarnQueue yarnQueue) {
        AssertUtils.notNull((Object)yarnQueue, (String)"Yarn queue mustn't be empty.");
        AssertUtils.notNull((Object)yarnQueue.getTeamId(), (String)"Team id mustn't be null.");
        ResponseResult<String> responseResult = new ResponseResult<String>();
        if (StringUtils.isEmpty((CharSequence)yarnQueue.getQueueLabel())) {
            responseResult.setStatus(3);
            responseResult.setMsg(QUEUE_EMPTY_HINT);
            return responseResult;
        }
        boolean valid = YarnQueueLabelExpression.isValid(yarnQueue.getQueueLabel());
        if (!valid) {
            responseResult.setStatus(2);
            responseResult.setMsg("Yarn queue label format should be in format {queue} or {queue}@{label1,label2}");
            return responseResult;
        }
        boolean existed = ((YarnQueueMapper)this.baseMapper).existsByQueueLabel(yarnQueue);
        if (existed) {
            responseResult.setStatus(1);
            responseResult.setMsg(QUEUE_EXISTED_IN_TEAM_HINT);
            return responseResult;
        }
        responseResult.setStatus(0);
        responseResult.setMsg(QUEUE_AVAILABLE_HINT);
        return responseResult;
    }

    @Override
    public boolean createYarnQueue(YarnQueue yarnQueue) {
        ResponseResult<String> checkResponse = this.checkYarnQueue(yarnQueue);
        ApiAlertException.throwIfFalse(checkResponse.getStatus() == 0, checkResponse.getMsg());
        Date date = new Date();
        yarnQueue.setCreateTime(date);
        yarnQueue.setModifyTime(date);
        return this.save(yarnQueue);
    }

    @Override
    public void updateYarnQueue(YarnQueue yarnQueue) {
        YarnQueue queueFromDB = this.getYarnQueueByIdWithPreconditions(yarnQueue);
        if (StringUtils.equals((CharSequence)yarnQueue.getQueueLabel(), (CharSequence)queueFromDB.getQueueLabel()) && StringUtils.equals((CharSequence)yarnQueue.getDescription(), (CharSequence)queueFromDB.getDescription())) {
            return;
        }
        if (StringUtils.equals((CharSequence)yarnQueue.getQueueLabel(), (CharSequence)queueFromDB.getQueueLabel())) {
            queueFromDB.setDescription(yarnQueue.getDescription());
            this.updateById(queueFromDB);
            return;
        }
        ApiAlertException.throwIfFalse(YarnQueueLabelExpression.isValid(yarnQueue.getQueueLabel()), "Yarn queue label format should be in format {queue} or {queue}@{label1,label2}");
        this.checkNotReferencedByApplications(queueFromDB.getTeamId(), queueFromDB.getQueueLabel(), "updating");
        this.checkNotReferencedByFlinkClusters(queueFromDB.getQueueLabel(), "updating");
        queueFromDB.setModifyTime(new Date());
        queueFromDB.setDescription(yarnQueue.getDescription());
        queueFromDB.setQueueLabel(yarnQueue.getQueueLabel());
        this.updateById(queueFromDB);
    }

    @Override
    public void deleteYarnQueue(YarnQueue yarnQueue) {
        YarnQueue queueFromDB = this.getYarnQueueByIdWithPreconditions(yarnQueue);
        this.checkNotReferencedByApplications(queueFromDB.getTeamId(), queueFromDB.getQueueLabel(), "deleting");
        this.checkNotReferencedByFlinkClusters(queueFromDB.getQueueLabel(), "deleting");
        this.removeById(yarnQueue.getId());
    }

    @Override
    public void checkQueueLabel(ExecutionMode executionMode, String queueLabel) {
        if (ExecutionMode.isYarnMode((ExecutionMode)executionMode)) {
            ApiAlertException.throwIfFalse(YarnQueueLabelExpression.isValid(queueLabel, true), "Yarn queue label format should be in format {queue} or {queue}@{label1,label2}");
        }
    }

    @Override
    public boolean isDefaultQueue(String queueLabel) {
        return StringUtils.equals((CharSequence)DEFAULT_QUEUE, (CharSequence)queueLabel) || StringUtils.isEmpty((CharSequence)queueLabel);
    }

    @Override
    public boolean existByQueueLabel(String queueLabel) {
        return ((YarnQueueMapper)this.getBaseMapper()).exists((Wrapper)new LambdaQueryWrapper().eq(YarnQueue::getQueueLabel, (Object)queueLabel));
    }

    @Override
    public boolean existByTeamIdQueueLabel(Long teamId, String queueLabel) {
        return ((YarnQueueMapper)this.getBaseMapper()).exists((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(YarnQueue::getTeamId, (Object)teamId)).eq(YarnQueue::getQueueLabel, (Object)queueLabel));
    }

    @VisibleForTesting
    public YarnQueue getYarnQueueByIdWithPreconditions(YarnQueue yarnQueue) {
        AssertUtils.notNull((Object)yarnQueue, (String)"Yarn queue mustn't be null.");
        AssertUtils.notNull((Object)yarnQueue.getId(), (String)"Yarn queue id mustn't be null.");
        YarnQueue queueFromDB = (YarnQueue)this.getById(yarnQueue.getId());
        ApiAlertException.throwIfNull(queueFromDB, "The queue doesn't exist.");
        return queueFromDB;
    }

    @VisibleForTesting
    public void checkNotReferencedByFlinkClusters(@Nonnull String queueLabel, @Nonnull String operation) {
        List clustersReferenceYarnQueueLabel = this.flinkClusterService.getByExecutionModes(Sets.newHashSet((Object[])new ExecutionMode[]{ExecutionMode.YARN_SESSION})).stream().filter(flinkCluster -> StringUtils.equals((CharSequence)flinkCluster.getYarnQueue(), (CharSequence)queueLabel)).collect(Collectors.toList());
        ApiAlertException.throwIfFalse(CollectionUtils.isEmpty(clustersReferenceYarnQueueLabel), String.format(QUEUE_USED_FORMAT, "flink clusters", operation));
    }

    @VisibleForTesting
    public void checkNotReferencedByApplications(@Nonnull Long teamId, @Nonnull String queueLabel, @Nonnull String operation) {
        List appsReferenceQueueLabel = this.applicationService.getByTeamIdAndExecutionModes(teamId, Sets.newHashSet((Object[])new ExecutionMode[]{ExecutionMode.YARN_APPLICATION, ExecutionMode.YARN_PER_JOB})).stream().filter(application -> {
            application.setByHotParams();
            return StringUtils.equals((CharSequence)application.getYarnQueue(), (CharSequence)queueLabel);
        }).collect(Collectors.toList());
        ApiAlertException.throwIfFalse(CollectionUtils.isEmpty(appsReferenceQueueLabel), String.format(QUEUE_USED_FORMAT, "applications", operation));
    }
}

