/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.bean;

import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.streampark.flink.packer.pipeline.DockerBuildSnapshot;
import org.apache.streampark.flink.packer.pipeline.DockerPullSnapshot;
import org.apache.streampark.flink.packer.pipeline.DockerPushSnapshot;
import org.apache.streampark.flink.packer.pipeline.DockerResolvedSnapshot;

public class AppBuildDockerResolvedDetail {
    @Nullable
    private ImagePull pull;
    @Nullable
    private ImageBuild build;
    @Nullable
    private ImagePush push;

    public static AppBuildDockerResolvedDetail of(@Nullable DockerResolvedSnapshot snapshot) {
        AppBuildDockerResolvedDetail detail = new AppBuildDockerResolvedDetail();
        if (snapshot == null) {
            return detail;
        }
        return detail.setPull(ImagePull.of(snapshot.pull())).setBuild(ImageBuild.of(snapshot.build())).setPush(ImagePush.of(snapshot.push()));
    }

    @Nullable
    public ImagePull getPull() {
        return this.pull;
    }

    @Nullable
    public ImageBuild getBuild() {
        return this.build;
    }

    @Nullable
    public ImagePush getPush() {
        return this.push;
    }

    public AppBuildDockerResolvedDetail setPull(@Nullable ImagePull pull) {
        this.pull = pull;
        return this;
    }

    public AppBuildDockerResolvedDetail setBuild(@Nullable ImageBuild build) {
        this.build = build;
        return this;
    }

    public AppBuildDockerResolvedDetail setPush(@Nullable ImagePush push) {
        this.push = push;
        return this;
    }

    public static class ImageLayer {
        private String layerId;
        private String status;
        private Double currentMb;
        private Double totalMb;
        private Double percent;

        public String getLayerId() {
            return this.layerId;
        }

        public String getStatus() {
            return this.status;
        }

        public Double getCurrentMb() {
            return this.currentMb;
        }

        public Double getTotalMb() {
            return this.totalMb;
        }

        public Double getPercent() {
            return this.percent;
        }

        public ImageLayer setLayerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public ImageLayer setStatus(String status) {
            this.status = status;
            return this;
        }

        public ImageLayer setCurrentMb(Double currentMb) {
            this.currentMb = currentMb;
            return this;
        }

        public ImageLayer setTotalMb(Double totalMb) {
            this.totalMb = totalMb;
            return this;
        }

        public ImageLayer setPercent(Double percent) {
            this.percent = percent;
            return this;
        }
    }

    public static class ImagePush {
        private List<ImageLayer> layers;
        private Date st;

        public static ImagePush of(DockerPushSnapshot snapshot) {
            if (snapshot == null) {
                return null;
            }
            return new ImagePush().setSt(new Date(snapshot.emitTime())).setLayers(snapshot.detailAsJava().stream().map(e -> new ImageLayer().setLayerId(e.layerId()).setStatus(e.status()).setCurrentMb(e.currentMb()).setTotalMb(e.totalMb()).setPercent(e.percent())).sorted(Comparator.comparing(ImageLayer::getStatus).reversed()).collect(Collectors.toList()));
        }

        public List<ImageLayer> getLayers() {
            return this.layers;
        }

        public Date getSt() {
            return this.st;
        }

        public ImagePush setLayers(List<ImageLayer> layers) {
            this.layers = layers;
            return this;
        }

        public ImagePush setSt(Date st) {
            this.st = st;
            return this;
        }
    }

    public static class ImageBuild {
        private List<String> steps;
        private Date st;

        public static ImageBuild of(DockerBuildSnapshot snapshot) {
            if (snapshot == null) {
                return null;
            }
            return new ImageBuild().setSt(new Date(snapshot.emitTime())).setSteps(snapshot.detailAsJava().stream().filter(e -> e.trim().startsWith("Step") || e.trim().startsWith("step")).collect(Collectors.toList()));
        }

        public List<String> getSteps() {
            return this.steps;
        }

        public Date getSt() {
            return this.st;
        }

        public ImageBuild setSteps(List<String> steps) {
            this.steps = steps;
            return this;
        }

        public ImageBuild setSt(Date st) {
            this.st = st;
            return this;
        }
    }

    public static class ImagePull {
        private List<ImageLayer> layers;
        private Date st;

        public static ImagePull of(DockerPullSnapshot snapshot) {
            if (snapshot == null) {
                return null;
            }
            return new ImagePull().setSt(new Date(snapshot.emitTime())).setLayers(snapshot.detailAsJava().stream().map(e -> new ImageLayer().setLayerId(e.layerId()).setStatus(e.status()).setCurrentMb(e.currentMb()).setTotalMb(e.totalMb()).setPercent(e.percent())).sorted(Comparator.comparing(ImageLayer::getStatus).reversed()).collect(Collectors.toList()));
        }

        public List<ImageLayer> getLayers() {
            return this.layers;
        }

        public Date getSt() {
            return this.st;
        }

        public ImagePull setLayers(List<ImageLayer> layers) {
            this.layers = layers;
            return this;
        }

        public ImagePull setSt(Date st) {
            this.st = st;
            return this;
        }
    }
}

