/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MeterView;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.metrics.TimerGauge;
import org.apache.flink.runtime.metrics.groups.ProxyMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;

public class TaskIOMetricGroup
extends ProxyMetricGroup<TaskMetricGroup> {
    private final Counter numBytesIn = this.counter("numBytesIn");
    private final Counter numBytesOut = this.counter("numBytesOut");
    private final SumCounter numRecordsIn;
    private final SumCounter numRecordsOut;
    private final Counter numBuffersOut;
    private final Meter numBytesInRate = this.meter("numBytesInPerSecond", new MeterView(this.numBytesIn));
    private final Meter numBytesOutRate = this.meter("numBytesOutPerSecond", new MeterView(this.numBytesOut));
    private final Meter numRecordsInRate;
    private final Meter numRecordsOutRate;
    private final Meter numBuffersOutRate;
    private final TimerGauge idleTimePerSecond;
    private final Gauge busyTimePerSecond;
    private final TimerGauge backPressuredTimePerSecond;
    private volatile boolean busyTimeEnabled;

    public TaskIOMetricGroup(TaskMetricGroup parent) {
        super(parent);
        this.numRecordsIn = this.counter("numRecordsIn", new SumCounter());
        this.numRecordsOut = this.counter("numRecordsOut", new SumCounter());
        this.numRecordsInRate = this.meter("numRecordsInPerSecond", new MeterView((Counter)this.numRecordsIn));
        this.numRecordsOutRate = this.meter("numRecordsOutPerSecond", new MeterView((Counter)this.numRecordsOut));
        this.numBuffersOut = this.counter("numBuffersOut");
        this.numBuffersOutRate = this.meter("numBuffersOutPerSecond", new MeterView(this.numBuffersOut));
        this.idleTimePerSecond = this.gauge("idleTimeMsPerSecond", new TimerGauge());
        this.backPressuredTimePerSecond = this.gauge("backPressuredTimeMsPerSecond", new TimerGauge());
        this.busyTimePerSecond = this.gauge("busyTimeMsPerSecond", this::getBusyTimePerSecond);
    }

    public IOMetrics createSnapshot() {
        return new IOMetrics(this.numRecordsInRate, this.numRecordsOutRate, this.numBytesInRate, this.numBytesOutRate);
    }

    public Counter getNumBytesInCounter() {
        return this.numBytesIn;
    }

    public Counter getNumBytesOutCounter() {
        return this.numBytesOut;
    }

    public Counter getNumRecordsInCounter() {
        return this.numRecordsIn;
    }

    public Counter getNumRecordsOutCounter() {
        return this.numRecordsOut;
    }

    public Counter getNumBuffersOutCounter() {
        return this.numBuffersOut;
    }

    public TimerGauge getIdleTimeMsPerSecond() {
        return this.idleTimePerSecond;
    }

    public TimerGauge getBackPressuredTimePerSecond() {
        return this.backPressuredTimePerSecond;
    }

    public void setEnableBusyTime(boolean enabled) {
        this.busyTimeEnabled = enabled;
    }

    private double getBusyTimePerSecond() {
        double busyTime = this.idleTimePerSecond.getValue() + this.backPressuredTimePerSecond.getValue();
        return this.busyTimeEnabled ? 1000.0 - Math.min(busyTime, 1000.0) : Double.NaN;
    }

    public void reuseRecordsInputCounter(Counter numRecordsInCounter) {
        this.numRecordsIn.addCounter(numRecordsInCounter);
    }

    public void reuseRecordsOutputCounter(Counter numRecordsOutCounter) {
        this.numRecordsOut.addCounter(numRecordsOutCounter);
    }

    private static class SumCounter
    extends SimpleCounter {
        private final List<Counter> internalCounters = new ArrayList<Counter>();

        SumCounter() {
        }

        public void addCounter(Counter toAdd) {
            this.internalCounters.add(toAdd);
        }

        public long getCount() {
            long sum = super.getCount();
            for (Counter counter : this.internalCounters) {
                sum += counter.getCount();
            }
            return sum;
        }
    }
}

