/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.classification.NaiveBayes$;
import org.apache.spark.ml.classification.NaiveBayesModel;
import org.apache.spark.ml.classification.NaiveBayesParams;
import org.apache.spark.ml.classification.ProbabilisticClassifier;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.stat.Summarizer$;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tEa\u0001B\u0010!\u0001-B\u0001b\u0011\u0001\u0003\u0006\u0004%\t\u0005\u0012\u0005\t7\u0002\u0011\t\u0011)A\u0005\u000b\")Q\f\u0001C\u0001=\")Q\f\u0001C\u0001E\")A\r\u0001C\u0001K\")a\u000e\u0001C\u0001_\")!\u000f\u0001C\u0001g\")\u0001\u0010\u0001C)s\"A\u0011Q\u0004\u0001\u0005\u0002\u0011\ny\u0002C\u0004\u00028\u0001!I!!\u000f\t\u000f\u0005E\u0003\u0001\"\u0003\u0002T!A\u00111\r\u0001\u0005B\u0011\n)\u0007C\u0004\u0002z\u0001!\t%a\u001f\b\u000f\u0005E\u0005\u0005#\u0001\u0002\u0014\u001a1q\u0004\tE\u0001\u0003+Ca!X\b\u0005\u0002\u0005M\u0006\"CA[\u001f\t\u0007I\u0011\u0001\u0011E\u0011\u001d\t9l\u0004Q\u0001\n\u0015C\u0011\"!/\u0010\u0005\u0004%\t\u0001\t#\t\u000f\u0005mv\u0002)A\u0005\u000b\"I\u0011QX\bC\u0002\u0013\u0005\u0001\u0005\u0012\u0005\b\u0003\u007f{\u0001\u0015!\u0003F\u0011%\t\tm\u0004b\u0001\n\u0003\u0001C\tC\u0004\u0002D>\u0001\u000b\u0011B#\t\u0015\u0005\u0015wB1A\u0005\u0002\u0001\n9\r\u0003\u0005\u0002Z>\u0001\u000b\u0011BAe\u0011!\tYn\u0004C\u0001E\u0005u\u0007\u0002CAu\u001f\u0011\u0005!%a;\t\u000f\u0005=x\u0002\"\u0011\u0002r\"I\u0011Q`\b\u0002\u0002\u0013%\u0011q \u0002\u000b\u001d\u0006Lg/\u001a\"bs\u0016\u001c(BA\u0011#\u00039\u0019G.Y:tS\u001aL7-\u0019;j_:T!a\t\u0013\u0002\u00055d'BA\u0013'\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0003&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002S\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\f\u001e>!\u0015ic\u0006\r\u001c8\u001b\u0005\u0001\u0013BA\u0018!\u0005]\u0001&o\u001c2bE&d\u0017n\u001d;jG\u000ec\u0017m]:jM&,'\u000f\u0005\u00022i5\t!G\u0003\u00024E\u00051A.\u001b8bY\u001eL!!\u000e\u001a\u0003\rY+7\r^8s!\ti\u0003\u0001\u0005\u0002.q%\u0011\u0011\b\t\u0002\u0010\u001d\u0006Lg/\u001a\"bs\u0016\u001cXj\u001c3fYB\u0011QfO\u0005\u0003y\u0001\u0012\u0001CT1jm\u0016\u0014\u0015-_3t!\u0006\u0014\u0018-\\:\u0011\u0005y\nU\"A \u000b\u0005\u0001\u0013\u0013\u0001B;uS2L!AQ \u0003+\u0011+g-Y;miB\u000b'/Y7t/JLG/\u00192mK\u0006\u0019Q/\u001b3\u0016\u0003\u0015\u0003\"AR(\u000f\u0005\u001dk\u0005C\u0001%L\u001b\u0005I%B\u0001&+\u0003\u0019a$o\\8u})\tA*A\u0003tG\u0006d\u0017-\u0003\u0002O\u0017\u00061\u0001K]3eK\u001aL!\u0001U)\u0003\rM#(/\u001b8h\u0015\tq5\nK\u0002\u0002'f\u0003\"\u0001V,\u000e\u0003US!A\u0016\u0013\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002Y+\n)1+\u001b8dK\u0006\n!,A\u00032]Ur\u0003'\u0001\u0003vS\u0012\u0004\u0003f\u0001\u0002T3\u00061A(\u001b8jiz\"\"AN0\t\u000b\r\u001b\u0001\u0019A#)\u0007}\u001b\u0016\fK\u0002\u0004'f#\u0012A\u000e\u0015\u0004\tMK\u0016\u0001D:fiNkwn\u001c;iS:<GC\u00014h\u001b\u0005\u0001\u0001\"\u00025\u0006\u0001\u0004I\u0017!\u0002<bYV,\u0007C\u00016l\u001b\u0005Y\u0015B\u00017L\u0005\u0019!u.\u001e2mK\"\u001aQaU-\u0002\u0019M,G/T8eK2$\u0016\u0010]3\u0015\u0005\u0019\u0004\b\"\u00025\u0007\u0001\u0004)\u0005f\u0001\u0004T3\u0006a1/\u001a;XK&<\u0007\u000e^\"pYR\u0011a\r\u001e\u0005\u0006Q\u001e\u0001\r!\u0012\u0015\u0004\u000fM3\u0018%A<\u0002\u000bIr\u0013G\f\u0019\u0002\u000bQ\u0014\u0018-\u001b8\u0015\u0005]R\b\"B>\t\u0001\u0004a\u0018a\u00023bi\u0006\u001cX\r\u001e\u0019\u0004{\u0006-\u0001#\u0002@\u0002\u0004\u0005\u001dQ\"A@\u000b\u0007\u0005\u0005A%A\u0002tc2L1!!\u0002\u0000\u0005\u001d!\u0015\r^1tKR\u0004B!!\u0003\u0002\f1\u0001AaCA\u0007u\u0006\u0005\t\u0011!B\u0001\u0003\u001f\u00111a\u0018\u00132#\u0011\t\t\"a\u0006\u0011\u0007)\f\u0019\"C\u0002\u0002\u0016-\u0013qAT8uQ&tw\rE\u0002k\u00033I1!a\u0007L\u0005\r\te._\u0001\u0014iJ\f\u0017N\\,ji\"d\u0015MY3m\u0007\",7m\u001b\u000b\u0006o\u0005\u0005\u0012Q\u0006\u0005\u0007w&\u0001\r!a\t1\t\u0005\u0015\u0012\u0011\u0006\t\u0006}\u0006\r\u0011q\u0005\t\u0005\u0003\u0013\tI\u0003\u0002\u0007\u0002,\u0005\u0005\u0012\u0011!A\u0001\u0006\u0003\tyAA\u0002`IIBq!a\f\n\u0001\u0004\t\t$\u0001\to_:tUmZ1uSZ,G*\u00192fYB\u0019!.a\r\n\u0007\u0005U2JA\u0004C_>dW-\u00198\u0002#Q\u0014\u0018-\u001b8ESN\u001c'/\u001a;f\u00136\u0004H\u000eF\u00038\u0003w\t9\u0005\u0003\u0004|\u0015\u0001\u0007\u0011Q\b\u0019\u0005\u0003\u007f\t\u0019\u0005E\u0003\u007f\u0003\u0007\t\t\u0005\u0005\u0003\u0002\n\u0005\rC\u0001DA#\u0003w\t\t\u0011!A\u0003\u0002\u0005=!aA0%g!9\u0011\u0011\n\u0006A\u0002\u0005-\u0013!B5ogR\u0014\bc\u0001 \u0002N%\u0019\u0011qJ \u0003\u001f%s7\u000f\u001e:v[\u0016tG/\u0019;j_:\f\u0011\u0003\u001e:bS:<\u0015-^:tS\u0006t\u0017*\u001c9m)\u00159\u0014QKA1\u0011\u0019Y8\u00021\u0001\u0002XA\"\u0011\u0011LA/!\u0015q\u00181AA.!\u0011\tI!!\u0018\u0005\u0019\u0005}\u0013QKA\u0001\u0002\u0003\u0015\t!a\u0004\u0003\u0007}#C\u0007C\u0004\u0002J-\u0001\r!a\u0013\u0002#\u0015\u001cH/[7bi\u0016lu\u000eZ3m'&TX\r\u0006\u0003\u0002h\u00055\u0004c\u00016\u0002j%\u0019\u00111N&\u0003\t1{gn\u001a\u0005\u0007w2\u0001\r!a\u001c1\t\u0005E\u0014Q\u000f\t\u0006}\u0006\r\u00111\u000f\t\u0005\u0003\u0013\t)\b\u0002\u0007\u0002x\u00055\u0014\u0011!A\u0001\u0006\u0003\tyAA\u0002`IU\nAaY8qsR\u0019a'! \t\u000f\u0005}T\u00021\u0001\u0002\u0002\u0006)Q\r\u001f;sCB!\u00111QAE\u001b\t\t)IC\u0002\u0002\b\n\nQ\u0001]1sC6LA!a#\u0002\u0006\nA\u0001+\u0019:b[6\u000b\u0007\u000fK\u0002\u000e'fC3\u0001A*Z\u0003)q\u0015-\u001b<f\u0005\u0006LXm\u001d\t\u0003[=\u0019raDAL\u0003;\u000b\u0019\u000bE\u0002k\u00033K1!a'L\u0005\u0019\te.\u001f*fMB!a(a(7\u0013\r\t\tk\u0010\u0002\u0016\t\u00164\u0017-\u001e7u!\u0006\u0014\u0018-\\:SK\u0006$\u0017M\u00197f!\u0011\t)+a,\u000e\u0005\u0005\u001d&\u0002BAU\u0003W\u000b!![8\u000b\u0005\u00055\u0016\u0001\u00026bm\u0006LA!!-\u0002(\na1+\u001a:jC2L'0\u00192mKR\u0011\u00111S\u0001\f\u001bVdG/\u001b8p[&\fG.\u0001\u0007Nk2$\u0018N\\8nS\u0006d\u0007%A\u0005CKJtw.\u001e7mS\u0006Q!)\u001a:o_VdG.\u001b\u0011\u0002\u0011\u001d\u000bWo]:jC:\f\u0011bR1vgNL\u0017M\u001c\u0011\u0002\u0015\r{W\u000e\u001d7f[\u0016tG/A\u0006D_6\u0004H.Z7f]R\u0004\u0013aE:vaB|'\u000f^3e\u001b>$W\r\u001c+za\u0016\u001cXCAAe!\u0015\tY-!6F\u001b\t\tiM\u0003\u0003\u0002P\u0006E\u0017!C5n[V$\u0018M\u00197f\u0015\r\t\u0019nS\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAl\u0003\u001b\u00141aU3u\u0003Q\u0019X\u000f\u001d9peR,G-T8eK2$\u0016\u0010]3tA\u0005A\"/Z9vSJ,gj\u001c8oK\u001e\fG/\u001b<f-\u0006dW/Z:\u0015\t\u0005}\u0017Q\u001d\t\u0004U\u0006\u0005\u0018bAAr\u0017\n!QK\\5u\u0011\u0019\t9o\u0007a\u0001a\u0005\ta/A\u000fsKF,\u0018N]3[KJ|wJ\\3CKJtw.\u001e7mSZ\u000bG.^3t)\u0011\ty.!<\t\r\u0005\u001dH\u00041\u00011\u0003\u0011aw.\u00193\u0015\u0007Y\n\u0019\u0010\u0003\u0004\u0002vv\u0001\r!R\u0001\u0005a\u0006$\b\u000e\u000b\u0003\u001e'\u0006e\u0018EAA~\u0003\u0015\tdF\u000e\u00181\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011\t\u0001\u0005\u0003\u0003\u0004\t%QB\u0001B\u0003\u0015\u0011\u00119!a+\u0002\t1\fgnZ\u0005\u0005\u0005\u0017\u0011)A\u0001\u0004PE*,7\r\u001e\u0015\u0005\u001fM\u000bI\u0010\u000b\u0003\u000f'\u0006e\b")
public class NaiveBayes
extends ProbabilisticClassifier<Vector, NaiveBayes, NaiveBayesModel>
implements NaiveBayesParams,
DefaultParamsWritable {
    private final String uid;
    private DoubleParam smoothing;
    private Param<String> modelType;
    private Param<String> weightCol;

    public static NaiveBayes load(String path) {
        return NaiveBayes$.MODULE$.load(path);
    }

    public static MLReader<NaiveBayes> read() {
        return NaiveBayes$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final double getSmoothing() {
        return NaiveBayesParams.getSmoothing$(this);
    }

    @Override
    public final String getModelType() {
        return NaiveBayesParams.getModelType$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final DoubleParam smoothing() {
        return this.smoothing;
    }

    @Override
    public final Param<String> modelType() {
        return this.modelType;
    }

    @Override
    public final void org$apache$spark$ml$classification$NaiveBayesParams$_setter_$smoothing_$eq(DoubleParam x$1) {
        this.smoothing = x$1;
    }

    @Override
    public final void org$apache$spark$ml$classification$NaiveBayesParams$_setter_$modelType_$eq(Param<String> x$1) {
        this.modelType = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public NaiveBayes setSmoothing(double value) {
        return (NaiveBayes)this.set(this.smoothing(), BoxesRunTime.boxToDouble((double)value));
    }

    public NaiveBayes setModelType(String value) {
        return (NaiveBayes)this.set(this.modelType(), value);
    }

    public NaiveBayes setWeightCol(String value) {
        return (NaiveBayes)this.set(this.weightCol(), value);
    }

    @Override
    public NaiveBayesModel train(Dataset<?> dataset) {
        return this.trainWithLabelCheck(dataset, true);
    }

    public NaiveBayesModel trainWithLabelCheck(Dataset<?> dataset, boolean nonNegativeLabel) {
        return (NaiveBayesModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable)instr -> {
            boolean bl;
            Column column;
            boolean bl2;
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Param[]{this.labelCol(), this.featuresCol(), this.weightCol(), this.predictionCol(), this.rawPredictionCol(), this.probabilityCol(), this.modelType(), this.smoothing(), this.thresholds()}));
            Column validatedLabelCol = nonNegativeLabel ? DatasetUtils$.MODULE$.checkClassificationLabels(this.$(this.labelCol()), (Option<Object>)this.get(this.thresholds()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)NaiveBayes.$anonfun$trainWithLabelCheck$2(x$1)))) : DatasetUtils$.MODULE$.checkRegressionLabels(this.$(this.labelCol()));
            Column validatedWeightCol = DatasetUtils$.MODULE$.checkNonNegativeWeights(this.get(this.weightCol()));
            Column vecCol = functions$.MODULE$.col(this.$(this.featuresCol()));
            String string = this.$(this.modelType());
            String string2 = NaiveBayes$.MODULE$.Multinomial();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                bl2 = true;
            } else {
                String string4 = NaiveBayes$.MODULE$.Complement();
                String string5 = string;
                bl2 = !(string4 != null ? !string4.equals(string5) : string5 != null);
            }
            if (bl2) {
                column = functions$.MODULE$.when(vecCol.isNull(), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.lit((Object)"Vectors MUST NOT be Null"))).when(functions$.MODULE$.exists(functions$.MODULE$.unwrap_udt(vecCol).getField("values"), (Function1 & Serializable)v -> v.isNaN().$bar$bar((Object)v.$less((Object)BoxesRunTime.boxToInteger((int)0))).$bar$bar((Object)v.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY)))), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"Vector values MUST NOT be Negative, NaN or Infinity, but got "), vecCol.cast((DataType)StringType$.MODULE$)})))).otherwise((Object)vecCol);
            } else {
                String string6 = NaiveBayes$.MODULE$.Bernoulli();
                String string7 = string;
                column = !(string6 != null ? !string6.equals(string7) : string7 != null) ? functions$.MODULE$.when(vecCol.isNull(), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.lit((Object)"Vectors MUST NOT be Null"))).when(functions$.MODULE$.exists(functions$.MODULE$.unwrap_udt(vecCol).getField("values"), (Function1 & Serializable)v -> v.$eq$bang$eq((Object)BoxesRunTime.boxToInteger((int)0)).$amp$amp((Object)v.$eq$bang$eq((Object)BoxesRunTime.boxToInteger((int)1)))), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"Vector values MUST be in {0, 1}, but got "), vecCol.cast((DataType)StringType$.MODULE$)})))).otherwise((Object)vecCol) : DatasetUtils$.MODULE$.checkNonNanVectors(vecCol);
            }
            Column validatedfeaturesCol = column;
            Dataset validated = dataset.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{validatedLabelCol.as("_validated_label_"), validatedWeightCol.as("_validated_weight_"), validatedfeaturesCol.as("_validated_features_")}));
            String string8 = this.$(this.modelType());
            String string9 = NaiveBayes$.MODULE$.Bernoulli();
            String string10 = string8;
            if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                bl = true;
            } else {
                String string11 = NaiveBayes$.MODULE$.Multinomial();
                String string12 = string8;
                if (!(string11 != null ? !string11.equals(string12) : string12 != null)) {
                    bl = true;
                } else {
                    String string13 = NaiveBayes$.MODULE$.Complement();
                    String string14 = string8;
                    bl = !(string13 != null ? !string13.equals(string14) : string14 != null);
                }
            }
            if (bl) {
                return this.trainDiscreteImpl((Dataset<?>)validated, (Instrumentation)instr);
            }
            String string15 = NaiveBayes$.MODULE$.Gaussian();
            String string16 = string8;
            if (!(string15 != null ? !string15.equals(string16) : string16 != null)) {
                return this.trainGaussianImpl((Dataset<?>)validated, (Instrumentation)instr);
            }
            throw new IllegalArgumentException("Invalid modelType: " + this.$(this.modelType()) + ".");
        });
    }

    private NaiveBayesModel trainDiscreteImpl(Dataset<?> dataset, Instrumentation instr) {
        boolean bl;
        Iterator iterator;
        boolean bl2;
        Object object;
        SparkSession spark = dataset.sparkSession();
        String[] stringArray = dataset.schema().fieldNames();
        if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 3) != 0) {
            throw new MatchError((Object)stringArray);
        }
        String label = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
        String weight = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
        String featuers = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2);
        Tuple3 tuple3 = new Tuple3((Object)label, (Object)weight, (Object)featuers);
        String label2 = (String)tuple3._1();
        String weight2 = (String)tuple3._2();
        String featuers2 = (String)tuple3._3();
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(NaiveBayes.class.getClassLoader());
        public final class Org_apache_spark_ml_classification_NaiveBayes$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_spark_ml_classification_NaiveBayes$$typecreator5$1(NaiveBayes $outer) {
            }
        }
        Tuple4[] aggregated = (Tuple4[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])dataset.groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(label2)})).agg(functions$.MODULE$.sum(functions$.MODULE$.col(weight2)).as("weightSum"), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Summarizer$.MODULE$.metrics((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sum", "count"})).summary(functions$.MODULE$.col(featuers2), functions$.MODULE$.col(weight2)).as("summary")})).select(label2, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"weightSum", "summary.sum", "summary.count"})).as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_NaiveBayes$$typecreator5$1(null)))).collect()), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToDouble((double)NaiveBayes.$anonfun$trainDiscreteImpl$1(x$3)), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
        int numFeatures = ((Vector)((Tuple4)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])aggregated)))._3()).size();
        instr.logNumFeatures(numFeatures);
        long numSamples = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])aggregated), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)NaiveBayes.$anonfun$trainDiscreteImpl$2(x$4)), (ClassTag)ClassTag$.MODULE$.Long())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        instr.logNumExamples(numSamples);
        int numLabels = aggregated.length;
        instr.logNumClasses(numLabels);
        double numDocuments = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])aggregated), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToDouble((double)NaiveBayes.$anonfun$trainDiscreteImpl$3(x$5)), (ClassTag)ClassTag$.MODULE$.Double())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        instr.logSumOfWeights(numDocuments);
        double[] labelArray = new double[numLabels];
        double[] piArray = new double[numLabels];
        double[] thetaArray = new double[numLabels * numFeatures];
        String string = this.$(this.modelType());
        String string2 = NaiveBayes$.MODULE$.Multinomial();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            bl2 = true;
        } else {
            String string4 = NaiveBayes$.MODULE$.Bernoulli();
            String string5 = string;
            bl2 = !(string4 != null ? !string4.equals(string5) : string5 != null);
        }
        if (bl2) {
            iterator = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])aggregated));
        } else {
            String string6 = NaiveBayes$.MODULE$.Complement();
            String string7 = string;
            if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                Vector featureSum = Vectors$.MODULE$.zeros(numFeatures);
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])aggregated), (Function1 & Serializable)x0$1 -> {
                    NaiveBayes.$anonfun$trainDiscreteImpl$4(featureSum, x0$1);
                    return BoxedUnit.UNIT;
                });
                iterator = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])aggregated)).map((Function1 & Serializable)x0$2 -> {
                    Tuple4 tuple4 = x0$2;
                    if (tuple4 != null) {
                        double label = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                        double n = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                        Vector sumTermFreqs = (Vector)tuple4._3();
                        long count = BoxesRunTime.unboxToLong((Object)tuple4._4());
                        Vector comp = featureSum.copy();
                        BLAS$.MODULE$.axpy(-1.0, sumTermFreqs, comp);
                        return new Tuple4((Object)BoxesRunTime.boxToDouble((double)label), (Object)BoxesRunTime.boxToDouble((double)n), (Object)comp, (Object)BoxesRunTime.boxToLong((long)count));
                    }
                    throw new MatchError((Object)tuple4);
                });
            } else {
                throw new MatchError((Object)string);
            }
        }
        Iterator aggIter = iterator;
        double lambda = BoxesRunTime.unboxToDouble((Object)this.$(this.smoothing()));
        double piLogDenom = scala.math.package$.MODULE$.log(numDocuments + (double)numLabels * lambda);
        IntRef i = IntRef.create((int)0);
        aggIter.foreach((Function1 & Serializable)x0$3 -> {
            NaiveBayes.$anonfun$trainDiscreteImpl$6(this, labelArray, i, piArray, lambda, piLogDenom, numFeatures, thetaArray, x0$3);
            return BoxedUnit.UNIT;
        });
        Vector pi = Vectors$.MODULE$.dense(piArray);
        String string8 = this.$(this.modelType());
        String string9 = NaiveBayes$.MODULE$.Multinomial();
        String string10 = string8;
        if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
            bl = true;
        } else {
            String string11 = NaiveBayes$.MODULE$.Bernoulli();
            String string12 = string8;
            bl = !(string11 != null ? !string11.equals(string12) : string12 != null);
        }
        if (bl) {
            DenseMatrix theta = new DenseMatrix(numLabels, numFeatures, thetaArray, true);
            return new NaiveBayesModel(this.uid(), pi.compressed(), theta.compressed(), Matrices$.MODULE$.zeros(0, 0)).setOldLabels(labelArray);
        }
        String string13 = NaiveBayes$.MODULE$.Complement();
        String string14 = string8;
        if (!(string13 != null ? !string13.equals(string14) : string14 != null)) {
            DenseMatrix theta = new DenseMatrix(numLabels, numFeatures, (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(thetaArray), (Function1)(JFunction1.mcDD.sp & Serializable)v -> -v, (ClassTag)ClassTag$.MODULE$.Double()), true);
            return new NaiveBayesModel(this.uid(), pi.compressed(), theta.compressed(), Matrices$.MODULE$.zeros(0, 0));
        }
        throw new MatchError((Object)string8);
    }

    private NaiveBayesModel trainGaussianImpl(Dataset<?> dataset, Instrumentation instr) {
        public final class Org_apache_spark_ml_classification_NaiveBayes$$typecreator10$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_spark_ml_classification_NaiveBayes$$typecreator10$1(NaiveBayes $outer) {
            }
        }
        Object object;
        SparkSession spark = dataset.sparkSession();
        String[] stringArray = dataset.schema().fieldNames();
        if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 3) != 0) {
            throw new MatchError((Object)stringArray);
        }
        String label = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
        String weight = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
        String featuers = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2);
        Tuple3 tuple3 = new Tuple3((Object)label, (Object)weight, (Object)featuers);
        String label2 = (String)tuple3._1();
        String weight2 = (String)tuple3._2();
        String featuers2 = (String)tuple3._3();
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(NaiveBayes.class.getClassLoader());
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(NaiveBayes.class.getClassLoader());
        public final class Org_apache_spark_ml_classification_NaiveBayes$$typecreator5$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_spark_ml_classification_NaiveBayes$$typecreator5$2(NaiveBayes $outer) {
            }
        }
        Tuple4[] aggregated = (Tuple4[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])dataset.groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(label2)})).agg(functions$.MODULE$.sum(functions$.MODULE$.col(weight2)).as("weightSum"), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Summarizer$.MODULE$.metrics((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mean", "normL2"})).summary(functions$.MODULE$.col(featuers2), functions$.MODULE$.col(weight2)).as("summary")})).select(label2, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"weightSum", "summary.mean", "summary.normL2"})).as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_NaiveBayes$$typecreator5$2(null)))).map((Function1 & Serializable)x0$1 -> {
            Tuple4 tuple4 = x0$1;
            if (tuple4 != null) {
                double label = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                double weightSum = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                Vector mean = (Vector)tuple4._3();
                Vector normL2 = (Vector)tuple4._4();
                return new Tuple4((Object)BoxesRunTime.boxToDouble((double)label), (Object)BoxesRunTime.boxToDouble((double)weightSum), (Object)mean, (Object)Vectors$.MODULE$.dense((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(normL2.toArray()), (Function1)(JFunction1.mcDD.sp & Serializable)v -> v * v, (ClassTag)ClassTag$.MODULE$.Double())));
            }
            throw new MatchError((Object)tuple4);
        }, spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_classification_NaiveBayes$$typecreator10$1(null)))).collect()), (Function1 & Serializable)x$7 -> BoxesRunTime.boxToDouble((double)NaiveBayes.$anonfun$trainGaussianImpl$3(x$7)), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
        int numFeatures = ((Vector)((Tuple4)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])aggregated)))._3()).size();
        instr.logNumFeatures(numFeatures);
        int numLabels = aggregated.length;
        instr.logNumClasses(numLabels);
        double numInstances = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])aggregated), (Function1 & Serializable)x$8 -> BoxesRunTime.boxToDouble((double)NaiveBayes.$anonfun$trainGaussianImpl$4(x$8)), (ClassTag)ClassTag$.MODULE$.Double())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        instr.logSumOfWeights(numInstances);
        double epsilon = BoxesRunTime.unboxToDouble((Object)package$.MODULE$.Iterator().range(0, numFeatures).map((Function1)(JFunction1.mcDI.sp & Serializable)j -> {
            DoubleRef globalSum = DoubleRef.create((double)0.0);
            DoubleRef globalSqrSum = DoubleRef.create((double)0.0);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])aggregated), (Function1 & Serializable)x0$2 -> {
                NaiveBayes.$anonfun$trainGaussianImpl$6(globalSum, j, globalSqrSum, x0$2);
                return BoxedUnit.UNIT;
            });
            return globalSqrSum.elem / numInstances - globalSum.elem * globalSum.elem / numInstances / numInstances;
        }).max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)) * 1.0E-9;
        double[] piArray = new double[numLabels];
        double[] thetaArray = new double[numLabels * numFeatures];
        double[] sigmaArray = new double[numLabels * numFeatures];
        IntRef i = IntRef.create((int)0);
        double logNumInstances = scala.math.package$.MODULE$.log(numInstances);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])aggregated), (Function1 & Serializable)x0$3 -> {
            NaiveBayes.$anonfun$trainGaussianImpl$7(piArray, i, logNumInstances, numFeatures, thetaArray, sigmaArray, epsilon, x0$3);
            return BoxedUnit.UNIT;
        });
        Vector pi = Vectors$.MODULE$.dense(piArray);
        DenseMatrix theta = new DenseMatrix(numLabels, numFeatures, thetaArray, true);
        DenseMatrix sigma = new DenseMatrix(numLabels, numFeatures, sigmaArray, true);
        return new NaiveBayesModel(this.uid(), pi.compressed(), theta.compressed(), sigma.compressed());
    }

    @Override
    public long estimateModelSize(Dataset<?> dataset) {
        boolean bl;
        int numClasses = DatasetUtils$.MODULE$.getNumClasses(dataset, this.$(this.labelCol()), DatasetUtils$.MODULE$.getNumClasses$default$3());
        int numFeatures = DatasetUtils$.MODULE$.getNumFeatures(dataset, this.$(this.featuresCol()));
        long size = this.estimateMatadataSize();
        size += Vectors$.MODULE$.getDenseSize((long)numClasses);
        size += Matrices$.MODULE$.getDenseSize((long)numClasses, (long)numFeatures);
        String string = this.$(this.modelType());
        String string2 = NaiveBayes$.MODULE$.Multinomial();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            bl = true;
        } else {
            String string4 = NaiveBayes$.MODULE$.Bernoulli();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                bl = true;
            } else {
                String string6 = NaiveBayes$.MODULE$.Complement();
                String string7 = string;
                bl = !(string6 != null ? !string6.equals(string7) : string7 != null);
            }
        }
        size = bl ? (size += Matrices$.MODULE$.getDenseSize(0L, 0L)) : (size += Matrices$.MODULE$.getDenseSize((long)numClasses, (long)numFeatures));
        return size;
    }

    @Override
    public NaiveBayes copy(ParamMap extra) {
        return (NaiveBayes)this.defaultCopy(extra);
    }

    public static final /* synthetic */ int $anonfun$trainWithLabelCheck$2(double[] x$1) {
        return x$1.length;
    }

    public static final /* synthetic */ double $anonfun$trainDiscreteImpl$1(Tuple4 x$3) {
        return BoxesRunTime.unboxToDouble((Object)x$3._1());
    }

    public static final /* synthetic */ long $anonfun$trainDiscreteImpl$2(Tuple4 x$4) {
        return BoxesRunTime.unboxToLong((Object)x$4._4());
    }

    public static final /* synthetic */ double $anonfun$trainDiscreteImpl$3(Tuple4 x$5) {
        return BoxesRunTime.unboxToDouble((Object)x$5._2());
    }

    public static final /* synthetic */ void $anonfun$trainDiscreteImpl$4(Vector featureSum$1, Tuple4 x0$1) {
        Tuple4 tuple4 = x0$1;
        if (tuple4 != null) {
            Vector sumTermFreqs = (Vector)tuple4._3();
            BLAS$.MODULE$.axpy(1.0, sumTermFreqs, featureSum$1);
            return;
        }
        throw new MatchError((Object)tuple4);
    }

    public static final /* synthetic */ void $anonfun$trainDiscreteImpl$6(NaiveBayes $this, double[] labelArray$1, IntRef i$1, double[] piArray$1, double lambda$1, double piLogDenom$1, int numFeatures$1, double[] thetaArray$1, Tuple4 x0$3) {
        Tuple4 tuple4 = x0$3;
        if (tuple4 != null) {
            double d;
            boolean bl;
            double label = BoxesRunTime.unboxToDouble((Object)tuple4._1());
            double n = BoxesRunTime.unboxToDouble((Object)tuple4._2());
            Vector sumTermFreqs = (Vector)tuple4._3();
            labelArray$1[i$1.elem] = label;
            piArray$1[i$1.elem] = scala.math.package$.MODULE$.log(n + lambda$1) - piLogDenom$1;
            String string = $this.$($this.modelType());
            String string2 = NaiveBayes$.MODULE$.Multinomial();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                bl = true;
            } else {
                String string4 = NaiveBayes$.MODULE$.Complement();
                String string5 = string;
                bl = !(string4 != null ? !string4.equals(string5) : string5 != null);
            }
            if (bl) {
                d = scala.math.package$.MODULE$.log(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(sumTermFreqs.toArray()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) + (double)numFeatures$1 * lambda$1);
            } else {
                String string6 = NaiveBayes$.MODULE$.Bernoulli();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    d = scala.math.package$.MODULE$.log(n + 2.0 * lambda$1);
                } else {
                    throw new MatchError((Object)string);
                }
            }
            double thetaLogDenom = d;
            int offset = i$1.elem * numFeatures$1;
            for (int j = 0; j < numFeatures$1; ++j) {
                thetaArray$1[offset + j] = scala.math.package$.MODULE$.log(sumTermFreqs.apply(j) + lambda$1) - thetaLogDenom;
            }
            ++i$1.elem;
            return;
        }
        throw new MatchError((Object)tuple4);
    }

    public static final /* synthetic */ double $anonfun$trainGaussianImpl$3(Tuple4 x$7) {
        return BoxesRunTime.unboxToDouble((Object)x$7._1());
    }

    public static final /* synthetic */ double $anonfun$trainGaussianImpl$4(Tuple4 x$8) {
        return BoxesRunTime.unboxToDouble((Object)x$8._2());
    }

    public static final /* synthetic */ void $anonfun$trainGaussianImpl$6(DoubleRef globalSum$1, int j$1, DoubleRef globalSqrSum$1, Tuple4 x0$2) {
        Tuple4 tuple4 = x0$2;
        if (tuple4 != null) {
            double weightSum = BoxesRunTime.unboxToDouble((Object)tuple4._2());
            Vector mean = (Vector)tuple4._3();
            Vector squareSum = (Vector)tuple4._4();
            globalSum$1.elem += mean.apply(j$1) * weightSum;
            globalSqrSum$1.elem += squareSum.apply(j$1);
            return;
        }
        throw new MatchError((Object)tuple4);
    }

    public static final /* synthetic */ void $anonfun$trainGaussianImpl$7(double[] piArray$2, IntRef i$2, double logNumInstances$1, int numFeatures$2, double[] thetaArray$2, double[] sigmaArray$1, double epsilon$1, Tuple4 x0$3) {
        Tuple4 tuple4 = x0$3;
        if (tuple4 != null) {
            double weightSum = BoxesRunTime.unboxToDouble((Object)tuple4._2());
            Vector mean = (Vector)tuple4._3();
            Vector squareSum = (Vector)tuple4._4();
            piArray$2[i$2.elem] = scala.math.package$.MODULE$.log(weightSum) - logNumInstances$1;
            int offset = i$2.elem * numFeatures$2;
            for (int j = 0; j < numFeatures$2; ++j) {
                double m;
                thetaArray$2[offset + j] = m = mean.apply(j);
                sigmaArray$1[offset + j] = epsilon$1 + squareSum.apply(j) / weightSum - m * m;
            }
            ++i$2.elem;
            return;
        }
        throw new MatchError((Object)tuple4);
    }

    public NaiveBayes(String uid) {
        this.uid = uid;
        HasWeightCol.$init$(this);
        NaiveBayesParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        Statics.releaseFence();
    }

    public NaiveBayes() {
        this(Identifiable$.MODULE$.randomUID("nb"));
    }
}

