/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import java.util.HashSet;
import org.apache.spark.sql.catalyst.analysis.GetViewColumnByNameAndOrdinal;
import org.apache.spark.sql.catalyst.analysis.MultiInstanceRelation;
import org.apache.spark.sql.catalyst.analysis.ResolvedInlineTable;
import org.apache.spark.sql.catalyst.analysis.SchemaBinding$;
import org.apache.spark.sql.catalyst.analysis.ViewSchemaMode;
import org.apache.spark.sql.catalyst.analysis.resolver.AttributeScopeStack;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionIdAssigner$;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionResolutionValidator;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.CTERelationDef;
import org.apache.spark.sql.catalyst.plans.logical.CTERelationRef;
import org.apache.spark.sql.catalyst.plans.logical.Distinct;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.GlobalLimit;
import org.apache.spark.sql.catalyst.plans.logical.LocalLimit;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OneRowRelation;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.catalyst.plans.logical.Union;
import org.apache.spark.sql.catalyst.plans.logical.View;
import org.apache.spark.sql.catalyst.plans.logical.WithCTE;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Ug\u0001\u0002\u000f\u001e\u00011BQa\r\u0001\u0005\u0002QBqa\u000e\u0001C\u0002\u0013%\u0001\b\u0003\u0004=\u0001\u0001\u0006I!\u000f\u0005\t{\u0001\u0001\r\u0011\"\u0001\u001e}!A!\t\u0001a\u0001\n\u0003i2\t\u0003\u0004J\u0001\u0001\u0006Ka\u0010\u0005\b\u0015\u0002\u0011\r\u0011\"\u0003L\u0011\u00199\u0006\u0001)A\u0005\u0019\")\u0001\f\u0001C\u00013\")A\r\u0001C\u0005K\")\u0001\u000e\u0001C\u0005S\")q\u000e\u0001C\u0005a\")a\u000f\u0001C\u0005o\")Q\u0010\u0001C\u0005}\"9\u0011\u0011\u0002\u0001\u0005\n\u0005-\u0001bBA\f\u0001\u0011%\u0011\u0011\u0004\u0005\b\u0003K\u0001A\u0011BA\u0014\u0011\u001d\t\u0019\u0004\u0001C\u0005\u0003kAq!!\u0011\u0001\t\u0013\t\u0019\u0005C\u0004\u0002P\u0001!I!!\u0015\t\u000f\u0005u\u0003\u0001\"\u0003\u0002`!9\u00111\u000e\u0001\u0005\n\u00055\u0004bBA>\u0001\u0011%\u0011Q\u0010\u0005\b\u0003\u0007\u0003A\u0011BAC\u0011\u001d\t\t\n\u0001C\u0005\u0003'Cq!a&\u0001\t\u0013\tI\nC\u0004\u0002,\u0002!I!!,\u0003'I+7o\u001c7vi&|gNV1mS\u0012\fGo\u001c:\u000b\u0005yy\u0012\u0001\u0003:fg>dg/\u001a:\u000b\u0005\u0001\n\u0013\u0001C1oC2L8/[:\u000b\u0005\t\u001a\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0011*\u0013aA:rY*\u0011aeJ\u0001\u0006gB\f'o\u001b\u0006\u0003Q%\na!\u00199bG\",'\"\u0001\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001i\u0003C\u0001\u00182\u001b\u0005y#\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002kA\u0011a\u0007A\u0007\u0002;\u0005iR\r\u001f9sKN\u001c\u0018n\u001c8SKN|G.\u001e;j_:4\u0016\r\\5eCR|'/F\u0001:!\t1$(\u0003\u0002<;\tiR\t\u001f9sKN\u001c\u0018n\u001c8SKN|G.\u001e;j_:4\u0016\r\\5eCR|'/\u0001\u0010fqB\u0014Xm]:j_:\u0014Vm]8mkRLwN\u001c,bY&$\u0017\r^8sA\u0005\u0019\u0012\r\u001e;sS\n,H/Z*d_B,7\u000b^1dWV\tq\b\u0005\u00027\u0001&\u0011\u0011)\b\u0002\u0014\u0003R$(/\u001b2vi\u0016\u001c6m\u001c9f'R\f7m[\u0001\u0018CR$(/\u001b2vi\u0016\u001c6m\u001c9f'R\f7m[0%KF$\"\u0001R$\u0011\u00059*\u0015B\u0001$0\u0005\u0011)f.\u001b;\t\u000f!+\u0011\u0011!a\u0001\u007f\u0005\u0019\u0001\u0010J\u0019\u0002)\u0005$HO]5ckR,7kY8qKN#\u0018mY6!\u0003E\u0019G/\u001a*fY\u0006$\u0018n\u001c8EK\u001aLEm]\u000b\u0002\u0019B\u0019QJ\u0015+\u000e\u00039S!a\u0014)\u0002\tU$\u0018\u000e\u001c\u0006\u0002#\u0006!!.\u0019<b\u0013\t\u0019fJA\u0004ICND7+\u001a;\u0011\u00059*\u0016B\u0001,0\u0005\u0011auN\\4\u0002%\r$XMU3mCRLwN\u001c#fM&#7\u000fI\u0001\rm\u0006d\u0017\u000eZ1uKBc\u0017M\u001c\u000b\u0003\tjCQaW\u0005A\u0002q\u000bA\u0001\u001d7b]B\u0011QLY\u0007\u0002=*\u0011q\fY\u0001\bY><\u0017nY1m\u0015\t\t\u0017%A\u0003qY\u0006t7/\u0003\u0002d=\nYAj\\4jG\u0006d\u0007\u000b\\1o\u0003!1\u0018\r\\5eCR,GC\u0001#g\u0011\u00159'\u00021\u0001]\u0003!y\u0007/\u001a:bi>\u0014\u0018\u0001\u0004<bY&$\u0017\r^3XSRDGC\u0001#k\u0011\u0015Y7\u00021\u0001m\u0003\u001d9\u0018\u000e\u001e5Di\u0016\u0004\"!X7\n\u00059t&aB,ji\"\u001cE+R\u0001\u0017m\u0006d\u0017\u000eZ1uK\u000e#XMU3mCRLwN\u001c#fMR\u0011A)\u001d\u0005\u0006e2\u0001\ra]\u0001\u000fGR,'+\u001a7bi&|g\u000eR3g!\tiF/\u0003\u0002v=\nq1\tV#SK2\fG/[8o\t\u00164\u0017A\u0006<bY&$\u0017\r^3Di\u0016\u0014V\r\\1uS>t'+\u001a4\u0015\u0005\u0011C\b\"B=\u000e\u0001\u0004Q\u0018AD2uKJ+G.\u0019;j_:\u0014VM\u001a\t\u0003;nL!\u0001 0\u0003\u001d\r#VIU3mCRLwN\u001c*fM\u0006\tb/\u00197jI\u0006$X-Q4he\u0016<\u0017\r^3\u0015\u0005\u0011{\bbBA\u0001\u001d\u0001\u0007\u00111A\u0001\nC\u001e<'/Z4bi\u0016\u00042!XA\u0003\u0013\r\t9A\u0018\u0002\n\u0003\u001e<'/Z4bi\u0016\fqB^1mS\u0012\fG/\u001a)s_*,7\r\u001e\u000b\u0004\t\u00065\u0001bBA\b\u001f\u0001\u0007\u0011\u0011C\u0001\baJ|'.Z2u!\ri\u00161C\u0005\u0004\u0003+q&a\u0002)s_*,7\r^\u0001\u000fm\u0006d\u0017\u000eZ1uK\u001aKG\u000e^3s)\r!\u00151\u0004\u0005\b\u0003;\u0001\u0002\u0019AA\u0010\u0003\u00191\u0017\u000e\u001c;feB\u0019Q,!\t\n\u0007\u0005\rbL\u0001\u0004GS2$XM]\u0001\u0016m\u0006d\u0017\u000eZ1uKN+(-];fef\fE.[1t)\r!\u0015\u0011\u0006\u0005\b\u0003W\t\u0002\u0019AA\u0017\u00035\u0019XOY9vKJL\u0018\t\\5bgB\u0019Q,a\f\n\u0007\u0005EbLA\u0007Tk\n\fX/\u001a:z\u00032L\u0017m]\u0001\rm\u0006d\u0017\u000eZ1uKZKWm\u001e\u000b\u0004\t\u0006]\u0002bBA\u001d%\u0001\u0007\u00111H\u0001\u0005m&,w\u000fE\u0002^\u0003{I1!a\u0010_\u0005\u00111\u0016.Z<\u0002'Y\fG.\u001b3bi\u0016<En\u001c2bY2KW.\u001b;\u0015\u0007\u0011\u000b)\u0005C\u0004\u0002HM\u0001\r!!\u0013\u0002\u0017\u001ddwNY1m\u0019&l\u0017\u000e\u001e\t\u0004;\u0006-\u0013bAA'=\nYq\t\\8cC2d\u0015.\\5u\u0003I1\u0018\r\\5eCR,Gj\\2bY2KW.\u001b;\u0015\u0007\u0011\u000b\u0019\u0006C\u0004\u0002VQ\u0001\r!a\u0016\u0002\u00151|7-\u00197MS6LG\u000fE\u0002^\u00033J1!a\u0017_\u0005)aunY1m\u0019&l\u0017\u000e^\u0001\u0011m\u0006d\u0017\u000eZ1uK\u0012K7\u000f^5oGR$2\u0001RA1\u0011\u001d\t\u0019'\u0006a\u0001\u0003K\n\u0001\u0002Z5ti&t7\r\u001e\t\u0004;\u0006\u001d\u0014bAA5=\nAA)[:uS:\u001cG/A\nwC2LG-\u0019;f\u0013:d\u0017N\\3UC\ndW\rF\u0002E\u0003_Bq!!\u001d\u0017\u0001\u0004\t\u0019(A\u0006j]2Lg.\u001a+bE2,\u0007\u0003BA;\u0003oj\u0011aH\u0005\u0004\u0003sz\"a\u0005*fg>dg/\u001a3J]2Lg.\u001a+bE2,\u0017\u0001\u0005<bY&$\u0017\r^3SK2\fG/[8o)\r!\u0015q\u0010\u0005\u0007\u0003\u0003;\u0002\u0019\u0001/\u0002\u0011I,G.\u0019;j_:\fQB^1mS\u0012\fG/Z+oS>tGc\u0001#\u0002\b\"9\u0011\u0011\u0012\rA\u0002\u0005-\u0015!B;oS>t\u0007cA/\u0002\u000e&\u0019\u0011q\u00120\u0003\u000bUs\u0017n\u001c8\u0002)!\fg\u000e\u001a7f\u001fB,'/\u0019;pe>+H\u000f];u)\r!\u0015Q\u0013\u0005\u0006Of\u0001\r\u0001X\u0001\u001bg\u000eDW-\\1XSRDW\t\u001f9mS\u000eLG/T3uC\u0012\fG/\u0019\u000b\u0005\u00037\u000b9\u000b\u0005\u0003\u0002\u001e\u0006\rVBAAP\u0015\r\t\tkI\u0001\u0006if\u0004Xm]\u0005\u0005\u0003K\u000byJ\u0001\u0006TiJ,8\r\u001e+za\u0016Dq!!+\u001b\u0001\u0004\tY*\u0001\u0004tG\",W.Y\u0001\u000boJ\f\u0007/\u0012:s_J\u001cX\u0003BAX\u0003\u0003$B!!-\u0002TR\u0019A)a-\t\u0011\u0005U6\u0004\"a\u0001\u0003o\u000bAAY8esB)a&!/\u0002>&\u0019\u00111X\u0018\u0003\u0011q\u0012\u0017P\\1nKz\u0002B!a0\u0002B2\u0001AaBAb7\t\u0007\u0011Q\u0019\u0002\u0002%F!\u0011qYAg!\rq\u0013\u0011Z\u0005\u0004\u0003\u0017|#a\u0002(pi\"Lgn\u001a\t\u0004]\u0005=\u0017bAAi_\t\u0019\u0011I\\=\t\u000bm[\u0002\u0019\u0001/")
public class ResolutionValidator {
    private final ExpressionResolutionValidator expressionResolutionValidator = new ExpressionResolutionValidator(this);
    private AttributeScopeStack attributeScopeStack = new AttributeScopeStack();
    private final HashSet<Object> cteRelationDefIds = new HashSet();

    private ExpressionResolutionValidator expressionResolutionValidator() {
        return this.expressionResolutionValidator;
    }

    public AttributeScopeStack attributeScopeStack() {
        return this.attributeScopeStack;
    }

    public void attributeScopeStack_$eq(AttributeScopeStack x$1) {
        this.attributeScopeStack = x$1;
    }

    private HashSet<Object> cteRelationDefIds() {
        return this.cteRelationDefIds;
    }

    public void validatePlan(LogicalPlan plan2) {
        this.wrapErrors(plan2, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.validate(plan2));
    }

    private void validate(LogicalPlan operator) {
        LogicalPlan logicalPlan = operator;
        if (logicalPlan instanceof WithCTE) {
            WithCTE withCTE = (WithCTE)logicalPlan;
            this.validateWith(withCTE);
        } else if (logicalPlan instanceof CTERelationDef) {
            CTERelationDef cTERelationDef = (CTERelationDef)logicalPlan;
            this.validateCteRelationDef(cTERelationDef);
        } else if (logicalPlan instanceof CTERelationRef) {
            CTERelationRef cTERelationRef = (CTERelationRef)logicalPlan;
            this.validateCteRelationRef(cTERelationRef);
        } else if (logicalPlan instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)logicalPlan;
            this.validateAggregate(aggregate);
        } else if (logicalPlan instanceof Project) {
            Project project = (Project)logicalPlan;
            this.validateProject(project);
        } else if (logicalPlan instanceof Filter) {
            Filter filter = (Filter)logicalPlan;
            this.validateFilter(filter);
        } else if (logicalPlan instanceof SubqueryAlias) {
            SubqueryAlias subqueryAlias = (SubqueryAlias)logicalPlan;
            this.validateSubqueryAlias(subqueryAlias);
        } else if (logicalPlan instanceof View) {
            View view = (View)logicalPlan;
            this.validateView(view);
        } else if (logicalPlan instanceof GlobalLimit) {
            GlobalLimit globalLimit = (GlobalLimit)logicalPlan;
            this.validateGlobalLimit(globalLimit);
        } else if (logicalPlan instanceof LocalLimit) {
            LocalLimit localLimit = (LocalLimit)logicalPlan;
            this.validateLocalLimit(localLimit);
        } else if (logicalPlan instanceof Distinct) {
            Distinct distinct = (Distinct)logicalPlan;
            this.validateDistinct(distinct);
        } else if (logicalPlan instanceof ResolvedInlineTable) {
            ResolvedInlineTable resolvedInlineTable = (ResolvedInlineTable)logicalPlan;
            this.validateInlineTable(resolvedInlineTable);
        } else if (logicalPlan instanceof LocalRelation) {
            LocalRelation localRelation = (LocalRelation)logicalPlan;
            this.validateRelation(localRelation);
        } else if (logicalPlan instanceof OneRowRelation) {
            OneRowRelation oneRowRelation = (OneRowRelation)logicalPlan;
            this.validateRelation(oneRowRelation);
        } else if (logicalPlan instanceof Union) {
            Union union = (Union)logicalPlan;
            this.validateUnion(union);
        } else if (logicalPlan instanceof MultiInstanceRelation) {
            LogicalPlan logicalPlan2 = logicalPlan;
            this.validateRelation(logicalPlan2);
        } else {
            throw new MatchError((Object)logicalPlan);
        }
        ExpressionIdAssigner$.MODULE$.assertOutputsHaveNoConflictingExpressionIds((Seq<Seq<Attribute>>)((Seq)operator.children().map((Function1 & Serializable)x$1 -> x$1.output())));
    }

    private void validateWith(WithCTE withCte) {
        withCte.cteDefs().foreach((Function1 & Serializable)cteDef -> {
            this.validate(cteDef);
            return BoxedUnit.UNIT;
        });
        this.validate(withCte.plan());
    }

    private void validateCteRelationDef(CTERelationDef cteRelationDef) {
        this.validate(cteRelationDef.child());
        Predef$.MODULE$.assert(!this.cteRelationDefIds().contains(BoxesRunTime.boxToLong((long)cteRelationDef.id())), (Function0 & Serializable)() -> "Duplicate CTE relation def ID: " + cteRelationDef);
        this.cteRelationDefIds().add(BoxesRunTime.boxToLong((long)cteRelationDef.id()));
    }

    private void validateCteRelationRef(CTERelationRef cteRelationRef) {
        Predef$.MODULE$.assert(this.cteRelationDefIds().contains(BoxesRunTime.boxToLong((long)cteRelationRef.cteId())), (Function0 & Serializable)() -> "CTE relation ref ID is not known: " + cteRelationRef);
        this.handleOperatorOutput(cteRelationRef);
    }

    private void validateAggregate(Aggregate aggregate) {
        this.attributeScopeStack().withNewScope((JFunction0.mcV.sp & Serializable)() -> {
            this.validate(aggregate.child());
            this.expressionResolutionValidator().validateProjectList(aggregate.aggregateExpressions());
        });
        this.handleOperatorOutput(aggregate);
    }

    private void validateProject(Project project) {
        this.attributeScopeStack().withNewScope((JFunction0.mcV.sp & Serializable)() -> {
            this.validate(project.child());
            this.expressionResolutionValidator().validateProjectList(project.projectList());
        });
        this.handleOperatorOutput(project);
    }

    private void validateFilter(Filter filter) {
        this.validate(filter.child());
        DataType dataType = filter.condition().dataType();
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        Predef$.MODULE$.assert(!(dataType != null ? !dataType.equals(booleanType$) : booleanType$ != null), (Function0 & Serializable)() -> "Output type of a filter must be a boolean, but got: " + filter.condition().dataType().typeName());
        this.expressionResolutionValidator().validate(filter.condition());
    }

    private void validateSubqueryAlias(SubqueryAlias subqueryAlias) {
        this.validate(subqueryAlias.child());
        this.handleOperatorOutput(subqueryAlias);
    }

    private void validateView(View view) {
        LogicalPlan logicalPlan;
        this.validate(view.child());
        ViewSchemaMode viewSchemaMode = view.desc().viewSchemaMode();
        SchemaBinding$ schemaBinding$ = SchemaBinding$.MODULE$;
        if (!(viewSchemaMode != null ? !viewSchemaMode.equals(schemaBinding$) : schemaBinding$ != null)) {
            StructType structType = this.schemaWithExplicitMetadata(view.schema());
            StructType structType2 = this.schemaWithExplicitMetadata(view.desc().schema());
            Predef$.MODULE$.assert(!(structType != null ? !structType.equals(structType2) : structType2 != null), (Function0 & Serializable)() -> "View output schema does not match the view description schema. View schema: " + view.schema() + ", description schema: " + view.desc().schema());
        }
        if ((logicalPlan = view.child()) instanceof Project) {
            Project project = (Project)logicalPlan;
            Predef$.MODULE$.assert(!project.projectList().exists((Function1 & Serializable)expression -> BoxesRunTime.boxToBoolean((boolean)ResolutionValidator.$anonfun$validateView$2(expression))), (Function0 & Serializable)() -> "Resolved Project operator under a view cannot contain GetViewColumnByNameAndOrdinal");
        }
        this.handleOperatorOutput(view);
    }

    private void validateGlobalLimit(GlobalLimit globalLimit) {
        this.validate(globalLimit.child());
        this.expressionResolutionValidator().validate(globalLimit.limitExpr());
    }

    private void validateLocalLimit(LocalLimit localLimit) {
        this.validate(localLimit.child());
        this.expressionResolutionValidator().validate(localLimit.limitExpr());
    }

    private void validateDistinct(Distinct distinct) {
        this.validate(distinct.child());
    }

    private void validateInlineTable(ResolvedInlineTable inlineTable) {
        inlineTable.rows().foreach((Function1 & Serializable)row -> {
            row.foreach((Function1 & Serializable)expression -> {
                ResolutionValidator.$anonfun$validateInlineTable$2($this, expression);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.handleOperatorOutput(inlineTable);
    }

    private void validateRelation(LogicalPlan relation) {
        this.handleOperatorOutput(relation);
    }

    private void validateUnion(Union union) {
        union.children().foreach((Function1 & Serializable)operator -> {
            this.validate(operator);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(union.children().length() > 1, (Function0 & Serializable)() -> "Union operator has to have at least 2 children");
        Seq<Attribute> firstChildOutput = ((QueryPlan)union.children().head()).output();
        ((IterableOnceOps)union.children().tail()).foreach((Function1 & Serializable)child -> {
            ResolutionValidator.$anonfun$validateUnion$3(firstChildOutput, child);
            return BoxedUnit.UNIT;
        });
        this.handleOperatorOutput(union);
    }

    private void handleOperatorOutput(LogicalPlan operator) {
        this.attributeScopeStack().overwriteTop(operator.output());
        operator.output().foreach((Function1 & Serializable)attribute -> {
            ResolutionValidator.$anonfun$handleOperatorOutput$1(this, attribute);
            return BoxedUnit.UNIT;
        });
    }

    private StructType schemaWithExplicitMetadata(StructType schema) {
        return StructType$.MODULE$.apply((Seq)schema.map((Function1 & Serializable)structField -> {
            MetadataBuilder metadataBuilder = new MetadataBuilder().withMetadata(structField.metadata());
            metadataBuilder.remove(package$.MODULE$.AUTO_GENERATED_ALIAS());
            Metadata x$1 = metadataBuilder.build();
            String x$2 = structField.copy$default$1();
            DataType x$3 = structField.copy$default$2();
            boolean x$4 = structField.copy$default$3();
            return structField.copy(x$2, x$3, x$4, x$1);
        }));
    }

    private <R> void wrapErrors(LogicalPlan plan2, Function0<R> body) {
        try {
            body.apply();
        }
        catch (Throwable ex) {
            throw QueryCompilationErrors$.MODULE$.resolutionValidationError(ex, plan2);
        }
    }

    public static final /* synthetic */ boolean $anonfun$validateView$2(NamedExpression expression) {
        return expression instanceof GetViewColumnByNameAndOrdinal;
    }

    public static final /* synthetic */ void $anonfun$validateInlineTable$2(ResolutionValidator $this, Expression expression) {
        $this.expressionResolutionValidator().validate(expression);
    }

    public static final /* synthetic */ void $anonfun$validateUnion$5(LogicalPlan child$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Attribute current = (Attribute)tuple2._1();
            Attribute first = (Attribute)tuple2._2();
            Predef$.MODULE$.assert(DataType$.MODULE$.equalsStructurally(current.dataType(), first.dataType(), true), (Function0 & Serializable)() -> "Unexpected type of Union child attribute " + current + " for " + child$1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$validateUnion$3(Seq firstChildOutput$1, LogicalPlan child) {
        Seq<Attribute> childOutput = child.output();
        Predef$.MODULE$.assert(childOutput.length() == firstChildOutput$1.length(), (Function0 & Serializable)() -> "Unexpected output length for Union child " + child);
        ((IterableOnceOps)childOutput.zip((IterableOnce)firstChildOutput$1)).foreach((Function1 & Serializable)x0$1 -> {
            ResolutionValidator.$anonfun$validateUnion$5(child, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$handleOperatorOutput$1(ResolutionValidator $this, Attribute attribute) {
        Predef$.MODULE$.assert(attribute instanceof AttributeReference, (Function0 & Serializable)() -> "Output of an operator must be a reference to an attribute, but got: " + attribute.getClass().getSimpleName());
        $this.expressionResolutionValidator().validate(attribute);
    }
}

