/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.io.Serializable;
import java.util.UUID;
import org.apache.spark.SparkSQLException;
import org.apache.spark.connect.proto.ExecutePlanRequest;
import org.apache.spark.sql.connect.service.ExecuteKey;
import org.apache.spark.sql.connect.service.SessionHolder;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class ExecuteKey$
implements Serializable {
    public static final ExecuteKey$ MODULE$ = new ExecuteKey$();

    public ExecuteKey apply(ExecutePlanRequest request, SessionHolder sessionHolder) {
        String string;
        if (request.hasOperationId()) {
            try {
                string = UUID.fromString(request.getOperationId()).toString();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SparkSQLException("INVALID_HANDLE.FORMAT", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)request.getOperationId())})));
            }
        } else {
            string = UUID.randomUUID().toString();
        }
        String operationId = string;
        return new ExecuteKey(sessionHolder.userId(), sessionHolder.sessionId(), operationId);
    }

    public ExecuteKey apply(String userId, String sessionId, String operationId) {
        return new ExecuteKey(userId, sessionId, operationId);
    }

    public Option<Tuple3<String, String, String>> unapply(ExecuteKey x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)x$0.userId(), (Object)x$0.sessionId(), (Object)x$0.operationId()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ExecuteKey$.class);
    }

    private ExecuteKey$() {
    }
}

