/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.ApplyCharTypePaddingHelper$;
import org.apache.spark.sql.catalyst.analysis.resolver.ExplicitlyUnsupportedResolverFeature;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.PredicateResolver$;
import org.apache.spark.sql.catalyst.analysis.resolver.ResolvesExpressionChildren;
import org.apache.spark.sql.catalyst.analysis.resolver.TimezoneAwareExpressionResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.TreeNodeResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.TypeCoercionResolver;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.StringRPad;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005!4A\u0001E\t\u0001A!Aq\u0007\u0001B\u0001B\u0003%\u0001\b\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u001d!\u0005A1A\u0005\n\u0015Ca!\u0016\u0001!\u0002\u00131\u0005b\u0002,\u0001\u0005\u0004%Ia\u0016\u0005\u00077\u0002\u0001\u000b\u0011\u0002-\t\u000bq\u0003A\u0011I/\b\u000b\u0001\f\u0002\u0012A1\u0007\u000bA\t\u0002\u0012\u00012\t\u000b}RA\u0011A2\t\u000f\u0011T!\u0019!C\u0005\u000b\"1QM\u0003Q\u0001\n\u0019CqA\u001a\u0006C\u0002\u0013%Q\t\u0003\u0004h\u0015\u0001\u0006IA\u0012\u0002\u0012!J,G-[2bi\u0016\u0014Vm]8mm\u0016\u0014(B\u0001\n\u0014\u0003!\u0011Xm]8mm\u0016\u0014(B\u0001\u000b\u0016\u0003!\tg.\u00197zg&\u001c(B\u0001\f\u0018\u0003!\u0019\u0017\r^1msN$(B\u0001\r\u001a\u0003\r\u0019\u0018\u000f\u001c\u0006\u00035m\tQa\u001d9be.T!\u0001H\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0012aA8sO\u000e\u00011\u0003\u0002\u0001\"OQ\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0007\u0003\u0002\u0015*WEj\u0011!E\u0005\u0003UE\u0011\u0001\u0003\u0016:fK:{G-\u001a*fg>dg/\u001a:\u0011\u00051zS\"A\u0017\u000b\u00059*\u0012aC3yaJ,7o]5p]NL!\u0001M\u0017\u0003\u0013A\u0013X\rZ5dCR,\u0007C\u0001\u00173\u0013\t\u0019TF\u0001\u0006FqB\u0014Xm]:j_:\u0004\"\u0001K\u001b\n\u0005Y\n\"A\u0007*fg>dg/Z:FqB\u0014Xm]:j_:\u001c\u0005.\u001b7ee\u0016t\u0017AE3yaJ,7o]5p]J+7o\u001c7wKJ\u0004\"\u0001K\u001d\n\u0005i\n\"AE#yaJ,7o]5p]J+7o\u001c7wKJ\fq\u0004^5nKj|g.Z!xCJ,W\t\u001f9sKN\u001c\u0018n\u001c8SKN|GN^3s!\tAS(\u0003\u0002?#\tyB+[7fu>tW-Q<be\u0016,\u0005\u0010\u001d:fgNLwN\u001c*fg>dg/\u001a:\u0002\rqJg.\u001b;?)\r\t%i\u0011\t\u0003Q\u0001AQaN\u0002A\u0002aBQaO\u0002A\u0002q\n1\u0004^=qK\u000e{WM]2j_:$&/\u00198tM>\u0014X.\u0019;j_:\u001cX#\u0001$\u0011\u0007\u001d{%K\u0004\u0002I\u001b:\u0011\u0011\nT\u0007\u0002\u0015*\u00111jH\u0001\u0007yI|w\u000e\u001e \n\u0003\u0011J!AT\u0012\u0002\u000fA\f7m[1hK&\u0011\u0001+\u0015\u0002\u0004'\u0016\f(B\u0001($!\u0011\u00113+M\u0019\n\u0005Q\u001b#!\u0003$v]\u000e$\u0018n\u001c82\u0003q!\u0018\u0010]3D_\u0016\u00148-[8o)J\fgn\u001d4pe6\fG/[8og\u0002\nA\u0003^=qK\u000e{WM]2j_:\u0014Vm]8mm\u0016\u0014X#\u0001-\u0011\u0005!J\u0016B\u0001.\u0012\u0005Q!\u0016\u0010]3D_\u0016\u00148-[8o%\u0016\u001cx\u000e\u001c<fe\u0006)B/\u001f9f\u0007>,'oY5p]J+7o\u001c7wKJ\u0004\u0013a\u0002:fg>dg/\u001a\u000b\u0003cyCQa\u0018\u0005A\u0002-\n1#\u001e8sKN|GN^3e!J,G-[2bi\u0016\f\u0011\u0003\u0015:fI&\u001c\u0017\r^3SKN|GN^3s!\tA#b\u0005\u0002\u000bCQ\t\u0011-A\u000fU3B+ulQ(F%\u000eKuJT0U%\u0006s5KR(S\u001b\u0006#\u0016j\u0014(T\u0003y!\u0016\fU#`\u0007>+%kQ%P\u001d~#&+\u0011(T\r>\u0013V*\u0011+J\u001f:\u001b\u0006%\u0001\u0012B\u001dNKu\fV-Q\u000b~\u001bu*\u0012*D\u0013>su\f\u0016*B\u001dN3uJU'B)&{ejU\u0001$\u0003:\u001b\u0016j\u0018+Z!\u0016{6iT#S\u0007&{ej\u0018+S\u0003:\u001bfi\u0014*N\u0003RKuJT*!\u0001")
public class PredicateResolver
implements TreeNodeResolver<Predicate, Expression>,
ResolvesExpressionChildren {
    private final ExpressionResolver expressionResolver;
    private final Seq<Function1<Expression, Expression>> typeCoercionTransformations;
    private final TypeCoercionResolver typeCoercionResolver;

    @Override
    public <ExpressionType extends Expression> ExpressionType withResolvedChildren(ExpressionType unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return (ExpressionType)ResolvesExpressionChildren.withResolvedChildren$(this, unresolvedExpression, resolveChild);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    private Seq<Function1<Expression, Expression>> typeCoercionTransformations() {
        return this.typeCoercionTransformations;
    }

    private TypeCoercionResolver typeCoercionResolver() {
        return this.typeCoercionResolver;
    }

    @Override
    public Expression resolve(Predicate unresolvedPredicate) {
        Predicate predicateWithResolvedChildren = (Predicate)((Object)this.withResolvedChildren((Expression)((Object)unresolvedPredicate), (Function1<Expression, Expression>)(Function1 & Serializable)unresolvedExpression -> $this.expressionResolver.resolve((Expression)unresolvedExpression)));
        Expression predicateWithTypeCoercion = this.typeCoercionResolver().resolve((Expression)((Object)predicateWithResolvedChildren));
        Expression predicateWithCharTypePadding = ApplyCharTypePaddingHelper$.MODULE$.singleNodePaddingForStringComparison(predicateWithTypeCoercion, !BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(SQLConf$.MODULE$.LEGACY_NO_CHAR_PADDING_IN_PREDICATE())));
        Option option = predicateWithCharTypePadding.children().collectFirst((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof StringRPad) {
                    StringRPad stringRPad = (StringRPad)A1;
                    return (B1)stringRPad;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                return expression instanceof StringRPad;
            }
        });
        if (option instanceof Some) {
            throw new ExplicitlyUnsupportedResolverFeature("CharTypePaddingAliasing");
        }
        return predicateWithCharTypePadding;
    }

    public PredicateResolver(ExpressionResolver expressionResolver, TimezoneAwareExpressionResolver timezoneAwareExpressionResolver) {
        this.expressionResolver = expressionResolver;
        SQLConfHelper.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        ResolvesExpressionChildren.$init$(this);
        this.typeCoercionTransformations = this.conf().ansiEnabled() ? PredicateResolver$.MODULE$.org$apache$spark$sql$catalyst$analysis$resolver$PredicateResolver$$ANSI_TYPE_COERCION_TRANSFORMATIONS() : PredicateResolver$.MODULE$.org$apache$spark$sql$catalyst$analysis$resolver$PredicateResolver$$TYPE_COERCION_TRANSFORMATIONS();
        this.typeCoercionResolver = new TypeCoercionResolver(timezoneAwareExpressionResolver, this.typeCoercionTransformations());
    }
}

