/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.v2.TableSampleInfo;
import org.apache.spark.sql.jdbc.DatabricksDialect$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.NoLegacyJDBCError;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005Mg\u0001\u0002\u0010 \t*BQ\u0001\u0012\u0001\u0005\u0002\u0015CQa\u0012\u0001\u0005B!CQA\u0016\u0001\u0005B]CQa\u001c\u0001\u0005BADQa\u001e\u0001\u0005BaDQa\u001f\u0001\u0005BqDQ! \u0001\u0005BqDQA \u0001\u0005BqDaa \u0001\u0005B\u0005\u0005\u0001BBA\u000e\u0001\u0011\u0005C\u0010C\u0004\u0002\u001e\u0001!\t%a\b\t\u000f\u0005\u0015\u0003\u0001\"\u0011\u0002H!A\u0011Q\u000b\u0001\u0002\u0002\u0013\u0005Q\tC\u0005\u0002X\u0001\t\t\u0011\"\u0011\u0002Z!I\u0011Q\r\u0001\u0002\u0002\u0013\u0005\u0011q\r\u0005\n\u0003S\u0002\u0011\u0011!C\u0001\u0003WB\u0011\"a\u001e\u0001\u0003\u0003%\t%!\u001f\t\u0013\u0005\u001d\u0005!!A\u0005\u0002\u0005%\u0005\"CAG\u0001\u0005\u0005I\u0011IAH\u0011%\t\u0019\nAA\u0001\n\u0003\n)\nC\u0005\u0002\u0018\u0002\t\t\u0011\"\u0011\u0002\u001a\"I\u00111\u0014\u0001\u0002\u0002\u0013\u0005\u0013QT\u0004\n\u0003C{\u0012\u0011!E\u0005\u0003G3\u0001BH\u0010\u0002\u0002#%\u0011Q\u0015\u0005\u0007\tb!\t!!0\t\u0013\u0005]\u0005$!A\u0005F\u0005e\u0005\u0002CA`1\u0005\u0005I\u0011Q#\t\u0013\u0005\u0005\u0007$!A\u0005\u0002\u0006\r\u0007\"CAe1\u0005\u0005I\u0011BAf\u0005E!\u0015\r^1ce&\u001c7n\u001d#jC2,7\r\u001e\u0006\u0003A\u0005\nAA\u001b3cG*\u0011!eI\u0001\u0004gFd'B\u0001\u0013&\u0003\u0015\u0019\b/\u0019:l\u0015\t1s%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Q\u0005\u0019qN]4\u0004\u0001M)\u0001aK\u00183qA\u0011A&L\u0007\u0002?%\u0011af\b\u0002\f\u0015\u0012\u00147\rR5bY\u0016\u001cG\u000f\u0005\u0002-a%\u0011\u0011g\b\u0002\u0012\u001d>dUmZ1ds*#%iQ#se>\u0014\bCA\u001a7\u001b\u0005!$\"A\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]\"$a\u0002)s_\u0012,8\r\u001e\t\u0003s\u0005s!AO \u000f\u0005mrT\"\u0001\u001f\u000b\u0005uJ\u0013A\u0002\u001fs_>$h(C\u00016\u0013\t\u0001E'A\u0004qC\u000e\\\u0017mZ3\n\u0005\t\u001b%\u0001D*fe&\fG.\u001b>bE2,'B\u0001!5\u0003\u0019a\u0014N\\5u}Q\ta\t\u0005\u0002-\u0001\u0005I1-\u00198IC:$G.\u001a\u000b\u0003\u00132\u0003\"a\r&\n\u0005-#$a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u001b\n\u0001\rAT\u0001\u0004kJd\u0007CA(T\u001d\t\u0001\u0016\u000b\u0005\u0002<i%\u0011!\u000bN\u0001\u0007!J,G-\u001a4\n\u0005Q+&AB*ue&twM\u0003\u0002Si\u0005yq-\u001a;DCR\fG._:u)f\u0004X\rF\u0003YC\u001aD'\u000eE\u000243nK!A\u0017\u001b\u0003\r=\u0003H/[8o!\tav,D\u0001^\u0015\tq\u0016%A\u0003usB,7/\u0003\u0002a;\nAA)\u0019;b)f\u0004X\rC\u0003c\u0007\u0001\u00071-A\u0004tc2$\u0016\u0010]3\u0011\u0005M\"\u0017BA35\u0005\rIe\u000e\u001e\u0005\u0006O\u000e\u0001\rAT\u0001\tif\u0004XMT1nK\")\u0011n\u0001a\u0001G\u0006!1/\u001b>f\u0011\u0015Y7\u00011\u0001m\u0003\tiG\r\u0005\u0002][&\u0011a.\u0018\u0002\u0010\u001b\u0016$\u0018\rZ1uC\n+\u0018\u000e\u001c3fe\u0006Yq-\u001a;K\t\n\u001bE+\u001f9f)\t\tX\u000fE\u000243J\u0004\"\u0001L:\n\u0005Q|\"\u0001\u0003&eE\u000e$\u0016\u0010]3\t\u000bY$\u0001\u0019A.\u0002\u0005\u0011$\u0018aD9v_R,\u0017\nZ3oi&4\u0017.\u001a:\u0015\u00059K\b\"\u0002>\u0006\u0001\u0004q\u0015aB2pY:\u000bW.Z\u0001\u000egV\u0004\bo\u001c:ug2KW.\u001b;\u0016\u0003%\u000bab];qa>\u0014Ho](gMN,G/A\ntkB\u0004xN\u001d;t)\u0006\u0014G.Z*b[BdW-\u0001\bhKR$\u0016M\u00197f'\u0006l\u0007\u000f\\3\u0015\u00079\u000b\u0019\u0001C\u0004\u0002\u0006%\u0001\r!a\u0002\u0002\rM\fW\u000e\u001d7f!\u0011\tI!a\u0006\u000e\u0005\u0005-!\u0002BA\u0007\u0003\u001f\t!A\u001e\u001a\u000b\t\u0005E\u00111C\u0001\fI\u0006$\u0018m]8ve\u000e,7OC\u0002\u0002\u0016\u0005\n\u0011\"\u001a=fGV$\u0018n\u001c8\n\t\u0005e\u00111\u0002\u0002\u0010)\u0006\u0014G.Z*b[BdW-\u00138g_\u0006a1/\u001e9q_J$8\u000fS5oi\u0006i1o\u00195f[\u0006\u001cX\t_5tiN$r!SA\u0011\u0003g\t\t\u0005C\u0004\u0002$-\u0001\r!!\n\u0002\t\r|gN\u001c\t\u0005\u0003O\ty#\u0004\u0002\u0002*)\u0019!%a\u000b\u000b\u0005\u00055\u0012\u0001\u00026bm\u0006LA!!\r\u0002*\tQ1i\u001c8oK\u000e$\u0018n\u001c8\t\u000f\u0005U2\u00021\u0001\u00028\u00059q\u000e\u001d;j_:\u001c\b\u0003BA\u001d\u0003{i!!a\u000f\u000b\u0007\u0001\ny!\u0003\u0003\u0002@\u0005m\"a\u0003&E\u0005\u000e{\u0005\u000f^5p]NDa!a\u0011\f\u0001\u0004q\u0015AB:dQ\u0016l\u0017-A\u0006mSN$8k\u00195f[\u0006\u001cHCBA%\u0003#\n\u0019\u0006E\u00034\u0003\u0017\ny%C\u0002\u0002NQ\u0012Q!\u0011:sCf\u0004BaMA&\u001d\"9\u00111\u0005\u0007A\u0002\u0005\u0015\u0002bBA\u001b\u0019\u0001\u0007\u0011qG\u0001\u0005G>\u0004\u00180A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u00037\u0002B!!\u0018\u0002d5\u0011\u0011q\f\u0006\u0005\u0003C\nY#\u0001\u0003mC:<\u0017b\u0001+\u0002`\u0005a\u0001O]8ek\u000e$\u0018I]5usV\t1-\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u00055\u00141\u000f\t\u0004g\u0005=\u0014bAA9i\t\u0019\u0011I\\=\t\u0011\u0005U\u0004#!AA\u0002\r\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA>!\u0019\ti(a!\u0002n5\u0011\u0011q\u0010\u0006\u0004\u0003\u0003#\u0014AC2pY2,7\r^5p]&!\u0011QQA@\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007%\u000bY\tC\u0005\u0002vI\t\t\u00111\u0001\u0002n\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\tY&!%\t\u0011\u0005U4#!AA\u0002\r\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002G\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\\\u00051Q-];bYN$2!SAP\u0011%\t)HFA\u0001\u0002\u0004\ti'A\tECR\f'M]5dWN$\u0015.\u00197fGR\u0004\"\u0001\f\r\u0014\u000ba\t9+a-\u0011\u000b\u0005%\u0016q\u0016$\u000e\u0005\u0005-&bAAWi\u00059!/\u001e8uS6,\u0017\u0002BAY\u0003W\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c81!\u0011\t),a/\u000e\u0005\u0005]&\u0002BA]\u0003W\t!![8\n\u0007\t\u000b9\f\u0006\u0002\u0002$\u0006)\u0011\r\u001d9ms\u00069QO\\1qa2LHcA%\u0002F\"A\u0011q\u0019\u000f\u0002\u0002\u0003\u0007a)A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!!4\u0011\t\u0005u\u0013qZ\u0005\u0005\u0003#\fyF\u0001\u0004PE*,7\r\u001e")
public class DatabricksDialect
extends JdbcDialect
implements NoLegacyJDBCError,
Product {
    public static boolean unapply(DatabricksDialect x$0) {
        return DatabricksDialect$.MODULE$.unapply(x$0);
    }

    public static DatabricksDialect apply() {
        return DatabricksDialect$.MODULE$.apply();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public Throwable classifyException(Throwable e, String condition, Map<String, String> messageParameters, String description, boolean isRuntime) {
        return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
    }

    @Override
    public boolean canHandle(String url) {
        return url.startsWith("jdbc:databricks");
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        int n = sqlType;
        switch (n) {
            case -6: {
                return new Some((Object)ByteType$.MODULE$);
            }
            case 5: {
                return new Some((Object)ShortType$.MODULE$);
            }
            case 7: {
                return new Some((Object)FloatType$.MODULE$);
            }
        }
        return None$.MODULE$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BOOLEAN", 16));
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("DOUBLE", 8));
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("STRING", 12));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BINARY", -2));
        }
        return None$.MODULE$;
    }

    @Override
    public String quoteIdentifier(String colName) {
        String escapedColName = colName.replace("`", "``");
        return "`" + escapedColName + "`";
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    @Override
    public boolean supportsTableSample() {
        return true;
    }

    @Override
    public String getTableSample(TableSampleInfo sample) {
        return "TABLESAMPLE (" + (sample.upperBound() - sample.lowerBound()) * (double)100 + ") REPEATABLE (" + sample.seed() + ")";
    }

    @Override
    public boolean supportsHint() {
        return true;
    }

    @Override
    public boolean schemasExists(Connection conn, JDBCOptions options, String schema) {
        PreparedStatement stmt = conn.prepareStatement("SHOW SCHEMAS");
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            String string = rs.getString(1);
            String string2 = schema;
            if (string != null ? !string.equals(string2) : string2 != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[][] listSchemas(Connection conn, JDBCOptions options) {
        ArrayBuilder schemaBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        PreparedStatement stmt = conn.prepareStatement("SHOW SCHEMAS");
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            schemaBuilder.$plus$eq((Object)new String[]{rs.getString(1)});
        }
        return (String[][])schemaBuilder.result();
    }

    public DatabricksDialect copy() {
        return new DatabricksDialect();
    }

    public String productPrefix() {
        return "DatabricksDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DatabricksDialect;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof DatabricksDialect && ((DatabricksDialect)x$1).canEqual(this);
    }

    public DatabricksDialect() {
        NoLegacyJDBCError.$init$(this);
        Product.$init$((Product)this);
    }
}

