/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.history;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.config.History$;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005a4A!\u0004\b\u00053!Aa\u0005\u0001B\u0001B\u0003%q\u0005C\u0003,\u0001\u0011\u0005A\u0006C\u00041\u0001\t\u0007I\u0011B\u0019\t\rU\u0002\u0001\u0015!\u00033\u0011!1\u0004A1A\u0005\u000299\u0004B\u0002#\u0001A\u0003%\u0001\b\u0003\u0005F\u0001\t\u0007I\u0011\u0001\bG\u0011\u0019\u0001\u0007\u0001)A\u0005\u000f\")\u0011\r\u0001C\u0001E\")a\r\u0001C\u0001O\")\u0001\u000f\u0001C\u0001c\")A\u000f\u0001C\u0005k\nQ\u0002*[:u_JL8+\u001a:wKJlU-\\8ss6\u000bg.Y4fe*\u0011q\u0002E\u0001\bQ&\u001cHo\u001c:z\u0015\t\t\"#\u0001\u0004eKBdw.\u001f\u0006\u0003'Q\tQa\u001d9be.T!!\u0006\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0012aA8sO\u000e\u00011c\u0001\u0001\u001bAA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t1\u0011I\\=SK\u001a\u0004\"!\t\u0013\u000e\u0003\tR!a\t\n\u0002\u0011%tG/\u001a:oC2L!!\n\u0012\u0003\u000f1{wmZ5oO\u0006!1m\u001c8g!\tA\u0013&D\u0001\u0013\u0013\tQ#CA\u0005Ta\u0006\u00148nQ8oM\u00061A(\u001b8jiz\"\"!L\u0018\u0011\u00059\u0002Q\"\u0001\b\t\u000b\u0019\u0012\u0001\u0019A\u0014\u0002\u00115\f\u00070V:bO\u0016,\u0012A\r\t\u00037MJ!\u0001\u000e\u000f\u0003\t1{gnZ\u0001\n[\u0006DXk]1hK\u0002\nAbY;se\u0016tG/V:bO\u0016,\u0012\u0001\u000f\t\u0003s\tk\u0011A\u000f\u0006\u0003wq\na!\u0019;p[&\u001c'BA\u001f?\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u007f\u0001\u000bA!\u001e;jY*\t\u0011)\u0001\u0003kCZ\f\u0017BA\";\u0005)\tEo\\7jG2{gnZ\u0001\u000eGV\u0014(/\u001a8u+N\fw-\u001a\u0011\u0002\r\u0005\u001cG/\u001b<f+\u00059\u0005\u0003\u0002%N\u001fJj\u0011!\u0013\u0006\u0003\u0015.\u000bq!\\;uC\ndWM\u0003\u0002M9\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u00059K%a\u0002%bg\"l\u0015\r\u001d\t\u00057A\u0013V,\u0003\u0002R9\t1A+\u001e9mKJ\u0002\"a\u0015.\u000f\u0005QC\u0006CA+\u001d\u001b\u00051&BA,\u0019\u0003\u0019a$o\\8u}%\u0011\u0011\fH\u0001\u0007!J,G-\u001a4\n\u0005mc&AB*ue&twM\u0003\u0002Z9A\u00191D\u0018*\n\u0005}c\"AB(qi&|g.A\u0004bGRLg/\u001a\u0011\u0002\u0015%t\u0017\u000e^5bY&TX\rF\u0001d!\tYB-\u0003\u0002f9\t!QK\\5u\u0003\u0015aW-Y:f)\u0015\u0019\u0007N\u001b7o\u0011\u0015I'\u00021\u0001S\u0003\u0015\t\u0007\u000f]%e\u0011\u0015Y'\u00021\u0001^\u0003%\tG\u000f^3naRLE\rC\u0003n\u0015\u0001\u0007!'\u0001\u0007fm\u0016tG\u000fT8h'&TX\rC\u0003p\u0015\u0001\u0007Q,A\u0003d_\u0012,7-A\u0004sK2,\u0017m]3\u0015\u0007\r\u00148\u000fC\u0003j\u0017\u0001\u0007!\u000bC\u0003l\u0017\u0001\u0007Q,\u0001\fbaB\u0014x\u000e_5nCR,W*Z7pef,6/Y4f)\r\u0011do\u001e\u0005\u0006[2\u0001\rA\r\u0005\u0006_2\u0001\r!\u0018")
public class HistoryServerMemoryManager
implements Logging {
    private final long maxUsage;
    private final AtomicLong currentUsage;
    private final HashMap<Tuple2<String, Option<String>>, Object> active;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private long maxUsage() {
        return this.maxUsage;
    }

    public AtomicLong currentUsage() {
        return this.currentUsage;
    }

    public HashMap<Tuple2<String, Option<String>>, Object> active() {
        return this.active;
    }

    public void initialize() {
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Initialized memory manager: "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"current usage = ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_BYTES_CURRENT$.MODULE$, (Object)Utils$.MODULE$.bytesToString(this.currentUsage().get()))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"max usage = ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_BYTES_MAX$.MODULE$, (Object)Utils$.MODULE$.bytesToString(this.maxUsage()))})))));
    }

    public void lease(String appId, Option<String> attemptId, long eventLogSize, Option<String> codec) {
        long memoryUsage = this.approximateMemoryUsage(eventLogSize, codec);
        if (memoryUsage + this.currentUsage().get() > this.maxUsage()) {
            throw new RuntimeException("Not enough memory to create hybrid store for app " + appId + " / " + attemptId + ".");
        }
        HashMap<Tuple2<String, Option<String>>, Object> hashMap = this.active();
        synchronized (hashMap) {
            this.active().update((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)appId), attemptId), (Object)BoxesRunTime.boxToLong((long)memoryUsage));
        }
        this.currentUsage().addAndGet(memoryUsage);
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Leasing ", " memory usage for "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_BYTES$.MODULE$, (Object)Utils$.MODULE$.bytesToString(memoryUsage))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"app ", " / ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.APP_ID$.MODULE$, (Object)appId), new MDC((LogKey)LogKeys.APP_ATTEMPT_ID$.MODULE$, (Object)attemptId)})))));
    }

    public void release(String appId, Option<String> attemptId) {
        Option memoryUsage;
        Option option;
        HashMap<Tuple2<String, Option<String>>, Object> hashMap = this.active();
        synchronized (hashMap) {
            option = this.active().remove((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)appId), attemptId));
        }
        Option option2 = memoryUsage = option;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            long m = BoxesRunTime.unboxToLong((Object)some.value());
            this.currentUsage().addAndGet(-m);
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Released ", " memory usage for "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_BYTES$.MODULE$, (Object)Utils$.MODULE$.bytesToString(m))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"app ", " / ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.APP_ID$.MODULE$, (Object)appId), new MDC((LogKey)LogKeys.APP_ATTEMPT_ID$.MODULE$, (Object)attemptId)})))));
            return;
        }
        if (None$.MODULE$.equals(option2)) {
            return;
        }
        throw new MatchError((Object)option2);
    }

    private long approximateMemoryUsage(long eventLogSize, Option<String> codec) {
        boolean bl = false;
        Some some = null;
        Option<String> option = codec;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String string = (String)some.value();
            String string2 = CompressionCodec$.MODULE$.ZSTD();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                return eventLogSize * 10L;
            }
        }
        if (bl) {
            return eventLogSize * 4L;
        }
        if (None$.MODULE$.equals(option)) {
            return eventLogSize / 2L;
        }
        throw new MatchError(option);
    }

    public HistoryServerMemoryManager(SparkConf conf) {
        Logging.$init$((Logging)this);
        this.maxUsage = BoxesRunTime.unboxToLong((Object)conf.get(History$.MODULE$.MAX_IN_MEMORY_STORE_USAGE()));
        this.currentUsage = new AtomicLong(0L);
        this.active = new HashMap();
    }
}

