/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.util;

public class ByteConversionUtil {
    public static byte[] fromShort(short input) {
        byte[] output = new byte[]{(byte)(input >> 8), (byte)input};
        return output;
    }

    public static byte[] fromInt(int input) {
        byte[] output = new byte[]{(byte)(input >> 24), (byte)(input >> 16), (byte)(input >> 8), (byte)input};
        return output;
    }

    public static byte[] fromLong(long input) {
        byte[] output = new byte[]{(byte)(input >> 56), (byte)(input >> 48), (byte)(input >> 40), (byte)(input >> 32), (byte)(input >> 24), (byte)(input >> 16), (byte)(input >> 8), (byte)input};
        return output;
    }

    public static short toShort(byte[] input) {
        if (input == null) {
            throw new IllegalArgumentException("input: parameter may not be null.");
        }
        if (input.length != 2) {
            throw new IllegalArgumentException("input: Byte array length must be 2.");
        }
        short output = 0;
        output = (short)((input[0] & 0xFF) << 8 | input[1] & 0xFF);
        return output;
    }

    public static int toInt(byte[] input) {
        if (input == null) {
            throw new IllegalArgumentException("input: parameter may not be null.");
        }
        if (input.length != 4) {
            throw new IllegalArgumentException("input: Byte array length must be 4.");
        }
        int output = 0;
        output = (input[0] & 0xFF) << 24 | (input[1] & 0xFF) << 16 | (input[2] & 0xFF) << 8 | input[3] & 0xFF;
        return output;
    }

    public static long toLong(byte[] input) {
        if (input == null) {
            throw new IllegalArgumentException("input: parameter may not be null.");
        }
        if (input.length != 8) {
            throw new IllegalArgumentException("input: Byte array length must be 8.");
        }
        long output = 0L;
        output = (long)(input[0] & 0xFF) << 56;
        output |= (long)(input[1] & 0xFF) << 48;
        output |= (long)(input[2] & 0xFF) << 40;
        output |= (long)(input[3] & 0xFF) << 32;
        output |= (long)(input[4] & 0xFF) << 24;
        output |= (long)(input[5] & 0xFF) << 16;
        output |= (long)(input[6] & 0xFF) << 8;
        return output |= (long)(input[7] & 0xFF);
    }
}

