/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.api;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Tree {
    public static final Tree[] EMPTY_ARRAY = new Tree[0];

    @NotNull
    public String getName();

    public boolean isRoot();

    @NotNull
    public String getPath();

    @NotNull
    public Status getStatus();

    public boolean exists();

    @NotNull
    public Tree getParent();

    @Nullable
    public PropertyState getProperty(@NotNull String var1);

    @Nullable
    public Status getPropertyStatus(@NotNull String var1);

    public boolean hasProperty(@NotNull String var1);

    public long getPropertyCount();

    @NotNull
    public Iterable<? extends PropertyState> getProperties();

    @NotNull
    public Tree getChild(@NotNull String var1) throws IllegalArgumentException;

    public boolean hasChild(@NotNull String var1);

    public long getChildrenCount(long var1);

    @NotNull
    public Iterable<Tree> getChildren();

    public boolean remove();

    @NotNull
    public Tree addChild(@NotNull String var1) throws IllegalArgumentException;

    public void setOrderableChildren(boolean var1);

    public boolean orderBefore(@Nullable String var1);

    public void setProperty(@NotNull PropertyState var1);

    public <T> void setProperty(@NotNull String var1, @NotNull T var2) throws IllegalArgumentException;

    public <T> void setProperty(@NotNull String var1, @NotNull T var2, @NotNull Type<T> var3) throws IllegalArgumentException;

    public void removeProperty(@NotNull String var1);

    public static enum Status {
        UNCHANGED,
        NEW,
        MODIFIED;

    }
}

